/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import androidx.annotation.RestrictTo;
import com.evernote.android.job.Job;
import com.evernote.android.job.JobCreator;
import com.evernote.android.job.util.JobCat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class JobCreatorHolder {
    private static final JobCat CAT = new JobCat("JobCreatorHolder");
    private final List<JobCreator> mJobCreators = new CopyOnWriteArrayList<JobCreator>();

    public void addJobCreator(JobCreator creator) {
        this.mJobCreators.add(creator);
    }

    public void removeJobCreator(JobCreator creator) {
        this.mJobCreators.remove(creator);
    }

    public Job createJob(String tag) {
        Job job = null;
        boolean atLeastOneCreatorSeen = false;
        for (JobCreator jobCreator : this.mJobCreators) {
            atLeastOneCreatorSeen = true;
            job = jobCreator.create(tag);
            if (job == null) continue;
            break;
        }
        if (!atLeastOneCreatorSeen) {
            CAT.w("no JobCreator added");
        }
        return job;
    }

    public boolean isEmpty() {
        return this.mJobCreators.isEmpty();
    }
}

