/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.util.Pair;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.evernote.android.job.JobManager;
import com.evernote.android.job.util.JobCat;
import java.io.File;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
final class JobStorageDatabaseErrorHandler
implements DatabaseErrorHandler {
    private static final JobCat CAT = new JobCat("DatabaseErrorHandler");

    JobStorageDatabaseErrorHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCorruption(SQLiteDatabase dbObj) {
        block12: {
            block11: {
                CAT.e("Corruption reported by sqlite on database: " + dbObj.getPath());
                if (!dbObj.isOpen()) {
                    this.deleteDatabaseFile(dbObj.getPath());
                    return;
                }
                List attachedDbs = null;
                try {
                    try {
                        attachedDbs = dbObj.getAttachedDbs();
                    }
                    catch (SQLiteException sQLiteException) {
                        // empty catch block
                    }
                    try {
                        dbObj.close();
                    }
                    catch (SQLiteException sQLiteException) {
                        // empty catch block
                    }
                    if (attachedDbs == null) break block11;
                }
                catch (Throwable throwable) {
                    if (attachedDbs != null) {
                        for (Pair p : attachedDbs) {
                            this.deleteDatabaseFile((String)p.second);
                        }
                    } else {
                        this.deleteDatabaseFile(dbObj.getPath());
                    }
                    throw throwable;
                }
                for (Pair p : attachedDbs) {
                    this.deleteDatabaseFile((String)p.second);
                }
                break block12;
            }
            this.deleteDatabaseFile(dbObj.getPath());
        }
    }

    void deleteDatabaseFile(String fileName) {
        if (fileName.equalsIgnoreCase(":memory:") || fileName.trim().length() == 0) {
            return;
        }
        CAT.e("deleting the database file: " + fileName);
        try {
            File databaseFile = new File(fileName);
            if (Build.VERSION.SDK_INT >= 16) {
                this.deleteApi16(databaseFile);
            } else {
                this.deleteApi14(JobManager.instance().getContext(), databaseFile);
            }
        }
        catch (Exception e) {
            CAT.w(e, "delete failed: " + e.getMessage(), new Object[0]);
        }
    }

    @TargetApi(value=16)
    @VisibleForTesting
    void deleteApi16(File databaseFile) {
        SQLiteDatabase.deleteDatabase((File)databaseFile);
    }

    @VisibleForTesting
    void deleteApi14(Context context, File databaseFile) {
        context.deleteDatabase(databaseFile.getName());
    }
}

