/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.job.v14;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.evernote.android.job.JobConfig;
import com.evernote.android.job.JobProxy;
import com.evernote.android.job.util.JobCat;
import com.evernote.android.job.v14.PlatformAlarmService;
import java.util.HashSet;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class PlatformAlarmServiceExact
extends Service {
    private static final JobCat CAT = new JobCat("PlatformAlarmServiceExact");
    private final Object mMonitor = new Object();
    private volatile Set<Integer> mStartIds;
    private volatile int mLastStartId;

    public static Intent createIntent(Context context, int jobId, @Nullable Bundle transientExtras) {
        Intent intent = new Intent(context, PlatformAlarmServiceExact.class);
        intent.putExtra("EXTRA_JOB_ID", jobId);
        if (transientExtras != null) {
            intent.putExtra("EXTRA_TRANSIENT_EXTRAS", transientExtras);
        }
        return intent;
    }

    public void onCreate() {
        super.onCreate();
        this.mStartIds = new HashSet<Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(final @Nullable Intent intent, int flags, final int startId) {
        Object object = this.mMonitor;
        synchronized (object) {
            this.mStartIds.add(startId);
            this.mLastStartId = startId;
        }
        JobConfig.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformAlarmService.runJob(intent, PlatformAlarmServiceExact.this, CAT);
                }
                finally {
                    JobProxy.Common.completeWakefulIntent(intent);
                    PlatformAlarmServiceExact.this.stopSelfIfNecessary(startId);
                }
            }
        });
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Object object = this.mMonitor;
        synchronized (object) {
            this.mStartIds = null;
            this.mLastStartId = 0;
        }
    }

    public final IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSelfIfNecessary(int startId) {
        Object object = this.mMonitor;
        synchronized (object) {
            Set<Integer> startIds = this.mStartIds;
            if (startIds != null) {
                startIds.remove(startId);
                if (startIds.isEmpty()) {
                    this.stopSelfResult(this.mLastStartId);
                }
            }
        }
    }
}

