/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.text.TextUtils;
import com.evernote.client.android.EvernoteSession;

public class AuthenticationResult {
    private static final String KEY_AUTH_TOKEN = "evernote.mAuthToken";
    private static final String KEY_NOTESTORE_URL = "evernote.notestoreUrl";
    private static final String KEY_WEB_API_URL_PREFIX = "evernote.webApiUrlPrefix";
    private static final String KEY_USER_ID = "evernote.userId";
    private static final String KEY_EVERNOTE_HOST = "evernote.mEvernoteHost";
    private static final String KEY_IS_APP_LINKED_NOTEBOOK = "evernote.isAppLinkedNotebook";
    private static final String PREFERENCE_NAME = "evernote.preferences";
    private String mAuthToken;
    private String mNoteStoreUrl;
    private String mWebApiUrlPrefix;
    private String mEvernoteHost;
    private int mUserId;
    private boolean mIsAppLinkedNotebook;

    static AuthenticationResult fromPreferences(Context context) {
        SharedPreferences prefs = AuthenticationResult.getPreferences(context);
        String authToken = prefs.getString(KEY_AUTH_TOKEN, null);
        String noteStoreUrl = prefs.getString(KEY_NOTESTORE_URL, null);
        if (TextUtils.isEmpty((CharSequence)authToken) || TextUtils.isEmpty((CharSequence)noteStoreUrl)) {
            return null;
        }
        return new AuthenticationResult(authToken, noteStoreUrl, prefs.getString(KEY_WEB_API_URL_PREFIX, null), prefs.getString(KEY_EVERNOTE_HOST, null), prefs.getInt(KEY_USER_ID, -1), prefs.getBoolean(KEY_IS_APP_LINKED_NOTEBOOK, false));
    }

    AuthenticationResult(String authToken, String noteStoreUrl, boolean isAppLinkedNotebook) {
        this(authToken, noteStoreUrl, AuthenticationResult.parseWebApiUrlPrefix(noteStoreUrl), AuthenticationResult.parseHost(noteStoreUrl), -1, isAppLinkedNotebook);
    }

    AuthenticationResult(String authToken, String noteStoreUrl, String webApiUrlPrefix, String evernoteHost, int userId, boolean isAppLinkedNotebook) {
        this.mAuthToken = authToken;
        this.mNoteStoreUrl = noteStoreUrl;
        this.mWebApiUrlPrefix = webApiUrlPrefix;
        this.mEvernoteHost = evernoteHost;
        this.mUserId = userId;
        this.mIsAppLinkedNotebook = isAppLinkedNotebook;
    }

    void persist() {
        AuthenticationResult.getPreferences(EvernoteSession.getInstance().getApplicationContext()).edit().putString(KEY_AUTH_TOKEN, this.mAuthToken).putString(KEY_NOTESTORE_URL, this.mNoteStoreUrl).putString(KEY_WEB_API_URL_PREFIX, this.mWebApiUrlPrefix).putString(KEY_EVERNOTE_HOST, this.mEvernoteHost).putInt(KEY_USER_ID, this.mUserId).putBoolean(KEY_IS_APP_LINKED_NOTEBOOK, this.mIsAppLinkedNotebook).apply();
    }

    void clear() {
        AuthenticationResult.getPreferences(EvernoteSession.getInstance().getApplicationContext()).edit().remove(KEY_AUTH_TOKEN).remove(KEY_NOTESTORE_URL).remove(KEY_WEB_API_URL_PREFIX).remove(KEY_EVERNOTE_HOST).remove(KEY_USER_ID).remove(KEY_IS_APP_LINKED_NOTEBOOK).apply();
    }

    public String getAuthToken() {
        return this.mAuthToken;
    }

    public String getNoteStoreUrl() {
        return this.mNoteStoreUrl;
    }

    public String getWebApiUrlPrefix() {
        return this.mWebApiUrlPrefix;
    }

    public String getEvernoteHost() {
        return this.mEvernoteHost;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public boolean isAppLinkedNotebook() {
        return this.mIsAppLinkedNotebook;
    }

    protected static SharedPreferences getPreferences(Context context) {
        return context.getSharedPreferences(PREFERENCE_NAME, 0);
    }

    private static String parseWebApiUrlPrefix(String noteStoreUrl) {
        int index = noteStoreUrl.indexOf("notestore");
        if (index > 0) {
            return noteStoreUrl.substring(0, index);
        }
        return noteStoreUrl;
    }

    private static String parseHost(String noteStoreUrl) {
        return Uri.parse((String)noteStoreUrl).getHost();
    }
}

