/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import android.util.Log;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.android.EvernoteUtil;
import com.evernote.client.android.asyncclient.EvernoteUserStoreClient;
import com.evernote.edam.userstore.BootstrapInfo;
import com.evernote.edam.userstore.BootstrapProfile;
import com.evernote.thrift.TException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

class BootstrapManager {
    private static final String LOGTAG = "EvernoteSession";
    public static final List<Locale> CHINA_LOCALES = Collections.unmodifiableList(Arrays.asList(Locale.TRADITIONAL_CHINESE, Locale.CHINESE, Locale.CHINA, Locale.SIMPLIFIED_CHINESE));
    private ArrayList<String> mBootstrapServerUrls = new ArrayList();
    private Locale mLocale;
    private String mBootstrapServerUsed;
    private final EvernoteSession mEvernoteSession;

    BootstrapManager(EvernoteSession session) {
        this(session.getEvernoteService(), session);
    }

    BootstrapManager(EvernoteSession.EvernoteService service, EvernoteSession session) {
        this(service, session, Locale.getDefault());
    }

    BootstrapManager(EvernoteSession.EvernoteService service, EvernoteSession session, Locale locale) {
        this.mEvernoteSession = session;
        this.mLocale = locale;
        this.mBootstrapServerUrls.clear();
        switch (service) {
            case PRODUCTION: {
                if (CHINA_LOCALES.contains(this.mLocale)) {
                    this.mBootstrapServerUrls.add("https://app.yinxiang.com");
                }
                this.mBootstrapServerUrls.add("https://www.evernote.com");
                break;
            }
            case SANDBOX: {
                this.mBootstrapServerUrls.add("https://sandbox.evernote.com");
            }
        }
    }

    private void initializeUserStoreAndCheckVersion() throws Exception {
        int i = 0;
        String version = "1.25";
        for (String url : this.mBootstrapServerUrls) {
            ++i;
            try {
                EvernoteUserStoreClient userStoreClient = this.mEvernoteSession.getEvernoteClientFactory().getUserStoreClient(this.getUserStoreUrl(url), null);
                if (!userStoreClient.checkVersion(EvernoteUtil.generateUserAgentString(this.mEvernoteSession.getApplicationContext()), (short)1, (short)25)) {
                    throw new ClientUnsupportedException(version);
                }
                this.mBootstrapServerUsed = url;
                return;
            }
            catch (ClientUnsupportedException cue) {
                Log.e((String)LOGTAG, (String)"Invalid Version", (Throwable)cue);
                throw cue;
            }
            catch (Exception e) {
                if (i < this.mBootstrapServerUrls.size()) {
                    Log.e((String)LOGTAG, (String)("Error contacting bootstrap server=" + url), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
    }

    BootstrapInfoWrapper getBootstrapInfo() throws Exception {
        Log.d((String)LOGTAG, (String)"getBootstrapInfo()");
        BootstrapInfo bsInfo = null;
        try {
            if (this.mBootstrapServerUsed == null) {
                this.initializeUserStoreAndCheckVersion();
            }
            bsInfo = this.mEvernoteSession.getEvernoteClientFactory().getUserStoreClient(this.getUserStoreUrl(this.mBootstrapServerUsed), null).getBootstrapInfo(this.mLocale.toString());
            this.printBootstrapInfo(bsInfo);
        }
        catch (TException e) {
            Log.e((String)LOGTAG, (String)"error getting bootstrap info", (Throwable)e);
        }
        return new BootstrapInfoWrapper(this.mBootstrapServerUsed, bsInfo);
    }

    void printBootstrapInfo(BootstrapInfo bsInfo) {
        if (bsInfo == null) {
            return;
        }
        Log.d((String)LOGTAG, (String)"printBootstrapInfo");
        List profiles = bsInfo.getProfiles();
        if (profiles != null) {
            for (BootstrapProfile profile : profiles) {
                Log.d((String)LOGTAG, (String)profile.toString());
            }
        } else {
            Log.d((String)LOGTAG, (String)"Profiles are null");
        }
    }

    private String getUserStoreUrl(String bootstrapServer) {
        return bootstrapServer + "/edam/user";
    }

    public static class ClientUnsupportedException
    extends Exception {
        public ClientUnsupportedException(String version) {
            super("Client version " + version + " not supported.");
        }
    }

    static class BootstrapInfoWrapper {
        private String mServerUrl;
        private BootstrapInfo mBootstrapInfo;

        BootstrapInfoWrapper(String serverUrl, BootstrapInfo info) {
            this.mServerUrl = serverUrl;
            this.mBootstrapInfo = info;
        }

        String getServerUrl() {
            return this.mServerUrl;
        }

        BootstrapInfo getBootstrapInfo() {
            return this.mBootstrapInfo;
        }
    }
}

