/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.evernote.client.android.helper.Cat;

public class EvernoteOAuthActivity
extends FragmentActivity {
    private static final Cat CAT = new Cat("EvernoteOAuthActivity");
    private static final String HOST_EVERNOTE = "www.evernote.com";
    private static final String HOST_SANDBOX = "sandbox.evernote.com";
    private static final String HOST_CHINA = "app.yinxiang.com";

    public static Intent createIntent(Context context, String url) {
        Intent intent = new Intent(context, EvernoteOAuthActivity.class);
        intent.putExtra("authorization_url", url);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setResultUri(null);
        String url = this.getIntent().getStringExtra("authorization_url");
        if (TextUtils.isEmpty((CharSequence)url)) {
            CAT.w("no uri passed, return cancelled");
            this.finish();
            return;
        }
        Uri uri = Uri.parse((String)url);
        if (!"https".equalsIgnoreCase(uri.getScheme())) {
            CAT.w("https required, return cancelled");
            this.finish();
            return;
        }
        String host = uri.getHost();
        if (!(HOST_EVERNOTE.equalsIgnoreCase(host) || HOST_SANDBOX.equalsIgnoreCase(host) || HOST_CHINA.equalsIgnoreCase(host))) {
            CAT.w("unacceptable host, return cancelled");
            this.finish();
            return;
        }
        if (savedInstanceState == null) {
            this.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)new WebViewFragment()).commit();
        }
    }

    private void setResultUri(String clickedOAuthUri) {
        Intent data = new Intent();
        data.putExtra("oauth_callback_url", clickedOAuthUri);
        this.setResult(TextUtils.isEmpty((CharSequence)clickedOAuthUri) ? 0 : -1, data);
    }

    public static class WebViewFragment
    extends Fragment {
        private static final String INTENT_KEY = "IntentKey";
        private WebView mWebView;
        private boolean mIsWebViewAvailable;
        private String mUrl;
        private WebViewClient mWebViewClient = new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Uri uri = Uri.parse((String)url);
                if ("en-oauth".equals(uri.getScheme())) {
                    ((EvernoteOAuthActivity)WebViewFragment.this.getActivity()).setResultUri(url);
                    WebViewFragment.this.getActivity().finish();
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }
        };

        public static WebViewFragment createInstance() {
            WebViewFragment fragment = new WebViewFragment();
            fragment.setRetainInstance(true);
            return fragment;
        }

        public void onAttach(Activity activity) {
            if (!(activity instanceof EvernoteOAuthActivity)) {
                throw new IllegalArgumentException();
            }
            super.onAttach(activity);
            this.mUrl = activity.getIntent().getStringExtra("authorization_url");
        }

        @SuppressLint(value={"SetJavaScriptEnabled"})
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            this.destroyWebView();
            this.mWebView = new WebView((Context)this.getActivity());
            this.mWebView.setWebViewClient(this.mWebViewClient);
            this.mWebView.getSettings().setJavaScriptEnabled(true);
            if (savedInstanceState == null) {
                this.mWebView.loadUrl(this.mUrl);
            } else {
                this.mWebView.restoreState(savedInstanceState);
            }
            this.mIsWebViewAvailable = true;
            return this.mWebView;
        }

        public void onPause() {
            super.onPause();
            this.mWebView.onPause();
        }

        public void onResume() {
            this.mWebView.onResume();
            super.onResume();
        }

        public void onDestroyView() {
            this.mIsWebViewAvailable = false;
            super.onDestroyView();
        }

        public void onDestroy() {
            this.destroyWebView();
            super.onDestroy();
        }

        public void onSaveInstanceState(Bundle outState) {
            super.onSaveInstanceState(outState);
            this.mWebView.saveState(outState);
        }

        public WebView getWebView() {
            return this.mIsWebViewAvailable ? this.mWebView : null;
        }

        private void destroyWebView() {
            if (this.mWebView != null) {
                ViewGroup viewGroup = (ViewGroup)this.mWebView.getParent();
                if (viewGroup != null) {
                    viewGroup.removeView((View)this.mWebView);
                }
                this.mWebView.destroy();
                this.mWebView = null;
            }
        }
    }
}

