/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.evernote.client.android.AuthenticationResult;
import com.evernote.client.android.BootstrapManager;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.android.EvernoteUtil;
import com.evernote.client.android.helper.Cat;
import com.evernote.client.android.helper.EvernotePreconditions;
import com.evernote.edam.userstore.BootstrapInfo;
import com.evernote.edam.userstore.BootstrapProfile;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.EvernoteApi;
import org.scribe.exceptions.OAuthException;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import org.scribe.utils.OAuthEncoder;

public class EvernoteOAuthHelper {
    public static final String CHINA_PROFILE_NAME = "Evernote-China";
    protected static final String CALLBACK_SCHEME = "en-oauth";
    protected static final Cat CAT = new Cat("OAuthHelper");
    protected static final Pattern NOTE_STORE_REGEX = Pattern.compile("edam_noteStoreUrl=([^&]+)");
    protected static final Pattern WEB_API_REGEX = Pattern.compile("edam_webApiUrlPrefix=([^&]+)");
    protected static final Pattern USER_ID_REGEX = Pattern.compile("edam_userId=([^&]+)");
    protected final EvernoteSession mSession;
    protected final String mConsumerKey;
    protected final String mConsumerSecret;
    protected final boolean mSupportAppLinkedNotebooks;
    protected final Locale mLocale;
    protected BootstrapProfile mBootstrapProfile;
    protected OAuthService mOAuthService;
    protected Token mRequestToken;

    public EvernoteOAuthHelper(EvernoteSession session, String consumerKey, String consumerSecret, boolean supportAppLinkedNotebooks) {
        this(session, consumerKey, consumerSecret, supportAppLinkedNotebooks, Locale.getDefault());
    }

    public EvernoteOAuthHelper(EvernoteSession session, String consumerKey, String consumerSecret, boolean supportAppLinkedNotebooks, Locale locale) {
        this.mSession = EvernotePreconditions.checkNotNull(session);
        this.mConsumerKey = EvernotePreconditions.checkNotEmpty(consumerKey);
        this.mConsumerSecret = EvernotePreconditions.checkNotEmpty(consumerSecret);
        this.mSupportAppLinkedNotebooks = supportAppLinkedNotebooks;
        this.mLocale = EvernotePreconditions.checkNotNull(locale);
    }

    public List<BootstrapProfile> fetchBootstrapProfiles() throws Exception {
        BootstrapManager.BootstrapInfoWrapper infoWrapper = new BootstrapManager(this.mSession.getEvernoteService(), this.mSession, this.mLocale).getBootstrapInfo();
        if (infoWrapper == null) {
            return null;
        }
        BootstrapInfo info = infoWrapper.getBootstrapInfo();
        if (info == null) {
            return null;
        }
        return info.getProfiles();
    }

    public BootstrapProfile getDefaultBootstrapProfile(List<BootstrapProfile> bootstrapProfiles) {
        EvernotePreconditions.checkCollectionNotEmpty(bootstrapProfiles, "bootstrapProfiles");
        return bootstrapProfiles.get(0);
    }

    public void setBootstrapProfile(BootstrapProfile bootstrapProfile) {
        this.mBootstrapProfile = EvernotePreconditions.checkNotNull(bootstrapProfile);
    }

    public void initialize() throws Exception {
        if (this.mBootstrapProfile == null) {
            List<BootstrapProfile> bootstrapProfiles = this.fetchBootstrapProfiles();
            this.setBootstrapProfile(this.getDefaultBootstrapProfile(bootstrapProfiles));
        }
        this.mOAuthService = EvernoteOAuthHelper.createOAuthService(this.mBootstrapProfile, this.mConsumerKey, this.mConsumerSecret);
    }

    public Token createRequestToken() {
        this.mRequestToken = this.mOAuthService.getRequestToken();
        return this.mRequestToken;
    }

    public String createAuthorizationUrl(Token requestToken) {
        String url = this.mOAuthService.getAuthorizationUrl(requestToken);
        if (this.mSupportAppLinkedNotebooks) {
            url = url + "&supportLinkedSandbox=true";
        }
        return url;
    }

    public Intent startAuthorization(Activity activity) {
        try {
            this.initialize();
        }
        catch (Exception e) {
            CAT.e(e);
            return null;
        }
        this.createRequestToken();
        String authorizationUrl = this.createAuthorizationUrl(this.mRequestToken);
        return EvernoteUtil.createAuthorizationIntent((Context)activity, authorizationUrl, this.mSession.isForceAuthenticationInThirdPartyApp());
    }

    public boolean finishAuthorization(Activity activity, int resultCode, Intent data) {
        boolean isAppLinkedNotebook;
        if (resultCode != -1 || data == null) {
            return false;
        }
        String url = data.getStringExtra("oauth_callback_url");
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        Uri uri = Uri.parse((String)url);
        String verifierString = uri.getQueryParameter("oauth_verifier");
        String appLnbString = uri.getQueryParameter("sandbox_lnb");
        boolean bl = isAppLinkedNotebook = !TextUtils.isEmpty((CharSequence)appLnbString) && "true".equalsIgnoreCase(appLnbString);
        if (TextUtils.isEmpty((CharSequence)verifierString)) {
            CAT.i("User did not authorize access");
            return false;
        }
        Verifier verifier = new Verifier(verifierString);
        try {
            Token accessToken = this.mOAuthService.getAccessToken(this.mRequestToken, verifier);
            String rawResponse = accessToken.getRawResponse();
            String authToken = accessToken.getToken();
            String noteStoreUrl = EvernoteOAuthHelper.extract(rawResponse, NOTE_STORE_REGEX);
            String webApiUrlPrefix = EvernoteOAuthHelper.extract(rawResponse, WEB_API_REGEX);
            int userId = Integer.parseInt(EvernoteOAuthHelper.extract(rawResponse, USER_ID_REGEX));
            String evernoteHost = this.mBootstrapProfile.getSettings().getServiceHost();
            AuthenticationResult authenticationResult = new AuthenticationResult(authToken, noteStoreUrl, webApiUrlPrefix, evernoteHost, userId, isAppLinkedNotebook);
            authenticationResult.persist();
            this.mSession.setAuthenticationResult(authenticationResult);
            return true;
        }
        catch (Exception e) {
            CAT.e("Failed to obtain OAuth access token", e);
            return false;
        }
    }

    protected static OAuthService createOAuthService(BootstrapProfile bootstrapProfile, String consumerKey, String consumerSecret) {
        Class<EvernoteApi.Sandbox> apiClass;
        String host = bootstrapProfile.getSettings().getServiceHost();
        if (host == null) {
            return null;
        }
        Uri uri = new Uri.Builder().authority(host).scheme("https").build();
        switch (uri.toString()) {
            case "https://sandbox.evernote.com": {
                apiClass = EvernoteApi.Sandbox.class;
                break;
            }
            case "https://www.evernote.com": {
                apiClass = EvernoteApi.class;
                break;
            }
            case "https://app.yinxiang.com": {
                apiClass = EvernoteApi.Yinxiang.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Evernote host: " + host);
            }
        }
        return new ServiceBuilder().provider(apiClass).apiKey(consumerKey).apiSecret(consumerSecret).callback("en-oauth://callback").build();
    }

    private static String extract(String response, Pattern p) {
        Matcher matcher = p.matcher(response);
        if (matcher.find() && matcher.groupCount() >= 1) {
            return OAuthEncoder.decode((String)matcher.group(1));
        }
        throw new OAuthException("Response body is incorrect. Can't extract token and secret from this: " + response);
    }
}

