/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import android.app.Activity;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import com.evernote.client.android.AuthenticationResult;
import com.evernote.client.android.EvernoteUtil;
import com.evernote.client.android.asyncclient.EvernoteClientFactory;
import com.evernote.client.android.helper.Cat;
import com.evernote.client.android.helper.EvernotePreconditions;
import com.evernote.client.android.login.EvernoteLoginActivity;
import com.evernote.client.android.login.EvernoteLoginFragment;
import java.util.Locale;

public final class EvernoteSession {
    public static final String HOST_SANDBOX = "https://sandbox.evernote.com";
    public static final String HOST_PRODUCTION = "https://www.evernote.com";
    public static final String HOST_CHINA = "https://app.yinxiang.com";
    public static final String SCREEN_NAME_YXBIJI = "\u5370\u8c61\u7b14\u8bb0";
    public static final String SCREEN_NAME_INTERNATIONAL = "Evernote International";
    public static final int REQUEST_CODE_LOGIN = 14390;
    private static final Cat CAT = new Cat("EvernoteSession");
    private static EvernoteSession sInstance = null;
    private Context mApplicationContext;
    private String mConsumerKey;
    private String mConsumerSecret;
    private EvernoteService mEvernoteService;
    private AuthenticationResult mAuthenticationResult;
    private boolean mSupportAppLinkedNotebooks;
    private boolean mForceAuthenticationInThirdPartyApp;
    private Locale mLocale;
    private EvernoteClientFactory.Builder mEvernoteClientFactoryBuilder;
    private ThreadLocal<EvernoteClientFactory> mFactoryThreadLocal;

    public static EvernoteSession getInstance() {
        return sInstance;
    }

    private EvernoteSession() {
    }

    protected EvernoteService getEvernoteService() {
        return this.mEvernoteService;
    }

    public synchronized EvernoteClientFactory getEvernoteClientFactory() {
        EvernoteClientFactory factory;
        if (this.mFactoryThreadLocal == null) {
            this.mFactoryThreadLocal = new ThreadLocal();
        }
        if (this.mEvernoteClientFactoryBuilder == null) {
            this.mEvernoteClientFactoryBuilder = new EvernoteClientFactory.Builder(this);
        }
        if ((factory = this.mFactoryThreadLocal.get()) == null) {
            factory = this.mEvernoteClientFactoryBuilder.build();
            this.mFactoryThreadLocal.set(factory);
        }
        return factory;
    }

    public synchronized void setEvernoteClientFactoryBuilder(EvernoteClientFactory.Builder builder) {
        this.mEvernoteClientFactoryBuilder = EvernotePreconditions.checkNotNull(builder);
        this.mFactoryThreadLocal = null;
    }

    public Context getApplicationContext() {
        return this.mApplicationContext;
    }

    public String getAuthToken() {
        if (this.mAuthenticationResult != null) {
            return this.mAuthenticationResult.getAuthToken();
        }
        return null;
    }

    public AuthenticationResult getAuthenticationResult() {
        return this.mAuthenticationResult;
    }

    public void authenticate(FragmentActivity activity) {
        this.authenticate(activity, EvernoteLoginFragment.create(this.mConsumerKey, this.mConsumerSecret, this.mSupportAppLinkedNotebooks, this.mLocale));
    }

    public void authenticate(FragmentActivity activity, EvernoteLoginFragment fragment) {
        fragment.show(activity.getSupportFragmentManager(), "EvernoteDialogFragment");
    }

    public void authenticate(Activity activity) {
        activity.startActivityForResult(EvernoteLoginActivity.createIntent((Context)activity, this.mConsumerKey, this.mConsumerSecret, this.mSupportAppLinkedNotebooks, this.mLocale), 14390);
    }

    public EvernoteSession asSingleton() {
        sInstance = this;
        return this;
    }

    protected synchronized void setAuthenticationResult(AuthenticationResult authenticationResult) {
        this.mAuthenticationResult = authenticationResult;
    }

    public synchronized boolean isLoggedIn() {
        return this.mAuthenticationResult != null;
    }

    public synchronized boolean logOut() {
        if (!this.isLoggedIn()) {
            return false;
        }
        this.mAuthenticationResult.clear();
        this.mAuthenticationResult = null;
        EvernoteUtil.removeAllCookies(this.getApplicationContext());
        return true;
    }

    boolean isForceAuthenticationInThirdPartyApp() {
        return this.mForceAuthenticationInThirdPartyApp;
    }

    public static class Builder {
        private final Context mContext;
        private EvernoteService mEvernoteService;
        private boolean mSupportAppLinkedNotebooks;
        private Locale mLocale;
        private boolean mForceAuthenticationInThirdPartyApp;

        public Builder(Context context) {
            EvernotePreconditions.checkNotNull(context);
            this.mContext = context.getApplicationContext();
            this.mSupportAppLinkedNotebooks = true;
            this.mEvernoteService = EvernoteService.SANDBOX;
            this.mLocale = Locale.getDefault();
        }

        public Builder setEvernoteService(EvernoteService evernoteService) {
            this.mEvernoteService = EvernotePreconditions.checkNotNull(evernoteService);
            return this;
        }

        public Builder setSupportAppLinkedNotebooks(boolean supportAppLinkedNotebooks) {
            this.mSupportAppLinkedNotebooks = supportAppLinkedNotebooks;
            return this;
        }

        public Builder setForceAuthenticationInThirdPartyApp(boolean forceAuthenticationInThirdPartyApp) {
            this.mForceAuthenticationInThirdPartyApp = forceAuthenticationInThirdPartyApp;
            return this;
        }

        public Builder setLocale(Locale locale) {
            this.mLocale = EvernotePreconditions.checkNotNull(locale);
            return this;
        }

        public EvernoteSession build(String consumerKey, String consumerSecret) {
            EvernoteSession evernoteSession = new EvernoteSession();
            evernoteSession.mConsumerKey = EvernotePreconditions.checkNotEmpty(consumerKey);
            evernoteSession.mConsumerSecret = EvernotePreconditions.checkNotEmpty(consumerSecret);
            evernoteSession.mAuthenticationResult = AuthenticationResult.fromPreferences(this.mContext);
            return this.build(evernoteSession);
        }

        public EvernoteSession buildForSingleUser(String developerToken, String noteStoreUrl) {
            EvernoteSession evernoteSession = new EvernoteSession();
            evernoteSession.mAuthenticationResult = new AuthenticationResult(EvernotePreconditions.checkNotEmpty(developerToken), EvernotePreconditions.checkNotEmpty(noteStoreUrl), this.mSupportAppLinkedNotebooks);
            return this.build(evernoteSession);
        }

        private EvernoteSession build(EvernoteSession session) {
            session.mApplicationContext = this.mContext;
            session.mLocale = this.mLocale;
            session.mSupportAppLinkedNotebooks = this.mSupportAppLinkedNotebooks;
            session.mEvernoteService = this.mEvernoteService;
            session.mForceAuthenticationInThirdPartyApp = this.mForceAuthenticationInThirdPartyApp;
            return session;
        }
    }

    public static enum EvernoteService implements Parcelable
    {
        SANDBOX,
        PRODUCTION;

        public static final Parcelable.Creator<EvernoteService> CREATOR;

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<EvernoteService>(){

                public EvernoteService createFromParcel(Parcel source) {
                    return EvernoteService.values()[source.readInt()];
                }

                public EvernoteService[] newArray(int size) {
                    return new EvernoteService[size];
                }
            };
        }
    }
}

