/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.util.Base64;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.ValueCallback;
import com.evernote.client.android.EvernoteOAuthActivity;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.android.helper.Cat;
import com.evernote.edam.type.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;

public final class EvernoteUtil {
    private static final Cat CAT;
    public static final String ACTION_AUTHORIZE = "com.evernote.action.AUTHORIZE";
    public static final String ACTION_GET_BOOTSTRAP_PROFILE_NAME = "com.evernote.action.GET_BOOTSTRAP_PROFILE_NAME";
    public static final String EXTRA_AUTHORIZATION_URL = "authorization_url";
    public static final String EXTRA_OAUTH_CALLBACK_URL = "oauth_callback_url";
    public static final String EXTRA_BOOTSTRAP_PROFILE_NAME = "bootstrap_profile_name";
    public static final String NOTE_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\"><en-note>";
    public static final String NOTE_SUFFIX = "</en-note>";
    private static final String EDAM_HASH_ALGORITHM = "MD5";
    private static final MessageDigest HASH_DIGEST;
    private static final String PACKAGE_NAME = "com.evernote";
    private static final String EVERNOTE_SIGNATURE = "XS7HhF3x8-kho4iOnAQIdP7_m4UsbRKgaEAr1HaXwnc=";

    private EvernoteUtil() {
    }

    public static String createEnMediaTag(Resource resource) {
        return "<en-media hash=\"" + EvernoteUtil.bytesToHex(resource.getData().getBodyHash()) + "\" type=\"" + resource.getMime() + "\"/>";
    }

    public static byte[] hash(byte[] body) {
        if (HASH_DIGEST != null) {
            return HASH_DIGEST.digest(body);
        }
        throw new EvernoteUtilException("MD5 not supported", new NoSuchAlgorithmException(EDAM_HASH_ALGORITHM));
    }

    public static byte[] hash(InputStream in) throws IOException {
        int n;
        if (HASH_DIGEST == null) {
            throw new EvernoteUtilException("MD5 not supported", new NoSuchAlgorithmException(EDAM_HASH_ALGORITHM));
        }
        byte[] buf = new byte[1024];
        while ((n = in.read(buf)) != -1) {
            HASH_DIGEST.update(buf, 0, n);
        }
        return HASH_DIGEST.digest();
    }

    public static String bytesToHex(byte[] bytes) {
        return EvernoteUtil.bytesToHex(bytes, false);
    }

    public static String bytesToHex(byte[] bytes, boolean withSpaces) {
        StringBuilder sb = new StringBuilder();
        for (byte hashByte : bytes) {
            int intVal = 0xFF & hashByte;
            if (intVal < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(intVal));
            if (!withSpaces) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static byte[] hexToBytes(String hexString) {
        byte[] result = new byte[hexString.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            int offset = i * 2;
            result[i] = (byte)Integer.parseInt(hexString.substring(offset, offset + 2), 16);
        }
        return result;
    }

    public static void removeAllCookies(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            EvernoteUtil.removeAllCookiesV21();
        } else {
            EvernoteUtil.removeAllCookiesV14(context.getApplicationContext());
        }
    }

    private static void removeAllCookiesV14(Context context) {
        CookieSyncManager.createInstance((Context)context);
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.removeAllCookie();
    }

    @TargetApi(value=21)
    private static void removeAllCookiesV21() {
        final CookieManager cookieManager = CookieManager.getInstance();
        Looper looper = Looper.myLooper();
        boolean prepared = false;
        if (looper == null) {
            Looper.prepare();
            prepared = true;
        }
        cookieManager.removeAllCookies((ValueCallback)new ValueCallback<Boolean>(){

            public void onReceiveValue(Boolean value) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        cookieManager.flush();
                    }
                };
                thread.start();
            }
        });
        if (prepared && (looper = Looper.myLooper()) != null) {
            looper.quit();
        }
    }

    public static EvernoteInstallStatus getEvernoteInstallStatus(Context context, String action) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List resolveInfos = packageManager.queryIntentActivities(intent = new Intent(action).setPackage(PACKAGE_NAME), 65536);
        if (!resolveInfos.isEmpty()) {
            return EvernoteUtil.validateSignature(packageManager);
        }
        try {
            packageManager.getPackageInfo(PACKAGE_NAME, 1);
            return EvernoteInstallStatus.OLD_VERSION;
        }
        catch (Exception e) {
            return EvernoteInstallStatus.NOT_INSTALLED;
        }
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private static EvernoteInstallStatus validateSignature(PackageManager packageManager) {
        PackageInfo packageInfo;
        MessageDigest digest = EvernoteUtil.getSha256Digest();
        if (digest == null) {
            return EvernoteInstallStatus.NOT_INSTALLED;
        }
        try {
            packageInfo = packageManager.getPackageInfo(PACKAGE_NAME, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return EvernoteInstallStatus.NOT_INSTALLED;
        }
        if (packageInfo.signatures == null || packageInfo.signatures.length == 0) {
            return EvernoteInstallStatus.NOT_INSTALLED;
        }
        for (Signature signature : packageInfo.signatures) {
            digest.update(signature.toByteArray());
            String appSignature = EvernoteUtil.encodeBase64(digest.digest());
            if (!EVERNOTE_SIGNATURE.equals(appSignature)) continue;
            return EvernoteInstallStatus.INSTALLED;
        }
        return EvernoteInstallStatus.NOT_INSTALLED;
    }

    public static Intent createAuthorizationIntent(Context context, String authorizationUrl, boolean forceThirdPartyApp) {
        Intent intent;
        if (!forceThirdPartyApp && EvernoteInstallStatus.INSTALLED.equals((Object)EvernoteUtil.getEvernoteInstallStatus(context, ACTION_AUTHORIZE))) {
            intent = new Intent(ACTION_AUTHORIZE);
            intent.setPackage(PACKAGE_NAME);
        } else {
            intent = new Intent(context, EvernoteOAuthActivity.class);
        }
        intent.putExtra(EXTRA_AUTHORIZATION_URL, authorizationUrl);
        return intent;
    }

    public static Intent createGetBootstrapProfileNameIntent(Context context, EvernoteSession evernoteSession) {
        if (evernoteSession.isForceAuthenticationInThirdPartyApp()) {
            return null;
        }
        EvernoteInstallStatus installStatus = EvernoteUtil.getEvernoteInstallStatus(context, ACTION_GET_BOOTSTRAP_PROFILE_NAME);
        if (!EvernoteInstallStatus.INSTALLED.equals((Object)installStatus)) {
            return null;
        }
        return new Intent(ACTION_GET_BOOTSTRAP_PROFILE_NAME).setPackage(PACKAGE_NAME);
    }

    public static String generateUserAgentString(Context ctx) {
        String packageName = null;
        int packageVersion = 0;
        try {
            packageName = ctx.getPackageName();
            packageVersion = ctx.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            CAT.e(e.getMessage());
        }
        String userAgent = packageName + " Android/" + packageVersion;
        Locale locale = Locale.getDefault();
        userAgent = locale == null ? userAgent + " (" + Locale.US + ");" : userAgent + " (" + locale.toString() + "); ";
        userAgent = userAgent + "Android/" + Build.VERSION.RELEASE + "; ";
        userAgent = userAgent + Build.MODEL + "/" + Build.VERSION.SDK_INT + ";";
        return userAgent;
    }

    @Nullable
    private static MessageDigest getSha256Digest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ignored) {
            return null;
        }
    }

    private static String encodeBase64(byte[] data) {
        return Base64.encodeToString((byte[])data, (int)10);
    }

    static {
        MessageDigest messageDigest;
        CAT = new Cat("EvernoteUtil");
        try {
            messageDigest = MessageDigest.getInstance(EDAM_HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            messageDigest = null;
        }
        HASH_DIGEST = messageDigest;
    }

    private static final class EvernoteUtilException
    extends RuntimeException {
        public EvernoteUtilException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static enum EvernoteInstallStatus {
        INSTALLED,
        OLD_VERSION,
        NOT_INSTALLED;

    }
}

