/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android.asyncclient;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.android.asyncclient.EvernoteAsyncClient;
import com.evernote.client.android.asyncclient.EvernoteCallback;
import com.evernote.client.android.asyncclient.EvernoteNoteStoreClient;
import com.evernote.client.android.helper.EvernotePreconditions;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.thrift.TException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class EvernoteBusinessNotebookHelper
extends EvernoteAsyncClient {
    private final EvernoteNoteStoreClient mClient;
    private final String mBusinessUserName;
    private final String mBusinessUserShardId;

    public EvernoteBusinessNotebookHelper(@NonNull EvernoteNoteStoreClient client, @NonNull ExecutorService executorService, @NonNull String businessUserName, @NonNull String businessUserShardId) {
        super(executorService);
        this.mClient = EvernotePreconditions.checkNotNull(client);
        this.mBusinessUserName = EvernotePreconditions.checkNotEmpty(businessUserName);
        this.mBusinessUserShardId = EvernotePreconditions.checkNotEmpty(businessUserShardId);
    }

    public EvernoteNoteStoreClient getClient() {
        return this.mClient;
    }

    public String getBusinessUserName() {
        return this.mBusinessUserName;
    }

    public String getBusinessUserShardId() {
        return this.mBusinessUserShardId;
    }

    public List<LinkedNotebook> listBusinessNotebooks(@NonNull EvernoteSession session) throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        return this.listBusinessNotebooks(session.getEvernoteClientFactory().getNoteStoreClient());
    }

    public List<LinkedNotebook> listBusinessNotebooks(@NonNull EvernoteNoteStoreClient defaultClient) throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        ArrayList<LinkedNotebook> businessNotebooks = new ArrayList<LinkedNotebook>(defaultClient.listLinkedNotebooks());
        Iterator iterator = businessNotebooks.iterator();
        while (iterator.hasNext()) {
            if (EvernoteBusinessNotebookHelper.isBusinessNotebook((LinkedNotebook)iterator.next())) continue;
            iterator.remove();
        }
        return businessNotebooks;
    }

    public Future<List<LinkedNotebook>> listBusinessNotebooksAsync(@NonNull EvernoteSession session, @Nullable EvernoteCallback<List<LinkedNotebook>> callback) {
        return this.listBusinessNotebooksAsync(session.getEvernoteClientFactory().getNoteStoreClient(), callback);
    }

    public Future<List<LinkedNotebook>> listBusinessNotebooksAsync(final @NonNull EvernoteNoteStoreClient defaultClient, @Nullable EvernoteCallback<List<LinkedNotebook>> callback) {
        return this.submitTask(new Callable<List<LinkedNotebook>>(){

            @Override
            public List<LinkedNotebook> call() throws Exception {
                return EvernoteBusinessNotebookHelper.this.listBusinessNotebooks(defaultClient);
            }
        }, callback);
    }

    public LinkedNotebook createBusinessNotebook(@NonNull Notebook notebook, @NonNull EvernoteSession session) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        return this.createBusinessNotebook(notebook, session.getEvernoteClientFactory().getNoteStoreClient());
    }

    public LinkedNotebook createBusinessNotebook(@NonNull Notebook notebook, @NonNull EvernoteNoteStoreClient defaultClient) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        Notebook originalNotebook = this.mClient.createNotebook(notebook);
        List sharedNotebooks = originalNotebook.getSharedNotebooks();
        SharedNotebook sharedNotebook = (SharedNotebook)sharedNotebooks.get(0);
        LinkedNotebook linkedNotebook = new LinkedNotebook();
        linkedNotebook.setShareKey(sharedNotebook.getShareKey());
        linkedNotebook.setShareName(originalNotebook.getName());
        linkedNotebook.setUsername(this.mBusinessUserName);
        linkedNotebook.setShardId(this.mBusinessUserShardId);
        return defaultClient.createLinkedNotebook(linkedNotebook);
    }

    public Future<LinkedNotebook> createBusinessNotebookAsync(@NonNull Notebook notebook, @NonNull EvernoteSession session, @Nullable EvernoteCallback<LinkedNotebook> callback) {
        return this.createBusinessNotebookAsync(notebook, session.getEvernoteClientFactory().getNoteStoreClient(), callback);
    }

    public Future<LinkedNotebook> createBusinessNotebookAsync(final @NonNull Notebook notebook, final @NonNull EvernoteNoteStoreClient defaultClient, @Nullable EvernoteCallback<LinkedNotebook> callback) {
        return this.submitTask(new Callable<LinkedNotebook>(){

            @Override
            public LinkedNotebook call() throws Exception {
                return EvernoteBusinessNotebookHelper.this.createBusinessNotebook(notebook, defaultClient);
            }
        }, callback);
    }

    public static boolean isBusinessNotebook(LinkedNotebook linkedNotebook) {
        return linkedNotebook.isSetBusinessId();
    }
}

