/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android.asyncclient;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.android.EvernoteUtil;
import com.evernote.client.android.asyncclient.EvernoteAsyncClient;
import com.evernote.client.android.asyncclient.EvernoteBusinessNotebookHelper;
import com.evernote.client.android.asyncclient.EvernoteCallback;
import com.evernote.client.android.asyncclient.EvernoteHtmlHelper;
import com.evernote.client.android.asyncclient.EvernoteLinkedNotebookHelper;
import com.evernote.client.android.asyncclient.EvernoteNoteStoreClient;
import com.evernote.client.android.asyncclient.EvernoteSearchHelper;
import com.evernote.client.android.asyncclient.EvernoteUserStoreClient;
import com.evernote.client.android.helper.EvernotePreconditions;
import com.evernote.client.conn.mobile.ByteStore;
import com.evernote.client.conn.mobile.DiskBackedByteStore;
import com.evernote.client.conn.mobile.TAndroidTransport;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.NoteStore;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.User;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.edam.userstore.UserStore;
import com.evernote.thrift.TException;
import com.evernote.thrift.protocol.TBinaryProtocol;
import com.evernote.thrift.protocol.TProtocol;
import com.evernote.thrift.transport.TTransport;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.OkHttpClient;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class EvernoteClientFactory {
    protected final EvernoteSession mEvernoteSession;
    protected final OkHttpClient mHttpClient;
    protected final ByteStore mByteStore;
    protected final Map<String, String> mHeaders;
    protected final ExecutorService mExecutorService;
    private final Map<String, EvernoteUserStoreClient> mUserStoreClients;
    private final Map<String, EvernoteNoteStoreClient> mNoteStoreClients;
    private final Map<String, EvernoteLinkedNotebookHelper> mLinkedNotebookHelpers;
    private EvernoteBusinessNotebookHelper mBusinessNotebookHelper;
    private EvernoteHtmlHelper mHtmlHelperDefault;
    private final Map<String, EvernoteHtmlHelper> mLinkedHtmlHelper;
    private EvernoteHtmlHelper mHtmlHelperBusiness;
    private EvernoteSearchHelper mEvernoteSearchHelper;
    private final EvernoteAsyncClient mCreateHelperClient;
    private AuthenticationResult mBusinessAuthenticationResult;

    protected EvernoteClientFactory(EvernoteSession session, OkHttpClient httpClient, ByteStore byteStore, Map<String, String> headers, ExecutorService executorService) {
        this.mEvernoteSession = EvernotePreconditions.checkNotNull(session);
        this.mHttpClient = EvernotePreconditions.checkNotNull(httpClient);
        this.mByteStore = EvernotePreconditions.checkNotNull(byteStore);
        this.mHeaders = headers;
        this.mExecutorService = EvernotePreconditions.checkNotNull(executorService);
        this.mUserStoreClients = new HashMap<String, EvernoteUserStoreClient>();
        this.mNoteStoreClients = new HashMap<String, EvernoteNoteStoreClient>();
        this.mLinkedNotebookHelpers = new HashMap<String, EvernoteLinkedNotebookHelper>();
        this.mLinkedHtmlHelper = new HashMap<String, EvernoteHtmlHelper>();
        this.mCreateHelperClient = new EvernoteAsyncClient(this.mExecutorService){};
    }

    public synchronized EvernoteUserStoreClient getUserStoreClient() {
        this.checkLoggedIn();
        String url = new Uri.Builder().scheme("https").authority(this.mEvernoteSession.getAuthenticationResult().getEvernoteHost()).path("/edam/user").build().toString();
        return this.getUserStoreClient(url, this.mEvernoteSession.getAuthToken());
    }

    public synchronized EvernoteUserStoreClient getUserStoreClient(@NonNull String url, @Nullable String authToken) {
        String key = this.createKey(url, authToken);
        EvernoteUserStoreClient userStoreClient = this.mUserStoreClients.get(key);
        if (userStoreClient == null) {
            userStoreClient = this.createUserStoreClient(url, authToken);
            this.mUserStoreClients.put(key, userStoreClient);
        }
        return userStoreClient;
    }

    protected EvernoteUserStoreClient createUserStoreClient(String url, String authToken) {
        UserStore.Client client = new UserStore.Client((TProtocol)this.createBinaryProtocol(url));
        return new EvernoteUserStoreClient(client, authToken, this.mExecutorService);
    }

    public synchronized EvernoteNoteStoreClient getNoteStoreClient() {
        this.checkLoggedIn();
        return this.getNoteStoreClient(this.mEvernoteSession.getAuthenticationResult().getNoteStoreUrl(), EvernotePreconditions.checkNotEmpty(this.mEvernoteSession.getAuthToken()));
    }

    public synchronized EvernoteNoteStoreClient getNoteStoreClient(@NonNull String url, @NonNull String authToken) {
        String key = this.createKey(url, authToken);
        EvernoteNoteStoreClient client = this.mNoteStoreClients.get(key);
        if (client == null) {
            client = this.createEvernoteNoteStoreClient(url, authToken);
            this.mNoteStoreClients.put(key, client);
        }
        return client;
    }

    public synchronized EvernoteLinkedNotebookHelper getLinkedNotebookHelper(@NonNull LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        String key = linkedNotebook.getGuid();
        EvernoteLinkedNotebookHelper notebookHelper = this.mLinkedNotebookHelpers.get(key);
        if (notebookHelper == null) {
            notebookHelper = this.createLinkedNotebookHelper(linkedNotebook);
            this.mLinkedNotebookHelpers.put(key, notebookHelper);
        }
        return notebookHelper;
    }

    public Future<EvernoteLinkedNotebookHelper> getLinkedNotebookHelperAsync(final @NonNull LinkedNotebook linkedNotebook, @Nullable EvernoteCallback<EvernoteLinkedNotebookHelper> callback) {
        return this.mCreateHelperClient.submitTask(new Callable<EvernoteLinkedNotebookHelper>(){

            @Override
            public EvernoteLinkedNotebookHelper call() throws Exception {
                return EvernoteClientFactory.this.getLinkedNotebookHelper(linkedNotebook);
            }
        }, callback);
    }

    protected EvernoteLinkedNotebookHelper createLinkedNotebookHelper(@NonNull LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        String url = linkedNotebook.getNoteStoreUrl();
        EvernoteNoteStoreClient client = this.getNoteStoreClient(url, EvernotePreconditions.checkNotEmpty(this.mEvernoteSession.getAuthToken()));
        AuthenticationResult authenticationResult = client.authenticateToSharedNotebook(linkedNotebook.getShareKey());
        client = this.getNoteStoreClient(url, authenticationResult.getAuthenticationToken());
        return new EvernoteLinkedNotebookHelper(client, linkedNotebook, this.mExecutorService);
    }

    public synchronized EvernoteBusinessNotebookHelper getBusinessNotebookHelper() throws TException, EDAMUserException, EDAMSystemException {
        if (this.mBusinessNotebookHelper == null || this.isBusinessAuthExpired()) {
            this.mBusinessNotebookHelper = this.createBusinessNotebookHelper();
        }
        return this.mBusinessNotebookHelper;
    }

    public Future<EvernoteBusinessNotebookHelper> getBusinessNotebookHelperAsync(@Nullable EvernoteCallback<EvernoteBusinessNotebookHelper> callback) {
        return this.mCreateHelperClient.submitTask(new Callable<EvernoteBusinessNotebookHelper>(){

            @Override
            public EvernoteBusinessNotebookHelper call() throws Exception {
                return EvernoteClientFactory.this.getBusinessNotebookHelper();
            }
        }, callback);
    }

    protected EvernoteBusinessNotebookHelper createBusinessNotebookHelper() throws TException, EDAMUserException, EDAMSystemException {
        this.authenticateToBusiness();
        EvernoteNoteStoreClient client = this.getNoteStoreClient(this.mBusinessAuthenticationResult.getNoteStoreUrl(), this.mBusinessAuthenticationResult.getAuthenticationToken());
        User businessUser = this.mBusinessAuthenticationResult.getUser();
        return new EvernoteBusinessNotebookHelper(client, this.mExecutorService, businessUser.getUsername(), businessUser.getShardId());
    }

    public synchronized EvernoteHtmlHelper getHtmlHelperDefault() {
        this.checkLoggedIn();
        if (this.mHtmlHelperDefault == null) {
            this.mHtmlHelperDefault = this.createHtmlHelper(this.mEvernoteSession.getAuthToken());
        }
        return this.mHtmlHelperDefault;
    }

    public EvernoteHtmlHelper getLinkedHtmlHelper(@NonNull LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        String key = linkedNotebook.getGuid();
        EvernoteHtmlHelper htmlHelper = this.mLinkedHtmlHelper.get(key);
        if (htmlHelper == null) {
            String url = linkedNotebook.getNoteStoreUrl();
            EvernoteNoteStoreClient client = this.getNoteStoreClient(url, EvernotePreconditions.checkNotEmpty(this.mEvernoteSession.getAuthToken()));
            AuthenticationResult authenticationResult = client.authenticateToSharedNotebook(linkedNotebook.getShareKey());
            htmlHelper = this.createHtmlHelper(authenticationResult.getAuthenticationToken());
            this.mLinkedHtmlHelper.put(key, htmlHelper);
        }
        return htmlHelper;
    }

    public Future<EvernoteHtmlHelper> getLinkedHtmlHelperAsync(final @NonNull LinkedNotebook linkedNotebook, @Nullable EvernoteCallback<EvernoteHtmlHelper> callback) {
        return this.mCreateHelperClient.submitTask(new Callable<EvernoteHtmlHelper>(){

            @Override
            public EvernoteHtmlHelper call() throws Exception {
                return EvernoteClientFactory.this.getLinkedHtmlHelper(linkedNotebook);
            }
        }, callback);
    }

    public synchronized EvernoteHtmlHelper getHtmlHelperBusiness() throws TException, EDAMUserException, EDAMSystemException {
        if (this.mHtmlHelperBusiness == null) {
            this.authenticateToBusiness();
            this.mHtmlHelperBusiness = this.createHtmlHelper(this.mBusinessAuthenticationResult.getAuthenticationToken());
        }
        return this.mHtmlHelperBusiness;
    }

    public Future<EvernoteHtmlHelper> getHtmlHelperBusinessAsync(@Nullable EvernoteCallback<EvernoteHtmlHelper> callback) {
        return this.mCreateHelperClient.submitTask(new Callable<EvernoteHtmlHelper>(){

            @Override
            public EvernoteHtmlHelper call() throws Exception {
                return EvernoteClientFactory.this.getHtmlHelperBusiness();
            }
        }, callback);
    }

    protected EvernoteHtmlHelper createHtmlHelper(String authToken) {
        return new EvernoteHtmlHelper(this.mHttpClient, this.mEvernoteSession.getAuthenticationResult().getEvernoteHost(), authToken, this.mExecutorService);
    }

    public EvernoteSearchHelper getEvernoteSearchHelper() {
        this.checkLoggedIn();
        if (this.mEvernoteSearchHelper == null) {
            this.mEvernoteSearchHelper = this.createEvernoteSearchHelper();
        }
        return this.mEvernoteSearchHelper;
    }

    protected EvernoteSearchHelper createEvernoteSearchHelper() {
        return new EvernoteSearchHelper(this.mEvernoteSession, this.mExecutorService);
    }

    protected TBinaryProtocol createBinaryProtocol(String url) {
        return new TBinaryProtocol((TTransport)new TAndroidTransport(this.mHttpClient, this.mByteStore, url, this.mHeaders));
    }

    protected NoteStore.Client createNoteStoreClient(String url) {
        return new NoteStore.Client((TProtocol)this.createBinaryProtocol(url));
    }

    protected synchronized EvernoteNoteStoreClient createEvernoteNoteStoreClient(String url, String authToken) {
        return new EvernoteNoteStoreClient(this.createNoteStoreClient(url), authToken, this.mExecutorService);
    }

    protected final String createKey(String url, String authToken) {
        if (url == null && authToken == null) {
            throw new IllegalArgumentException();
        }
        if (url == null) {
            return authToken;
        }
        if (authToken == null) {
            return url;
        }
        return url + authToken;
    }

    protected final void authenticateToBusiness() throws TException, EDAMUserException, EDAMSystemException {
        if (this.isBusinessAuthExpired()) {
            this.mBusinessAuthenticationResult = this.getUserStoreClient().authenticateToBusiness();
        }
    }

    protected final boolean isBusinessAuthExpired() {
        return this.mBusinessAuthenticationResult == null || this.mBusinessAuthenticationResult.getExpiration() < System.currentTimeMillis();
    }

    protected void checkLoggedIn() {
        if (!this.mEvernoteSession.isLoggedIn()) {
            throw new IllegalStateException("user not logged in");
        }
    }

    public static class Builder {
        private final EvernoteSession mEvernoteSession;
        private final Map<String, String> mHeaders;
        private OkHttpClient mHttpClient;
        private ByteStore.Factory mByteStoreFactory;
        private ExecutorService mExecutorService;

        public Builder(EvernoteSession evernoteSession) {
            this.mEvernoteSession = EvernotePreconditions.checkNotNull(evernoteSession);
            this.mHeaders = new HashMap<String, String>();
        }

        public Builder setHttpClient(OkHttpClient httpClient) {
            this.mHttpClient = httpClient;
            return this;
        }

        public Builder setByteStoreFactory(ByteStore.Factory byteStoreFactory) {
            this.mByteStoreFactory = byteStoreFactory;
            return this;
        }

        private Builder addHeader(String name, String value) {
            this.mHeaders.put(name, value);
            return this;
        }

        public Builder setExecutorService(ExecutorService executorService) {
            this.mExecutorService = executorService;
            return this;
        }

        public EvernoteClientFactory build() {
            if (this.mHttpClient == null) {
                this.mHttpClient = this.createDefaultHttpClient();
            }
            if (this.mByteStoreFactory == null) {
                this.mByteStoreFactory = this.createDefaultByteStore(this.mEvernoteSession.getApplicationContext());
            }
            if (this.mExecutorService == null) {
                this.mExecutorService = Executors.newSingleThreadExecutor();
            }
            this.addHeader("Cache-Control", "no-transform");
            this.addHeader("Accept", "application/x-thrift");
            this.addHeader("User-Agent", EvernoteUtil.generateUserAgentString(this.mEvernoteSession.getApplicationContext()));
            return new EvernoteClientFactory(this.mEvernoteSession, this.mHttpClient, this.mByteStoreFactory.create(), this.mHeaders, this.mExecutorService);
        }

        private OkHttpClient createDefaultHttpClient() {
            OkHttpClient httpClient = new OkHttpClient();
            httpClient.setConnectTimeout(10L, TimeUnit.SECONDS);
            httpClient.setReadTimeout(10L, TimeUnit.SECONDS);
            httpClient.setWriteTimeout(20L, TimeUnit.SECONDS);
            httpClient.setConnectionPool(new ConnectionPool(20, 120000L));
            return httpClient;
        }

        private ByteStore.Factory createDefaultByteStore(Context context) {
            int cacheSize = (int)(Runtime.getRuntime().maxMemory() / 32L);
            return new DiskBackedByteStore.Factory(new File(context.getCacheDir(), "evernoteCache"), cacheSize);
        }
    }
}

