/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android.asyncclient;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.evernote.client.android.asyncclient.EvernoteAsyncClient;
import com.evernote.client.android.asyncclient.EvernoteCallback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class EvernoteHtmlHelper
extends EvernoteAsyncClient {
    protected final OkHttpClient mHttpClient;
    protected final String mHost;
    protected final String mAuthToken;
    private final String mAuthHeader;
    private final String mBaseUrl;

    public EvernoteHtmlHelper(@NonNull OkHttpClient httpClient, @NonNull String host, @NonNull String authToken, @NonNull ExecutorService executorService) {
        super(executorService);
        this.mHttpClient = httpClient;
        this.mHost = host;
        this.mAuthToken = authToken;
        this.mAuthHeader = "auth=" + this.mAuthToken;
        this.mBaseUrl = this.createBaseUrl();
    }

    protected String createBaseUrl() {
        return new Uri.Builder().scheme("https").authority(this.mHost).path("/note").build().toString();
    }

    public Response downloadNote(@NonNull String noteGuid) throws IOException {
        String url = this.mBaseUrl + '/' + noteGuid;
        return this.fetchEvernoteUrl(url);
    }

    public Future<Response> downloadNoteAsync(final @NonNull String noteGuid, @Nullable EvernoteCallback<Response> callback) throws IOException {
        return this.submitTask(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                return EvernoteHtmlHelper.this.downloadNote(noteGuid);
            }
        }, callback);
    }

    public String parseBody(@NonNull Response response) throws IOException {
        if (response.code() == 200) {
            return response.body().string();
        }
        return null;
    }

    public Response fetchEvernoteUrl(String url) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Cookie", this.mAuthHeader).get();
        return this.mHttpClient.newCall(requestBuilder.build()).execute();
    }
}

