/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android.asyncclient;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.android.asyncclient.EvernoteAsyncClient;
import com.evernote.client.android.asyncclient.EvernoteCallback;
import com.evernote.client.android.asyncclient.EvernoteNoteStoreClient;
import com.evernote.client.android.helper.EvernotePreconditions;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.thrift.TException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class EvernoteLinkedNotebookHelper
extends EvernoteAsyncClient {
    protected final EvernoteNoteStoreClient mClient;
    protected final LinkedNotebook mLinkedNotebook;

    public EvernoteLinkedNotebookHelper(@NonNull EvernoteNoteStoreClient client, @NonNull LinkedNotebook linkedNotebook, @NonNull ExecutorService executorService) {
        super(executorService);
        this.mClient = EvernotePreconditions.checkNotNull(client);
        this.mLinkedNotebook = EvernotePreconditions.checkNotNull(linkedNotebook);
    }

    public EvernoteNoteStoreClient getClient() {
        return this.mClient;
    }

    public LinkedNotebook getLinkedNotebook() {
        return this.mLinkedNotebook;
    }

    public Note createNoteInLinkedNotebook(@NonNull Note note) throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        SharedNotebook sharedNotebook = this.mClient.getSharedNotebookByAuth();
        note.setNotebookGuid(sharedNotebook.getNotebookGuid());
        return this.mClient.createNote(note);
    }

    public Future<Note> createNoteInLinkedNotebookAsync(final @NonNull Note note, @Nullable EvernoteCallback<Note> callback) {
        return this.submitTask(new Callable<Note>(){

            @Override
            public Note call() throws Exception {
                return EvernoteLinkedNotebookHelper.this.createNoteInLinkedNotebook(note);
            }
        }, callback);
    }

    public int deleteLinkedNotebook(@NonNull EvernoteSession session) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        return this.deleteLinkedNotebook(session.getEvernoteClientFactory().getNoteStoreClient());
    }

    public int deleteLinkedNotebook(@NonNull EvernoteNoteStoreClient defaultClient) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        SharedNotebook sharedNotebook = this.mClient.getSharedNotebookByAuth();
        ArrayList<Long> sharedNotebookIds = new ArrayList<Long>();
        sharedNotebookIds.add(sharedNotebook.getId());
        this.mClient.expungeSharedNotebooks(sharedNotebookIds);
        return defaultClient.expungeLinkedNotebook(this.mLinkedNotebook.getGuid());
    }

    public Future<Integer> deleteLinkedNotebookAsync(@NonNull EvernoteSession session, @Nullable EvernoteCallback<Integer> callback) {
        return this.deleteLinkedNotebookAsync(session.getEvernoteClientFactory().getNoteStoreClient(), callback);
    }

    public Future<Integer> deleteLinkedNotebookAsync(final @NonNull EvernoteNoteStoreClient defaultClient, @Nullable EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteLinkedNotebookHelper.this.deleteLinkedNotebook(defaultClient);
            }
        }, callback);
    }

    public Notebook getCorrespondingNotebook() throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        SharedNotebook sharedNotebook = this.mClient.getSharedNotebookByAuth();
        return this.mClient.getNotebook(sharedNotebook.getNotebookGuid());
    }

    public Future<Notebook> getCorrespondingNotebookAsync(@Nullable EvernoteCallback<Notebook> callback) {
        return this.submitTask(new Callable<Notebook>(){

            @Override
            public Notebook call() throws Exception {
                return EvernoteLinkedNotebookHelper.this.getCorrespondingNotebook();
            }
        }, callback);
    }

    public boolean isNotebookWritable() throws EDAMUserException, TException, EDAMSystemException, EDAMNotFoundException {
        Notebook notebook = this.getCorrespondingNotebook();
        return !notebook.getRestrictions().isNoCreateNotes();
    }

    public Future<Boolean> isNotebookWritableAsync(@Nullable EvernoteCallback<Boolean> callback) {
        return this.submitTask(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return EvernoteLinkedNotebookHelper.this.isNotebookWritable();
            }
        }, callback);
    }
}

