/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android.asyncclient;

import android.support.annotation.NonNull;
import com.evernote.client.android.asyncclient.EvernoteAsyncClient;
import com.evernote.client.android.asyncclient.EvernoteCallback;
import com.evernote.client.android.helper.EvernotePreconditions;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.ClientUsageMetrics;
import com.evernote.edam.notestore.NoteCollectionCounts;
import com.evernote.edam.notestore.NoteEmailParameters;
import com.evernote.edam.notestore.NoteFilter;
import com.evernote.edam.notestore.NoteList;
import com.evernote.edam.notestore.NoteStore;
import com.evernote.edam.notestore.NoteVersionId;
import com.evernote.edam.notestore.NotesMetadataList;
import com.evernote.edam.notestore.NotesMetadataResultSpec;
import com.evernote.edam.notestore.RelatedQuery;
import com.evernote.edam.notestore.RelatedResult;
import com.evernote.edam.notestore.RelatedResultSpec;
import com.evernote.edam.notestore.SyncChunk;
import com.evernote.edam.notestore.SyncChunkFilter;
import com.evernote.edam.notestore.SyncState;
import com.evernote.edam.type.LazyMap;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.ResourceAttributes;
import com.evernote.edam.type.SavedSearch;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.edam.type.SharedNotebookRecipientSettings;
import com.evernote.edam.type.Tag;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.thrift.TException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class EvernoteNoteStoreClient
extends EvernoteAsyncClient {
    private final NoteStore.Client mClient;
    private final String mAuthenticationToken;

    EvernoteNoteStoreClient(@NonNull NoteStore.Client client, @NonNull String authenticationToken, @NonNull ExecutorService executorService) {
        super(executorService);
        this.mClient = EvernotePreconditions.checkNotNull(client);
        this.mAuthenticationToken = EvernotePreconditions.checkNotEmpty(authenticationToken);
    }

    public SyncState getSyncState() throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.getSyncState(this.mAuthenticationToken);
    }

    public Future<SyncState> getSyncStateAsync(EvernoteCallback<SyncState> callback) {
        return this.submitTask(new Callable<SyncState>(){

            @Override
            public SyncState call() throws Exception {
                return EvernoteNoteStoreClient.this.getSyncState();
            }
        }, callback);
    }

    public SyncState getSyncStateWithMetrics(ClientUsageMetrics clientMetrics) throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.getSyncStateWithMetrics(this.mAuthenticationToken, clientMetrics);
    }

    public Future<SyncState> getSyncStateWithMetricsAsync(final ClientUsageMetrics clientMetrics, EvernoteCallback<SyncState> callback) {
        return this.submitTask(new Callable<SyncState>(){

            @Override
            public SyncState call() throws Exception {
                return EvernoteNoteStoreClient.this.getSyncStateWithMetrics(clientMetrics);
            }
        }, callback);
    }

    public SyncChunk getSyncChunk(int afterUSN, int maxEntries, boolean fullSyncOnly) throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.getSyncChunk(this.mAuthenticationToken, afterUSN, maxEntries, fullSyncOnly);
    }

    public Future<SyncChunk> getSyncChunkAsync(final int afterUSN, final int maxEntries, final boolean fullSyncOnly, EvernoteCallback<SyncChunk> callback) {
        return this.submitTask(new Callable<SyncChunk>(){

            @Override
            public SyncChunk call() throws Exception {
                return EvernoteNoteStoreClient.this.getSyncChunk(afterUSN, maxEntries, fullSyncOnly);
            }
        }, callback);
    }

    public SyncChunk getFilteredSyncChunk(int afterUSN, int maxEntries, SyncChunkFilter filter) throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.getFilteredSyncChunk(this.mAuthenticationToken, afterUSN, maxEntries, filter);
    }

    public Future<SyncChunk> getFilteredSyncChunkAsync(final int afterUSN, final int maxEntries, final SyncChunkFilter filter, EvernoteCallback<SyncChunk> callback) {
        return this.submitTask(new Callable<SyncChunk>(){

            @Override
            public SyncChunk call() throws Exception {
                return EvernoteNoteStoreClient.this.getFilteredSyncChunk(afterUSN, maxEntries, filter);
            }
        }, callback);
    }

    public SyncState getLinkedNotebookSyncState(LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getLinkedNotebookSyncState(this.mAuthenticationToken, linkedNotebook);
    }

    public Future<SyncState> getLinkedNotebookSyncStateAsync(final LinkedNotebook linkedNotebook, EvernoteCallback<SyncState> callback) {
        return this.submitTask(new Callable<SyncState>(){

            @Override
            public SyncState call() throws Exception {
                return EvernoteNoteStoreClient.this.getLinkedNotebookSyncState(linkedNotebook);
            }
        }, callback);
    }

    public SyncChunk getLinkedNotebookSyncChunk(LinkedNotebook linkedNotebook, int afterUSN, int maxEntries, boolean fullSyncOnly) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getLinkedNotebookSyncChunk(this.mAuthenticationToken, linkedNotebook, afterUSN, maxEntries, fullSyncOnly);
    }

    public Future<SyncChunk> getLinkedNotebookSyncChunkAsync(final LinkedNotebook linkedNotebook, final int afterUSN, final int maxEntries, final boolean fullSyncOnly, EvernoteCallback<SyncChunk> callback) {
        return this.submitTask(new Callable<SyncChunk>(){

            @Override
            public SyncChunk call() throws Exception {
                return EvernoteNoteStoreClient.this.getLinkedNotebookSyncChunk(linkedNotebook, afterUSN, maxEntries, fullSyncOnly);
            }
        }, callback);
    }

    public List<Notebook> listNotebooks() throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.listNotebooks(this.mAuthenticationToken);
    }

    public Future<List<Notebook>> listNotebooksAsync(EvernoteCallback<List<Notebook>> callback) {
        return this.submitTask(new Callable<List<Notebook>>(){

            @Override
            public List<Notebook> call() throws Exception {
                return EvernoteNoteStoreClient.this.listNotebooks();
            }
        }, callback);
    }

    public Notebook getNotebook(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getNotebook(this.mAuthenticationToken, guid);
    }

    public Future<Notebook> getNotebookAsync(final String guid, EvernoteCallback<Notebook> callback) {
        return this.submitTask(new Callable<Notebook>(){

            @Override
            public Notebook call() throws Exception {
                return EvernoteNoteStoreClient.this.getNotebook(guid);
            }
        }, callback);
    }

    public Notebook getDefaultNotebook() throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.getDefaultNotebook(this.mAuthenticationToken);
    }

    public Future<Notebook> getDefaultNotebookAsync(EvernoteCallback<Notebook> callback) {
        return this.submitTask(new Callable<Notebook>(){

            @Override
            public Notebook call() throws Exception {
                return EvernoteNoteStoreClient.this.getDefaultNotebook();
            }
        }, callback);
    }

    public Notebook createNotebook(Notebook notebook) throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.createNotebook(this.mAuthenticationToken, notebook);
    }

    public Future<Notebook> createNotebookAsync(final Notebook notebook, EvernoteCallback<Notebook> callback) {
        return this.submitTask(new Callable<Notebook>(){

            @Override
            public Notebook call() throws Exception {
                return EvernoteNoteStoreClient.this.createNotebook(notebook);
            }
        }, callback);
    }

    public int updateNotebook(Notebook notebook) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.updateNotebook(this.mAuthenticationToken, notebook);
    }

    public Future<Integer> updateNotebookAsync(final Notebook notebook, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.updateNotebook(notebook);
            }
        }, callback);
    }

    public int expungeNotebook(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.expungeNotebook(this.mAuthenticationToken, guid);
    }

    public Future<Integer> expungeNotebookAsync(final String guid, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.expungeNotebook(guid);
            }
        }, callback);
    }

    public List<Tag> listTags() throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.listTags(this.mAuthenticationToken);
    }

    public Future<List<Tag>> listTagsAsync(EvernoteCallback<List<Tag>> callback) {
        return this.submitTask(new Callable<List<Tag>>(){

            @Override
            public List<Tag> call() throws Exception {
                return EvernoteNoteStoreClient.this.listTags();
            }
        }, callback);
    }

    public List<Tag> listTagsByNotebook(String notebookGuid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.listTagsByNotebook(this.mAuthenticationToken, notebookGuid);
    }

    public Future<List<Tag>> listTagsByNotebookAsync(final String notebookGuid, EvernoteCallback<List<Tag>> callback) {
        return this.submitTask(new Callable<List<Tag>>(){

            @Override
            public List<Tag> call() throws Exception {
                return EvernoteNoteStoreClient.this.listTagsByNotebook(notebookGuid);
            }
        }, callback);
    }

    public Tag getTag(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getTag(this.mAuthenticationToken, guid);
    }

    public Future<Tag> getTagAsync(final String guid, EvernoteCallback<Tag> callback) {
        return this.submitTask(new Callable<Tag>(){

            @Override
            public Tag call() throws Exception {
                return EvernoteNoteStoreClient.this.getTag(guid);
            }
        }, callback);
    }

    public Tag createTag(Tag tag) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.createTag(this.mAuthenticationToken, tag);
    }

    public Future<Tag> createTagAsync(final Tag tag, EvernoteCallback<Tag> callback) {
        return this.submitTask(new Callable<Tag>(){

            @Override
            public Tag call() throws Exception {
                return EvernoteNoteStoreClient.this.createTag(tag);
            }
        }, callback);
    }

    public int updateTag(Tag tag) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.updateTag(this.mAuthenticationToken, tag);
    }

    public Future<Integer> updateTagAsync(final Tag tag, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.updateTag(tag);
            }
        }, callback);
    }

    public void untagAll(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        this.mClient.untagAll(this.mAuthenticationToken, guid);
    }

    public Future<Void> untagAllAsync(final String guid, EvernoteCallback<Void> callback) {
        return this.submitTask(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EvernoteNoteStoreClient.this.untagAll(guid);
                return null;
            }
        }, callback);
    }

    public int expungeTag(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.expungeTag(this.mAuthenticationToken, guid);
    }

    public Future<Integer> expungeTagAsync(final String guid, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.expungeTag(guid);
            }
        }, callback);
    }

    public List<SavedSearch> listSearches() throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.listSearches(this.mAuthenticationToken);
    }

    public Future<List<SavedSearch>> listSearchesAsync(EvernoteCallback<List<SavedSearch>> callback) {
        return this.submitTask(new Callable<List<SavedSearch>>(){

            @Override
            public List<SavedSearch> call() throws Exception {
                return EvernoteNoteStoreClient.this.listSearches();
            }
        }, callback);
    }

    public SavedSearch getSearch(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getSearch(this.mAuthenticationToken, guid);
    }

    public Future<SavedSearch> getSearchAsync(final String guid, EvernoteCallback<SavedSearch> callback) {
        return this.submitTask(new Callable<SavedSearch>(){

            @Override
            public SavedSearch call() throws Exception {
                return EvernoteNoteStoreClient.this.getSearch(guid);
            }
        }, callback);
    }

    public SavedSearch createSearch(SavedSearch search) throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.createSearch(this.mAuthenticationToken, search);
    }

    public Future<SavedSearch> createSearchAsync(final SavedSearch search, EvernoteCallback<SavedSearch> callback) {
        return this.submitTask(new Callable<SavedSearch>(){

            @Override
            public SavedSearch call() throws Exception {
                return EvernoteNoteStoreClient.this.createSearch(search);
            }
        }, callback);
    }

    public int updateSearch(SavedSearch search) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.updateSearch(this.mAuthenticationToken, search);
    }

    public Future<Integer> updateSearchAsync(final SavedSearch search, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.updateSearch(search);
            }
        }, callback);
    }

    public int expungeSearch(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.expungeSearch(this.mAuthenticationToken, guid);
    }

    public Future<Integer> expungeSearchAsync(final String guid, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.expungeSearch(guid);
            }
        }, callback);
    }

    public NoteList findNotes(NoteFilter filter, int offset, int maxNotes) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.findNotes(this.mAuthenticationToken, filter, offset, maxNotes);
    }

    public Future<NoteList> findNotesAsync(final NoteFilter filter, final int offset, final int maxNotes, EvernoteCallback<NoteList> callback) {
        return this.submitTask(new Callable<NoteList>(){

            @Override
            public NoteList call() throws Exception {
                return EvernoteNoteStoreClient.this.findNotes(filter, offset, maxNotes);
            }
        }, callback);
    }

    public int findNoteOffset(NoteFilter filter, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.findNoteOffset(this.mAuthenticationToken, filter, guid);
    }

    public Future<Integer> findNoteOffsetAsync(final NoteFilter filter, final String guid, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.findNoteOffset(filter, guid);
            }
        }, callback);
    }

    public NotesMetadataList findNotesMetadata(NoteFilter filter, int offset, int maxNotes, NotesMetadataResultSpec resultSpec) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.findNotesMetadata(this.mAuthenticationToken, filter, offset, maxNotes, resultSpec);
    }

    public Future<NotesMetadataList> findNotesMetadataAsync(final NoteFilter filter, final int offset, final int maxNotes, final NotesMetadataResultSpec resultSpec, EvernoteCallback<NotesMetadataList> callback) {
        return this.submitTask(new Callable<NotesMetadataList>(){

            @Override
            public NotesMetadataList call() throws Exception {
                return EvernoteNoteStoreClient.this.findNotesMetadata(filter, offset, maxNotes, resultSpec);
            }
        }, callback);
    }

    public NoteCollectionCounts findNoteCounts(NoteFilter filter, boolean withTrash) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.findNoteCounts(this.mAuthenticationToken, filter, withTrash);
    }

    public Future<NoteCollectionCounts> findNoteCountsAsync(final NoteFilter filter, final boolean withTrash, EvernoteCallback<NoteCollectionCounts> callback) {
        return this.submitTask(new Callable<NoteCollectionCounts>(){

            @Override
            public NoteCollectionCounts call() throws Exception {
                return EvernoteNoteStoreClient.this.findNoteCounts(filter, withTrash);
            }
        }, callback);
    }

    public Note getNote(String guid, boolean withContent, boolean withResourcesData, boolean withResourcesRecognition, boolean withResourcesAlternateData) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getNote(this.mAuthenticationToken, guid, withContent, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
    }

    public Future<Note> getNoteAsync(final String guid, final boolean withContent, final boolean withResourcesData, final boolean withResourcesRecognition, final boolean withResourcesAlternateData, EvernoteCallback<Note> callback) {
        return this.submitTask(new Callable<Note>(){

            @Override
            public Note call() throws Exception {
                return EvernoteNoteStoreClient.this.getNote(guid, withContent, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
            }
        }, callback);
    }

    public LazyMap getNoteApplicationData(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getNoteApplicationData(this.mAuthenticationToken, guid);
    }

    public Future<LazyMap> getNoteApplicationDataAsync(final String guid, EvernoteCallback<LazyMap> callback) {
        return this.submitTask(new Callable<LazyMap>(){

            @Override
            public LazyMap call() throws Exception {
                return EvernoteNoteStoreClient.this.getNoteApplicationData(guid);
            }
        }, callback);
    }

    public String getNoteApplicationDataEntry(String guid, String key) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getNoteApplicationDataEntry(this.mAuthenticationToken, guid, key);
    }

    public Future<String> getNoteApplicationDataEntryAsync(final String guid, final String key, EvernoteCallback<String> callback) {
        return this.submitTask(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return EvernoteNoteStoreClient.this.getNoteApplicationDataEntry(guid, key);
            }
        }, callback);
    }

    public int setNoteApplicationDataEntry(String guid, String key, String value) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.setNoteApplicationDataEntry(this.mAuthenticationToken, guid, key, value);
    }

    public Future<Integer> setNoteApplicationDataEntryAsync(final String guid, final String key, final String value, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.setNoteApplicationDataEntry(guid, key, value);
            }
        }, callback);
    }

    public int unsetNoteApplicationDataEntry(String guid, String key) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.unsetNoteApplicationDataEntry(this.mAuthenticationToken, guid, key);
    }

    public Future<Integer> unsetNoteApplicationDataEntryAsync(final String guid, final String key, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.unsetNoteApplicationDataEntry(guid, key);
            }
        }, callback);
    }

    public String getNoteContent(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getNoteContent(this.mAuthenticationToken, guid);
    }

    public Future<String> getNoteContentAsync(final String guid, EvernoteCallback<String> callback) {
        return this.submitTask(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return EvernoteNoteStoreClient.this.getNoteContent(guid);
            }
        }, callback);
    }

    public String getNoteSearchText(String guid, boolean noteOnly, boolean tokenizeForIndexing) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getNoteSearchText(this.mAuthenticationToken, guid, noteOnly, tokenizeForIndexing);
    }

    public Future<String> getNoteSearchTextAsync(final String guid, final boolean noteOnly, final boolean tokenizeForIndexing, EvernoteCallback<String> callback) {
        return this.submitTask(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return EvernoteNoteStoreClient.this.getNoteSearchText(guid, noteOnly, tokenizeForIndexing);
            }
        }, callback);
    }

    public String getResourceSearchText(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getResourceSearchText(this.mAuthenticationToken, guid);
    }

    public Future<String> getResourceSearchTextAsync(final String guid, EvernoteCallback<String> callback) {
        return this.submitTask(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return EvernoteNoteStoreClient.this.getResourceSearchText(guid);
            }
        }, callback);
    }

    public List<String> getNoteTagNames(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getNoteTagNames(this.mAuthenticationToken, guid);
    }

    public Future<List<String>> getNoteTagNamesAsync(final String guid, EvernoteCallback<List<String>> callback) {
        return this.submitTask(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return EvernoteNoteStoreClient.this.getNoteTagNames(guid);
            }
        }, callback);
    }

    public Note createNote(Note note) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.createNote(this.mAuthenticationToken, note);
    }

    public Future<Note> createNoteAsync(final Note note, EvernoteCallback<Note> callback) {
        return this.submitTask(new Callable<Note>(){

            @Override
            public Note call() throws Exception {
                return EvernoteNoteStoreClient.this.createNote(note);
            }
        }, callback);
    }

    public Note updateNote(Note note) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.updateNote(this.mAuthenticationToken, note);
    }

    public Future<Note> updateNoteAsync(final Note note, EvernoteCallback<Note> callback) {
        return this.submitTask(new Callable<Note>(){

            @Override
            public Note call() throws Exception {
                return EvernoteNoteStoreClient.this.updateNote(note);
            }
        }, callback);
    }

    public int deleteNote(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.deleteNote(this.mAuthenticationToken, guid);
    }

    public Future<Integer> deleteNoteAsync(final String guid, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.deleteNote(guid);
            }
        }, callback);
    }

    public int expungeNote(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.expungeNote(this.mAuthenticationToken, guid);
    }

    public Future<Integer> expungeNoteAsync(final String guid, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.expungeNote(guid);
            }
        }, callback);
    }

    public int expungeNotes(List<String> noteGuids) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.expungeNotes(this.mAuthenticationToken, noteGuids);
    }

    public Future<Integer> expungeNotesAsync(final List<String> noteGuids, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.expungeNotes(noteGuids);
            }
        }, callback);
    }

    public int expungeInactiveNotes() throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.expungeInactiveNotes(this.mAuthenticationToken);
    }

    public Future<Integer> expungeInactiveNotesAsync(EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.expungeInactiveNotes();
            }
        }, callback);
    }

    public Note copyNote(String noteGuid, String toNotebookGuid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.copyNote(this.mAuthenticationToken, noteGuid, toNotebookGuid);
    }

    public Future<Note> copyNoteAsync(final String noteGuid, final String toNotebookGuid, EvernoteCallback<Note> callback) {
        return this.submitTask(new Callable<Note>(){

            @Override
            public Note call() throws Exception {
                return EvernoteNoteStoreClient.this.copyNote(noteGuid, toNotebookGuid);
            }
        }, callback);
    }

    public List<NoteVersionId> listNoteVersions(String noteGuid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.listNoteVersions(this.mAuthenticationToken, noteGuid);
    }

    public Future<List<NoteVersionId>> listNoteVersionsAsync(final String noteGuid, EvernoteCallback<List<NoteVersionId>> callback) {
        return this.submitTask(new Callable<List<NoteVersionId>>(){

            @Override
            public List<NoteVersionId> call() throws Exception {
                return EvernoteNoteStoreClient.this.listNoteVersions(noteGuid);
            }
        }, callback);
    }

    public Note getNoteVersion(String noteGuid, int updateSequenceNum, boolean withResourcesData, boolean withResourcesRecognition, boolean withResourcesAlternateData) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getNoteVersion(this.mAuthenticationToken, noteGuid, updateSequenceNum, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
    }

    public Future<Note> getNoteVersionAsync(final String noteGuid, final int updateSequenceNum, final boolean withResourcesData, final boolean withResourcesRecognition, final boolean withResourcesAlternateData, EvernoteCallback<Note> callback) {
        return this.submitTask(new Callable<Note>(){

            @Override
            public Note call() throws Exception {
                return EvernoteNoteStoreClient.this.getNoteVersion(noteGuid, updateSequenceNum, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
            }
        }, callback);
    }

    public Resource getResource(String guid, boolean withData, boolean withRecognition, boolean withAttributes, boolean withAlternateData) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getResource(this.mAuthenticationToken, guid, withData, withRecognition, withAttributes, withAlternateData);
    }

    public Future<Resource> getResourceAsync(final String guid, final boolean withData, final boolean withRecognition, final boolean withAttributes, final boolean withAlternateData, EvernoteCallback<Resource> callback) {
        return this.submitTask(new Callable<Resource>(){

            @Override
            public Resource call() throws Exception {
                return EvernoteNoteStoreClient.this.getResource(guid, withData, withRecognition, withAttributes, withAlternateData);
            }
        }, callback);
    }

    public LazyMap getResourceApplicationData(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getResourceApplicationData(this.mAuthenticationToken, guid);
    }

    public Future<LazyMap> getResourceApplicationDataAsync(final String guid, EvernoteCallback<LazyMap> callback) {
        return this.submitTask(new Callable<LazyMap>(){

            @Override
            public LazyMap call() throws Exception {
                return EvernoteNoteStoreClient.this.getResourceApplicationData(guid);
            }
        }, callback);
    }

    public String getResourceApplicationDataEntry(String guid, String key) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getResourceApplicationDataEntry(this.mAuthenticationToken, guid, key);
    }

    public Future<String> getResourceApplicationDataEntryAsync(final String guid, final String key, EvernoteCallback<String> callback) {
        return this.submitTask(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return EvernoteNoteStoreClient.this.getResourceApplicationDataEntry(guid, key);
            }
        }, callback);
    }

    public int setResourceApplicationDataEntry(String guid, String key, String value) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.setResourceApplicationDataEntry(this.mAuthenticationToken, guid, key, value);
    }

    public Future<Integer> setResourceApplicationDataEntryAsync(final String guid, final String key, final String value, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.setResourceApplicationDataEntry(guid, key, value);
            }
        }, callback);
    }

    public int unsetResourceApplicationDataEntry(String guid, String key) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.unsetResourceApplicationDataEntry(this.mAuthenticationToken, guid, key);
    }

    public Future<Integer> unsetResourceApplicationDataEntryAsync(final String guid, final String key, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.unsetResourceApplicationDataEntry(guid, key);
            }
        }, callback);
    }

    public int updateResource(Resource resource) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.updateResource(this.mAuthenticationToken, resource);
    }

    public Future<Integer> updateResourceAsync(final Resource resource, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.updateResource(resource);
            }
        }, callback);
    }

    public byte[] getResourceData(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getResourceData(this.mAuthenticationToken, guid);
    }

    public Future<byte[]> getResourceDataAsync(final String guid, EvernoteCallback<byte[]> callback) {
        return this.submitTask(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return EvernoteNoteStoreClient.this.getResourceData(guid);
            }
        }, callback);
    }

    public Resource getResourceByHash(String noteGuid, byte[] contentHash, boolean withData, boolean withRecognition, boolean withAlternateData) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getResourceByHash(this.mAuthenticationToken, noteGuid, contentHash, withData, withRecognition, withAlternateData);
    }

    public Future<Resource> getResourceByHashAsync(final String noteGuid, final byte[] contentHash, final boolean withData, final boolean withRecognition, final boolean withAlternateData, EvernoteCallback<Resource> callback) {
        return this.submitTask(new Callable<Resource>(){

            @Override
            public Resource call() throws Exception {
                return EvernoteNoteStoreClient.this.getResourceByHash(noteGuid, contentHash, withData, withRecognition, withAlternateData);
            }
        }, callback);
    }

    public byte[] getResourceRecognition(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getResourceRecognition(this.mAuthenticationToken, guid);
    }

    public Future<byte[]> getResourceRecognitionAsync(final String guid, EvernoteCallback<byte[]> callback) {
        return this.submitTask(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return EvernoteNoteStoreClient.this.getResourceRecognition(guid);
            }
        }, callback);
    }

    public byte[] getResourceAlternateData(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getResourceAlternateData(this.mAuthenticationToken, guid);
    }

    public Future<byte[]> getResourceAlternateDataAsync(final String guid, EvernoteCallback<byte[]> callback) {
        return this.submitTask(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return EvernoteNoteStoreClient.this.getResourceAlternateData(guid);
            }
        }, callback);
    }

    public ResourceAttributes getResourceAttributes(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getResourceAttributes(this.mAuthenticationToken, guid);
    }

    public Future<ResourceAttributes> getResourceAttributesAsync(final String guid, EvernoteCallback<ResourceAttributes> callback) {
        return this.submitTask(new Callable<ResourceAttributes>(){

            @Override
            public ResourceAttributes call() throws Exception {
                return EvernoteNoteStoreClient.this.getResourceAttributes(guid);
            }
        }, callback);
    }

    public Notebook getPublicNotebook(int userId, String publicUri) throws EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.getPublicNotebook(userId, publicUri);
    }

    public Future<Notebook> getPublicNotebookAsync(final int userId, final String publicUri, EvernoteCallback<Notebook> callback) {
        return this.submitTask(new Callable<Notebook>(){

            @Override
            public Notebook call() throws Exception {
                return EvernoteNoteStoreClient.this.getPublicNotebook(userId, publicUri);
            }
        }, callback);
    }

    public SharedNotebook createSharedNotebook(SharedNotebook sharedNotebook) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.createSharedNotebook(this.mAuthenticationToken, sharedNotebook);
    }

    public Future<SharedNotebook> createSharedNotebookAsync(final SharedNotebook sharedNotebook, EvernoteCallback<SharedNotebook> callback) {
        return this.submitTask(new Callable<SharedNotebook>(){

            @Override
            public SharedNotebook call() throws Exception {
                return EvernoteNoteStoreClient.this.createSharedNotebook(sharedNotebook);
            }
        }, callback);
    }

    public int updateSharedNotebook(SharedNotebook sharedNotebook) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.updateSharedNotebook(this.mAuthenticationToken, sharedNotebook);
    }

    public Future<Integer> updateSharedNotebookAsync(final SharedNotebook sharedNotebook, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.updateSharedNotebook(sharedNotebook);
            }
        }, callback);
    }

    public int setSharedNotebookRecipientSettings(long sharedNotebookId, SharedNotebookRecipientSettings recipientSettings) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.setSharedNotebookRecipientSettings(this.mAuthenticationToken, sharedNotebookId, recipientSettings);
    }

    public Future<Integer> setSharedNotebookRecipientSettingsAsync(final long sharedNotebookId, final SharedNotebookRecipientSettings recipientSettings, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.setSharedNotebookRecipientSettings(sharedNotebookId, recipientSettings);
            }
        }, callback);
    }

    public int sendMessageToSharedNotebookMembers(String notebookGuid, String messageText, List<String> recipients) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.sendMessageToSharedNotebookMembers(this.mAuthenticationToken, notebookGuid, messageText, recipients);
    }

    public Future<Integer> sendMessageToSharedNotebookMembersAsync(final String notebookGuid, final String messageText, final List<String> recipients, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.sendMessageToSharedNotebookMembers(notebookGuid, messageText, recipients);
            }
        }, callback);
    }

    public List<SharedNotebook> listSharedNotebooks() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.listSharedNotebooks(this.mAuthenticationToken);
    }

    public Future<List<SharedNotebook>> listSharedNotebooksAsync(EvernoteCallback<List<SharedNotebook>> callback) {
        return this.submitTask(new Callable<List<SharedNotebook>>(){

            @Override
            public List<SharedNotebook> call() throws Exception {
                return EvernoteNoteStoreClient.this.listSharedNotebooks();
            }
        }, callback);
    }

    public int expungeSharedNotebooks(List<Long> sharedNotebookIds) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.expungeSharedNotebooks(this.mAuthenticationToken, sharedNotebookIds);
    }

    public Future<Integer> expungeSharedNotebooksAsync(final List<Long> sharedNotebookIds, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.expungeSharedNotebooks(sharedNotebookIds);
            }
        }, callback);
    }

    public LinkedNotebook createLinkedNotebook(LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.createLinkedNotebook(this.mAuthenticationToken, linkedNotebook);
    }

    public Future<LinkedNotebook> createLinkedNotebookAsync(final LinkedNotebook linkedNotebook, EvernoteCallback<LinkedNotebook> callback) {
        return this.submitTask(new Callable<LinkedNotebook>(){

            @Override
            public LinkedNotebook call() throws Exception {
                return EvernoteNoteStoreClient.this.createLinkedNotebook(linkedNotebook);
            }
        }, callback);
    }

    public int updateLinkedNotebook(LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.updateLinkedNotebook(this.mAuthenticationToken, linkedNotebook);
    }

    public Future<Integer> updateLinkedNotebookAsync(final LinkedNotebook linkedNotebook, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.updateLinkedNotebook(linkedNotebook);
            }
        }, callback);
    }

    public List<LinkedNotebook> listLinkedNotebooks() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.listLinkedNotebooks(this.mAuthenticationToken);
    }

    public Future<List<LinkedNotebook>> listLinkedNotebooksAsync(EvernoteCallback<List<LinkedNotebook>> callback) {
        return this.submitTask(new Callable<List<LinkedNotebook>>(){

            @Override
            public List<LinkedNotebook> call() throws Exception {
                return EvernoteNoteStoreClient.this.listLinkedNotebooks();
            }
        }, callback);
    }

    public int expungeLinkedNotebook(String guid) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.expungeLinkedNotebook(this.mAuthenticationToken, guid);
    }

    public Future<Integer> expungeLinkedNotebookAsync(final String guid, EvernoteCallback<Integer> callback) {
        return this.submitTask(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return EvernoteNoteStoreClient.this.expungeLinkedNotebook(guid);
            }
        }, callback);
    }

    public AuthenticationResult authenticateToSharedNotebook(String shareKey) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.authenticateToSharedNotebook(shareKey, this.mAuthenticationToken);
    }

    public Future<AuthenticationResult> authenticateToSharedNotebookAsync(final String shareKey, EvernoteCallback<AuthenticationResult> callback) {
        return this.submitTask(new Callable<AuthenticationResult>(){

            @Override
            public AuthenticationResult call() throws Exception {
                return EvernoteNoteStoreClient.this.authenticateToSharedNotebook(shareKey);
            }
        }, callback);
    }

    public SharedNotebook getSharedNotebookByAuth() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.getSharedNotebookByAuth(this.mAuthenticationToken);
    }

    public Future<SharedNotebook> getSharedNotebookByAuthAsync(EvernoteCallback<SharedNotebook> callback) {
        return this.submitTask(new Callable<SharedNotebook>(){

            @Override
            public SharedNotebook call() throws Exception {
                return EvernoteNoteStoreClient.this.getSharedNotebookByAuth();
            }
        }, callback);
    }

    public void emailNote(NoteEmailParameters parameters) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        this.mClient.emailNote(this.mAuthenticationToken, parameters);
    }

    public Future<Void> emailNoteAsync(final NoteEmailParameters parameters, EvernoteCallback<Void> callback) {
        return this.submitTask(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EvernoteNoteStoreClient.this.emailNote(parameters);
                return null;
            }
        }, callback);
    }

    public String shareNote(String guid) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.shareNote(this.mAuthenticationToken, guid);
    }

    public Future<String> shareNoteAsync(final String guid, EvernoteCallback<String> callback) {
        return this.submitTask(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return EvernoteNoteStoreClient.this.shareNote(guid);
            }
        }, callback);
    }

    public void stopSharingNote(String guid) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        this.mClient.stopSharingNote(this.mAuthenticationToken, guid);
    }

    public Future<Void> stopSharingNoteAsync(final String guid, EvernoteCallback<Void> callback) {
        return this.submitTask(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EvernoteNoteStoreClient.this.stopSharingNote(guid);
                return null;
            }
        }, callback);
    }

    public AuthenticationResult authenticateToSharedNote(String guid, String noteKey) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.mClient.authenticateToSharedNote(guid, noteKey, this.mAuthenticationToken);
    }

    public Future<AuthenticationResult> authenticateToSharedNoteAsync(final String guid, final String noteKey, EvernoteCallback<AuthenticationResult> callback) {
        return this.submitTask(new Callable<AuthenticationResult>(){

            @Override
            public AuthenticationResult call() throws Exception {
                return EvernoteNoteStoreClient.this.authenticateToSharedNote(guid, noteKey);
            }
        }, callback);
    }

    public RelatedResult findRelated(RelatedQuery query, RelatedResultSpec resultSpec) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.mClient.findRelated(this.mAuthenticationToken, query, resultSpec);
    }

    public Future<RelatedResult> findRelatedAsync(final RelatedQuery query, final RelatedResultSpec resultSpec, EvernoteCallback<RelatedResult> callback) {
        return this.submitTask(new Callable<RelatedResult>(){

            @Override
            public RelatedResult call() throws Exception {
                return EvernoteNoteStoreClient.this.findRelated(query, resultSpec);
            }
        }, callback);
    }
}

