/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android.asyncclient;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.android.asyncclient.EvernoteAsyncClient;
import com.evernote.client.android.asyncclient.EvernoteBusinessNotebookHelper;
import com.evernote.client.android.asyncclient.EvernoteCallback;
import com.evernote.client.android.asyncclient.EvernoteClientFactory;
import com.evernote.client.android.asyncclient.EvernoteLinkedNotebookHelper;
import com.evernote.client.android.asyncclient.EvernoteNoteStoreClient;
import com.evernote.client.android.helper.EvernotePreconditions;
import com.evernote.client.android.type.NoteRef;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.NoteFilter;
import com.evernote.edam.notestore.NoteMetadata;
import com.evernote.edam.notestore.NotesMetadataList;
import com.evernote.edam.notestore.NotesMetadataResultSpec;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.NoteSortOrder;
import com.evernote.edam.type.Notebook;
import com.evernote.thrift.TException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class EvernoteSearchHelper
extends EvernoteAsyncClient {
    private final EvernoteSession mSession;
    private final EvernoteClientFactory mClientFactory;
    private final EvernoteNoteStoreClient mPrivateClient;

    public EvernoteSearchHelper(@NonNull EvernoteSession session, @NonNull ExecutorService executorService) {
        super(executorService);
        this.mSession = EvernotePreconditions.checkNotNull(session);
        this.mClientFactory = this.mSession.getEvernoteClientFactory();
        this.mPrivateClient = this.mClientFactory.getNoteStoreClient();
    }

    public Result execute(@NonNull Search search) throws Exception {
        if (search.getOffset() >= search.getMaxNotes()) {
            throw new IllegalArgumentException("offset must be less than max notes");
        }
        Result result = new Result(search.getScopes());
        block11: for (Scope scope : search.getScopes()) {
            switch (scope) {
                case PERSONAL_NOTES: {
                    try {
                        result.setPersonalResults(this.findPersonalNotes(search));
                    }
                    catch (Exception e) {
                        this.maybeRethrow(search, e);
                    }
                    break;
                }
                case LINKED_NOTEBOOKS: {
                    List<LinkedNotebook> linkedNotebooks = this.getLinkedNotebooks(search, false);
                    for (LinkedNotebook linkedNotebook : linkedNotebooks) {
                        try {
                            result.addLinkedNotebookResult(linkedNotebook, this.findNotesInLinkedNotebook(search, linkedNotebook));
                        }
                        catch (Exception e) {
                            this.maybeRethrow(search, e);
                        }
                    }
                    continue block11;
                }
                case BUSINESS: {
                    List<LinkedNotebook> linkedNotebooks = this.getLinkedNotebooks(search, true);
                    for (LinkedNotebook linkedNotebook : linkedNotebooks) {
                        try {
                            result.addBusinessResult(linkedNotebook, this.findNotesInBusinessNotebook(search, linkedNotebook));
                        }
                        catch (Exception e) {
                            this.maybeRethrow(search, e);
                        }
                    }
                    break;
                }
            }
        }
        return result;
    }

    public Future<Result> executeAsync(final @NonNull Search search, @Nullable EvernoteCallback<Result> callback) {
        return this.submitTask(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return EvernoteSearchHelper.this.execute(search);
            }
        }, callback);
    }

    protected List<NotesMetadataList> findPersonalNotes(Search search) throws Exception {
        return this.findAllNotes(search, this.mPrivateClient, search.getNoteFilter());
    }

    protected List<NotesMetadataList> findNotesInLinkedNotebook(Search search, LinkedNotebook linkedNotebook) throws Exception {
        EvernoteLinkedNotebookHelper linkedNotebookHelper = this.mClientFactory.getLinkedNotebookHelper(linkedNotebook);
        Notebook correspondingNotebook = linkedNotebookHelper.getCorrespondingNotebook();
        NoteFilter noteFilter = new NoteFilter(search.getNoteFilter());
        noteFilter.setNotebookGuid(correspondingNotebook.getGuid());
        return this.findAllNotes(search, linkedNotebookHelper.getClient(), noteFilter);
    }

    protected List<NotesMetadataList> findNotesInBusinessNotebook(Search search, LinkedNotebook linkedNotebook) throws Exception {
        EvernoteBusinessNotebookHelper businessNotebookHelper = this.mClientFactory.getBusinessNotebookHelper();
        EvernoteLinkedNotebookHelper linkedNotebookHelper = this.mClientFactory.getLinkedNotebookHelper(linkedNotebook);
        Notebook correspondingNotebook = linkedNotebookHelper.getCorrespondingNotebook();
        NoteFilter noteFilter = new NoteFilter(search.getNoteFilter());
        noteFilter.setNotebookGuid(correspondingNotebook.getGuid());
        return this.findAllNotes(search, businessNotebookHelper.getClient(), noteFilter);
    }

    protected List<NotesMetadataList> findAllNotes(Search search, EvernoteNoteStoreClient client, NoteFilter filter) throws Exception {
        ArrayList<NotesMetadataList> result = new ArrayList<NotesMetadataList>();
        int maxNotes = search.getMaxNotes();
        int offset = search.getOffset();
        int remaining = maxNotes - offset;
        while (remaining > 0) {
            try {
                NotesMetadataList notesMetadata = client.findNotesMetadata(filter, offset, maxNotes, search.getResultSpec());
                remaining = notesMetadata.getTotalNotes() - (notesMetadata.getStartIndex() + notesMetadata.getNotesSize());
                result.add(notesMetadata);
            }
            catch (EDAMNotFoundException | EDAMSystemException | EDAMUserException | TException e) {
                this.maybeRethrow(search, (Exception)e);
                remaining -= search.getPageSize();
            }
            offset += search.getPageSize();
        }
        return result;
    }

    protected List<LinkedNotebook> getLinkedNotebooks(Search search, boolean business) throws Exception {
        if (business) {
            if (search.mBusinessNotebooks.isEmpty()) {
                try {
                    return this.mClientFactory.getBusinessNotebookHelper().listBusinessNotebooks(this.mSession);
                }
                catch (EDAMNotFoundException | EDAMSystemException | EDAMUserException | TException e) {
                    this.maybeRethrow(search, (Exception)e);
                    return Collections.emptyList();
                }
            }
            return search.mBusinessNotebooks;
        }
        if (search.mLinkedNotebooks.isEmpty()) {
            try {
                return this.mPrivateClient.listLinkedNotebooks();
            }
            catch (EDAMNotFoundException | EDAMSystemException | EDAMUserException | TException e) {
                this.maybeRethrow(search, (Exception)e);
                return Collections.emptyList();
            }
        }
        return search.mLinkedNotebooks;
    }

    private void maybeRethrow(Search search, Exception e) throws Exception {
        if (!search.isIgnoreExceptions()) {
            throw e;
        }
    }

    public static final class Result {
        private final List<NotesMetadataList> mPersonalResults;
        private final Map<Pair<String, LinkedNotebook>, List<NotesMetadataList>> mLinkedNotebookResults;
        private final Map<Pair<String, LinkedNotebook>, List<NotesMetadataList>> mBusinessResults;
        private NoteRef.Factory mNoteRefFactory;

        private Result(Set<Scope> scopes) {
            this.mPersonalResults = scopes.contains((Object)Scope.PERSONAL_NOTES) ? new ArrayList() : null;
            this.mLinkedNotebookResults = scopes.contains((Object)Scope.LINKED_NOTEBOOKS) ? new HashMap() : null;
            this.mBusinessResults = scopes.contains((Object)Scope.BUSINESS) ? new HashMap() : null;
            this.mNoteRefFactory = new NoteRef.DefaultFactory();
        }

        public void setNoteRefFactory(@NonNull NoteRef.Factory noteRefFactory) {
            this.mNoteRefFactory = EvernotePreconditions.checkNotNull(noteRefFactory);
        }

        private void setPersonalResults(List<NotesMetadataList> personalResults) {
            this.mPersonalResults.addAll(personalResults);
        }

        private void addLinkedNotebookResult(LinkedNotebook linkedNotebook, List<NotesMetadataList> linkedNotebookResult) {
            Pair key = new Pair((Object)linkedNotebook.getGuid(), (Object)linkedNotebook);
            this.mLinkedNotebookResults.put((Pair<String, LinkedNotebook>)key, linkedNotebookResult);
        }

        private void addBusinessResult(LinkedNotebook linkedNotebook, List<NotesMetadataList> linkedNotebookResult) {
            Pair key = new Pair((Object)linkedNotebook.getGuid(), (Object)linkedNotebook);
            this.mBusinessResults.put((Pair<String, LinkedNotebook>)key, linkedNotebookResult);
        }

        public List<NotesMetadataList> getPersonalResults() {
            return this.mPersonalResults;
        }

        public List<NoteRef> getPersonalResultsAsNoteRef() {
            if (this.mPersonalResults == null) {
                return null;
            }
            ArrayList<NoteRef> result = new ArrayList<NoteRef>();
            this.fillNoteRef(this.mPersonalResults, result, null);
            return result;
        }

        public Map<Pair<String, LinkedNotebook>, List<NotesMetadataList>> getLinkedNotebookResults() {
            return this.mLinkedNotebookResults;
        }

        public List<NoteRef> getLinkedNotebookResultsAsNoteRef() {
            if (this.mLinkedNotebookResults == null) {
                return null;
            }
            ArrayList<NoteRef> result = new ArrayList<NoteRef>();
            for (Pair<String, LinkedNotebook> key : this.mLinkedNotebookResults.keySet()) {
                List<NotesMetadataList> notesMetadataLists = this.mLinkedNotebookResults.get(key);
                this.fillNoteRef(notesMetadataLists, result, (LinkedNotebook)key.second);
            }
            return result;
        }

        public Map<Pair<String, LinkedNotebook>, List<NotesMetadataList>> getBusinessResults() {
            return this.mBusinessResults;
        }

        public List<NoteRef> getBusinessResultsAsNoteRef() {
            if (this.mBusinessResults == null) {
                return null;
            }
            ArrayList<NoteRef> result = new ArrayList<NoteRef>();
            for (Pair<String, LinkedNotebook> key : this.mBusinessResults.keySet()) {
                List<NotesMetadataList> notesMetadataLists = this.mBusinessResults.get(key);
                this.fillNoteRef(notesMetadataLists, result, (LinkedNotebook)key.second);
            }
            return result;
        }

        public List<NoteRef> getAllAsNoteRef() {
            ArrayList<NoteRef> result = new ArrayList<NoteRef>();
            List<NoteRef> part = this.getPersonalResultsAsNoteRef();
            if (part != null) {
                result.addAll(part);
            }
            if ((part = this.getLinkedNotebookResultsAsNoteRef()) != null) {
                result.addAll(part);
            }
            if ((part = this.getBusinessResultsAsNoteRef()) != null) {
                result.addAll(part);
            }
            return result;
        }

        protected void fillNoteRef(List<NotesMetadataList> notesMetadataList, List<NoteRef> result, LinkedNotebook linkedNotebook) {
            for (NotesMetadataList notesMetadataListEntry : notesMetadataList) {
                List notes = notesMetadataListEntry.getNotes();
                for (NoteMetadata note : notes) {
                    NoteRef ref = linkedNotebook == null ? this.mNoteRefFactory.fromPersonal(note) : this.mNoteRefFactory.fromLinked(note, linkedNotebook);
                    result.add(ref);
                }
            }
        }
    }

    public static class Search {
        private final EnumSet<Scope> mScopes = EnumSet.noneOf(Scope.class);
        private final List<LinkedNotebook> mLinkedNotebooks = new ArrayList<LinkedNotebook>();
        private final List<LinkedNotebook> mBusinessNotebooks = new ArrayList<LinkedNotebook>();
        private NoteFilter mNoteFilter;
        private NotesMetadataResultSpec mResultSpec;
        private int mOffset = -1;
        private int mMaxNotes = -1;
        private int mPageSize = -1;
        private boolean mIgnoreExceptions;

        public Search addScope(Scope scope) {
            this.mScopes.add(scope);
            return this;
        }

        public Search addLinkedNotebook(LinkedNotebook linkedNotebook) {
            if (EvernoteBusinessNotebookHelper.isBusinessNotebook(linkedNotebook)) {
                this.addScope(Scope.BUSINESS);
                this.mBusinessNotebooks.add(linkedNotebook);
            } else {
                this.addScope(Scope.LINKED_NOTEBOOKS);
                this.mLinkedNotebooks.add(linkedNotebook);
            }
            return this;
        }

        public Search setNoteFilter(NoteFilter noteFilter) {
            this.mNoteFilter = EvernotePreconditions.checkNotNull(noteFilter);
            return this;
        }

        public Search setResultSpec(NotesMetadataResultSpec resultSpec) {
            this.mResultSpec = EvernotePreconditions.checkNotNull(resultSpec);
            return this;
        }

        public Search setOffset(int offset) {
            this.mOffset = EvernotePreconditions.checkArgumentNonnegative(offset, "negative value now allowed");
            return this;
        }

        public Search setMaxNotes(int maxNotes) {
            this.mMaxNotes = EvernotePreconditions.checkArgumentPositive(maxNotes, "maxNotes must be greater or equal 1");
            return this;
        }

        public Search setPageSize(int pageSize) {
            this.mPageSize = EvernotePreconditions.checkArgumentPositive(pageSize, "pageSize must be greater or equal 1");
            return this;
        }

        public Search setIgnoreExceptions(boolean ignoreExceptions) {
            this.mIgnoreExceptions = ignoreExceptions;
            return this;
        }

        private EnumSet<Scope> getScopes() {
            if (this.mScopes.isEmpty()) {
                this.mScopes.add(Scope.PERSONAL_NOTES);
            }
            return this.mScopes;
        }

        private NoteFilter getNoteFilter() {
            if (this.mNoteFilter == null) {
                this.mNoteFilter = new NoteFilter();
                this.mNoteFilter.setOrder(NoteSortOrder.UPDATED.getValue());
            }
            return this.mNoteFilter;
        }

        private NotesMetadataResultSpec getResultSpec() {
            if (this.mResultSpec == null) {
                this.mResultSpec = new NotesMetadataResultSpec();
                this.mResultSpec.setIncludeTitle(true);
                this.mResultSpec.setIncludeNotebookGuid(true);
            }
            return this.mResultSpec;
        }

        private int getOffset() {
            if (this.mOffset < 0) {
                return 0;
            }
            return this.mOffset;
        }

        private int getMaxNotes() {
            if (this.mMaxNotes < 0) {
                return 10;
            }
            return this.mMaxNotes;
        }

        private int getPageSize() {
            if (this.mPageSize < 0) {
                return 10;
            }
            return this.mPageSize;
        }

        public boolean isIgnoreExceptions() {
            return this.mIgnoreExceptions;
        }
    }

    public static enum Scope {
        PERSONAL_NOTES,
        LINKED_NOTEBOOKS,
        BUSINESS;

    }
}

