/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android.asyncclient;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.evernote.client.android.asyncclient.EvernoteAsyncClient;
import com.evernote.client.android.asyncclient.EvernoteCallback;
import com.evernote.client.android.helper.EvernotePreconditions;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.PremiumInfo;
import com.evernote.edam.type.User;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.edam.userstore.BootstrapInfo;
import com.evernote.edam.userstore.PublicUserInfo;
import com.evernote.edam.userstore.UserStore;
import com.evernote.thrift.TException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class EvernoteUserStoreClient
extends EvernoteAsyncClient {
    private final UserStore.Client mClient;
    private final String mAuthenticationToken;

    EvernoteUserStoreClient(@NonNull UserStore.Client client, @Nullable String authenticationToken, @NonNull ExecutorService executorService) {
        super(executorService);
        this.mClient = EvernotePreconditions.checkNotNull(client);
        this.mAuthenticationToken = authenticationToken;
    }

    public boolean checkVersion(String clientName, short edamVersionMajor, short edamVersionMinor) throws TException {
        return this.mClient.checkVersion(clientName, edamVersionMajor, edamVersionMinor);
    }

    public Future<Boolean> checkVersionAsync(final String clientName, final short edamVersionMajor, final short edamVersionMinor, EvernoteCallback<Boolean> callback) {
        return this.submitTask(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return EvernoteUserStoreClient.this.checkVersion(clientName, edamVersionMajor, edamVersionMinor);
            }
        }, callback);
    }

    public BootstrapInfo getBootstrapInfo(String locale) throws TException {
        return this.mClient.getBootstrapInfo(locale);
    }

    public Future<BootstrapInfo> getBootstrapInfoAsync(final String locale, EvernoteCallback<BootstrapInfo> callback) {
        return this.submitTask(new Callable<BootstrapInfo>(){

            @Override
            public BootstrapInfo call() throws Exception {
                return EvernoteUserStoreClient.this.getBootstrapInfo(locale);
            }
        }, callback);
    }

    public AuthenticationResult authenticate(String username, String password, String consumerKey, String consumerSecret, boolean supportsTwoFactor) throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.authenticate(username, password, consumerKey, consumerSecret, supportsTwoFactor);
    }

    public Future<AuthenticationResult> authenticateAsync(final String username, final String password, final String consumerKey, final String consumerSecret, final boolean supportsTwoFactor, EvernoteCallback<AuthenticationResult> callback) {
        return this.submitTask(new Callable<AuthenticationResult>(){

            @Override
            public AuthenticationResult call() throws Exception {
                return EvernoteUserStoreClient.this.authenticate(username, password, consumerKey, consumerSecret, supportsTwoFactor);
            }
        }, callback);
    }

    public AuthenticationResult authenticateLongSession(String username, String password, String consumerKey, String consumerSecret, String deviceIdentifier, String deviceDescription, boolean supportsTwoFactor) throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.authenticateLongSession(username, password, consumerKey, consumerSecret, deviceIdentifier, deviceDescription, supportsTwoFactor);
    }

    public Future<AuthenticationResult> authenticateLongSessionAsync(final String username, final String password, final String consumerKey, final String consumerSecret, final String deviceIdentifier, final String deviceDescription, final boolean supportsTwoFactor, EvernoteCallback<AuthenticationResult> callback) {
        return this.submitTask(new Callable<AuthenticationResult>(){

            @Override
            public AuthenticationResult call() throws Exception {
                return EvernoteUserStoreClient.this.authenticateLongSession(username, password, consumerKey, consumerSecret, deviceIdentifier, deviceDescription, supportsTwoFactor);
            }
        }, callback);
    }

    public AuthenticationResult completeTwoFactorAuthentication(String authenticationToken, String oneTimeCode, String deviceIdentifier, String deviceDescription) throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.completeTwoFactorAuthentication(authenticationToken, oneTimeCode, deviceIdentifier, deviceDescription);
    }

    public Future<AuthenticationResult> completeTwoFactorAuthenticationAsync(final String authenticationToken, final String oneTimeCode, final String deviceIdentifier, final String deviceDescription, EvernoteCallback<AuthenticationResult> callback) {
        return this.submitTask(new Callable<AuthenticationResult>(){

            @Override
            public AuthenticationResult call() throws Exception {
                return EvernoteUserStoreClient.this.completeTwoFactorAuthentication(authenticationToken, oneTimeCode, deviceIdentifier, deviceDescription);
            }
        }, callback);
    }

    public void revokeLongSession() throws EDAMUserException, EDAMSystemException, TException {
        this.mClient.revokeLongSession(this.mAuthenticationToken);
    }

    public Future<Void> revokeLongSessionAsync(EvernoteCallback<Void> evernoteCallback) {
        return this.submitTask(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EvernoteUserStoreClient.this.revokeLongSession();
                return null;
            }
        }, evernoteCallback);
    }

    public AuthenticationResult authenticateToBusiness() throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.authenticateToBusiness(this.mAuthenticationToken);
    }

    public Future<AuthenticationResult> authenticateToBusinessAsync(EvernoteCallback<AuthenticationResult> callback) {
        return this.submitTask(new Callable<AuthenticationResult>(){

            @Override
            public AuthenticationResult call() throws Exception {
                return EvernoteUserStoreClient.this.authenticateToBusiness();
            }
        }, callback);
    }

    public AuthenticationResult refreshAuthentication() throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.refreshAuthentication(this.mAuthenticationToken);
    }

    public Future<AuthenticationResult> refreshAuthenticationAsync(EvernoteCallback<AuthenticationResult> callback) {
        return this.submitTask(new Callable<AuthenticationResult>(){

            @Override
            public AuthenticationResult call() throws Exception {
                return EvernoteUserStoreClient.this.refreshAuthentication();
            }
        }, callback);
    }

    public User getUser() throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.getUser(this.mAuthenticationToken);
    }

    public Future<User> getUserAsync(EvernoteCallback<User> callback) {
        return this.submitTask(new Callable<User>(){

            @Override
            public User call() throws Exception {
                return EvernoteUserStoreClient.this.getUser();
            }
        }, callback);
    }

    public PublicUserInfo getPublicUserInfo(String username) throws EDAMNotFoundException, EDAMSystemException, EDAMUserException, TException {
        return this.mClient.getPublicUserInfo(username);
    }

    public Future<PublicUserInfo> getPublicUserInfoAsync(final String username, EvernoteCallback<PublicUserInfo> callback) {
        return this.submitTask(new Callable<PublicUserInfo>(){

            @Override
            public PublicUserInfo call() throws Exception {
                return EvernoteUserStoreClient.this.getPublicUserInfo(username);
            }
        }, callback);
    }

    public PremiumInfo getPremiumInfo() throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.getPremiumInfo(this.mAuthenticationToken);
    }

    public Future<PremiumInfo> getPremiumInfoAsync(EvernoteCallback<PremiumInfo> callback) {
        return this.submitTask(new Callable<PremiumInfo>(){

            @Override
            public PremiumInfo call() throws Exception {
                return EvernoteUserStoreClient.this.getPremiumInfo();
            }
        }, callback);
    }

    public String getNoteStoreUrl() throws EDAMUserException, EDAMSystemException, TException {
        return this.mClient.getNoteStoreUrl(this.mAuthenticationToken);
    }

    public Future<String> getNoteStoreUrlAsync(EvernoteCallback<String> callback) {
        return this.submitTask(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return EvernoteUserStoreClient.this.getNoteStoreUrl();
            }
        }, callback);
    }

    public boolean isBusinessUser() throws TException, EDAMUserException, EDAMSystemException {
        return this.getUser().getAccounting().isSetBusinessId();
    }

    public Future<Boolean> isBusinessUserAsync(EvernoteCallback<Boolean> callback) {
        return this.submitTask(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return EvernoteUserStoreClient.this.isBusinessUser();
            }
        }, callback);
    }
}

