/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android.login;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import com.evernote.androidsdk.R;
import com.evernote.client.android.EvernoteOAuthHelper;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.android.login.EvernoteLoginTask;
import java.io.Serializable;
import java.util.Locale;
import net.vrallev.android.task.Task;
import net.vrallev.android.task.TaskExecutor;
import net.vrallev.android.task.TaskResult;

public class EvernoteLoginActivity
extends Activity
implements EvernoteLoginTask.LoginTaskCallback {
    private static final String EXTRA_CONSUMER_KEY = "EXTRA_CONSUMER_KEY";
    private static final String EXTRA_CONSUMER_SECRET = "EXTRA_CONSUMER_SECRET";
    private static final String EXTRA_SUPPORT_APP_LINKED_NOTEBOOKS = "EXTRA_SUPPORT_APP_LINKED_NOTEBOOKS";
    private static final String EXTRA_LOCALE = "EXTRA_LOCALE";
    private static final String KEY_TASK = "KEY_TASK";
    private static final String KEY_RESULT_POSTED = "KEY_RESULT_POSTED";
    private int mTaskKey;
    private boolean mResultPosted;
    private ProgressDialog mProgressDialog;

    public static Intent createIntent(Context context, String consumerKey, String consumerSecret, boolean supportAppLinkedNotebooks, Locale locale) {
        Intent intent = new Intent(context, EvernoteLoginActivity.class);
        intent.putExtra(EXTRA_CONSUMER_KEY, consumerKey);
        intent.putExtra(EXTRA_CONSUMER_SECRET, consumerSecret);
        intent.putExtra(EXTRA_SUPPORT_APP_LINKED_NOTEBOOKS, supportAppLinkedNotebooks);
        intent.putExtra(EXTRA_LOCALE, (Serializable)locale);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            Bundle args = this.getIntent().getExtras();
            EvernoteOAuthHelper helper = new EvernoteOAuthHelper(EvernoteSession.getInstance(), args.getString(EXTRA_CONSUMER_KEY), args.getString(EXTRA_CONSUMER_SECRET), args.getBoolean(EXTRA_SUPPORT_APP_LINKED_NOTEBOOKS, true), (Locale)args.getSerializable(EXTRA_LOCALE));
            this.mTaskKey = TaskExecutor.getInstance().execute((Task)new EvernoteLoginTask(helper, false), (Activity)this);
        } else {
            this.mTaskKey = savedInstanceState.getInt(KEY_TASK, -1);
            this.mResultPosted = savedInstanceState.getBoolean(KEY_RESULT_POSTED, false);
        }
    }

    protected void onStart() {
        super.onStart();
        if (this.mProgressDialog == null || !this.mProgressDialog.isShowing()) {
            this.showDialog();
        }
    }

    protected void onStop() {
        this.mProgressDialog.dismiss();
        this.mProgressDialog = null;
        super.onStop();
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_TASK, this.mTaskKey);
        outState.putBoolean(KEY_RESULT_POSTED, this.mResultPosted);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 858 || requestCode == 859) {
            EvernoteLoginTask task = (EvernoteLoginTask)TaskExecutor.getInstance().getTask(this.mTaskKey);
            if (task != null) {
                task.onActivityResult(resultCode, data);
            }
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    @TaskResult
    public final void onResult(Boolean result, EvernoteLoginTask task) {
        if (this.mResultPosted || task != null && task.getKey() != this.mTaskKey) {
            return;
        }
        this.mResultPosted = true;
        this.setResult(result != false ? -1 : 0);
        this.finish();
    }

    protected void showDialog() {
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                EvernoteLoginTask task = (EvernoteLoginTask)TaskExecutor.getInstance().getTask(EvernoteLoginActivity.this.mTaskKey);
                if (task != null) {
                    task.cancel();
                }
                EvernoteLoginActivity.this.onResult(false, task);
            }
        };
        this.mProgressDialog = new ProgressDialog((Context)this);
        this.mProgressDialog.setIndeterminate(true);
        this.mProgressDialog.setMessage((CharSequence)this.getString(R.string.esdk_loading));
        this.mProgressDialog.setButton(-2, (CharSequence)this.getString(0x1040000), onClickListener);
        this.mProgressDialog.setCancelable(false);
        this.mProgressDialog.show();
    }

    @Override
    public void show(final String bootstrapScreenName) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Button button = EvernoteLoginActivity.this.mProgressDialog.getButton(-1);
                if (!TextUtils.isEmpty((CharSequence)bootstrapScreenName)) {
                    button.setText((CharSequence)EvernoteLoginActivity.this.getString(R.string.esdk_switch_to, new Object[]{bootstrapScreenName}));
                    button.setVisibility(0);
                    button.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            EvernoteLoginActivity.this.switchBootstrapProfile();
                        }
                    });
                } else {
                    button.setVisibility(8);
                    button.setOnClickListener(null);
                }
            }
        });
    }

    protected void switchBootstrapProfile() {
        EvernoteLoginTask task = (EvernoteLoginTask)TaskExecutor.getInstance().getTask(this.mTaskKey);
        if (task != null) {
            task.switchBootstrapProfile();
        }
    }
}

