/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android.login;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import com.evernote.androidsdk.R;
import com.evernote.client.android.EvernoteOAuthHelper;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.android.login.EvernoteLoginTask;
import java.io.Serializable;
import java.util.Locale;
import net.vrallev.android.task.Task;
import net.vrallev.android.task.TaskExecutor;
import net.vrallev.android.task.TaskResult;

public class EvernoteLoginFragment
extends DialogFragment
implements EvernoteLoginTask.LoginTaskCallback {
    public static final String TAG = "EvernoteDialogFragment";
    private static final String ARG_CONSUMER_KEY = "consumerKey";
    private static final String ARG_CONSUMER_SECRET = "consumerSecret";
    private static final String ARG_SUPPORT_APP_LINKED_NOTEBOOKS = "supportAppLinkedNotebooks";
    private static final String ARG_LOCALE = "ARG_LOCALE";
    private static final String KEY_TASK = "KEY_TASK";
    private static final String KEY_RESULT_POSTED = "KEY_RESULT_POSTED";
    private int mTaskKey = -1;
    private boolean mResultPosted;

    public static EvernoteLoginFragment create(String consumerKey, String consumerSecret, boolean supportAppLinkedNotebooks, Locale locale) {
        return EvernoteLoginFragment.create(EvernoteLoginFragment.class, consumerKey, consumerSecret, supportAppLinkedNotebooks, locale);
    }

    public static <T extends EvernoteLoginFragment> T create(Class<T> subClass, String consumerKey, String consumerSecret, boolean supportAppLinkedNotebooks, Locale locale) {
        EvernoteLoginFragment fragment;
        try {
            fragment = (EvernoteLoginFragment)subClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        Bundle args = new Bundle();
        args.putString(ARG_CONSUMER_KEY, consumerKey);
        args.putString(ARG_CONSUMER_SECRET, consumerSecret);
        args.putBoolean(ARG_SUPPORT_APP_LINKED_NOTEBOOKS, supportAppLinkedNotebooks);
        args.putSerializable(ARG_LOCALE, (Serializable)locale);
        fragment.setArguments(args);
        return (T)fragment;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (savedInstanceState == null) {
            Bundle args = this.getArguments();
            EvernoteOAuthHelper helper = new EvernoteOAuthHelper(EvernoteSession.getInstance(), args.getString(ARG_CONSUMER_KEY), args.getString(ARG_CONSUMER_SECRET), args.getBoolean(ARG_SUPPORT_APP_LINKED_NOTEBOOKS, true), (Locale)args.getSerializable(ARG_LOCALE));
            this.mTaskKey = TaskExecutor.getInstance().execute((Task)new EvernoteLoginTask(helper, true), (Fragment)this);
        } else {
            this.mTaskKey = savedInstanceState.getInt(KEY_TASK, -1);
            this.mResultPosted = savedInstanceState.getBoolean(KEY_RESULT_POSTED, false);
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        this.setCancelable(false);
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                EvernoteLoginTask task = (EvernoteLoginTask)TaskExecutor.getInstance().getTask(EvernoteLoginFragment.this.mTaskKey);
                if (task != null) {
                    task.cancel();
                }
                EvernoteLoginFragment.this.onResult(false, task);
            }
        };
        ProgressDialog progressDialog = new ProgressDialog((Context)this.getActivity());
        progressDialog.setIndeterminate(true);
        progressDialog.setMessage((CharSequence)this.getString(R.string.esdk_loading));
        progressDialog.setButton(-2, (CharSequence)this.getString(0x1040000), onClickListener);
        progressDialog.setCancelable(this.isCancelable());
        return progressDialog;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_TASK, this.mTaskKey);
        outState.putBoolean(KEY_RESULT_POSTED, this.mResultPosted);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 858 || requestCode == 859) {
            EvernoteLoginTask task = (EvernoteLoginTask)TaskExecutor.getInstance().getTask(this.mTaskKey);
            if (task != null) {
                task.onActivityResult(resultCode, data);
            }
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    @TaskResult
    public final synchronized void onResult(Boolean result, EvernoteLoginTask task) {
        if (this.mResultPosted || task != null && task.getKey() != this.mTaskKey) {
            return;
        }
        this.mResultPosted = true;
        this.dismiss();
        FragmentActivity activity = this.getActivity();
        if (activity instanceof ResultCallback) {
            ((ResultCallback)activity).onLoginFinished(result);
        } else {
            this.onLoginFinished(result);
        }
    }

    protected void onLoginFinished(boolean success) {
    }

    @Override
    public void show(final String bootstrapScreenName) {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ProgressDialog dialog = (ProgressDialog)EvernoteLoginFragment.this.getDialog();
                Button button = dialog.getButton(-1);
                if (!TextUtils.isEmpty((CharSequence)bootstrapScreenName)) {
                    button.setText((CharSequence)EvernoteLoginFragment.this.getString(R.string.esdk_switch_to, new Object[]{bootstrapScreenName}));
                    button.setVisibility(0);
                    button.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            EvernoteLoginFragment.this.switchBootstrapProfile();
                        }
                    });
                } else {
                    button.setVisibility(8);
                    button.setOnClickListener(null);
                }
            }
        });
    }

    protected void switchBootstrapProfile() {
        EvernoteLoginTask task = (EvernoteLoginTask)TaskExecutor.getInstance().getTask(this.mTaskKey);
        if (task != null) {
            task.switchBootstrapProfile();
        }
    }

    public static interface ResultCallback {
        public void onLoginFinished(boolean var1);
    }
}

