/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android.login;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import com.evernote.client.android.EvernoteOAuthHelper;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.android.EvernoteUtil;
import com.evernote.client.android.helper.Cat;
import com.evernote.edam.userstore.BootstrapProfile;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.vrallev.android.task.Task;

class EvernoteLoginTask
extends Task<Boolean> {
    private static final Cat CAT = new Cat("EvernoteLoginTask");
    public static final int REQUEST_AUTH = 858;
    public static final int REQUEST_PROFILE_NAME = 859;
    private final EvernoteOAuthHelper mOAuthHelper;
    private List<BootstrapProfile> mBootstrapProfiles;
    private BootstrapProfile mBootstrapProfile;
    private int mBootstrapIndex;
    private CountDownLatch mBootstrapCountDownLatch;
    private CountDownLatch mResultCountDownLatch;
    private int mResultCode;
    private Intent mData;
    private final boolean mIsFragment;

    public EvernoteLoginTask(EvernoteOAuthHelper helper, boolean isFragment) {
        this.mOAuthHelper = helper;
        this.mIsFragment = isFragment;
    }

    public Boolean execute() {
        boolean intentFired = this.startAuthorization();
        if (!intentFired) {
            return false;
        }
        if (!this.canContinue()) {
            return false;
        }
        this.mResultCountDownLatch = new CountDownLatch(1);
        try {
            this.mResultCountDownLatch.await();
        }
        catch (InterruptedException e) {
            return false;
        }
        return this.finishAuthorization();
    }

    public void switchBootstrapProfile() {
        this.mBootstrapIndex = (this.mBootstrapIndex + 1) % this.mBootstrapProfiles.size();
        this.mBootstrapProfile = this.mBootstrapProfiles.get(this.mBootstrapIndex);
        if (this.mBootstrapCountDownLatch != null) {
            this.mBootstrapCountDownLatch.countDown();
        }
    }

    public void onActivityResult(int resultCode, Intent data) {
        if (this.mResultCountDownLatch != null) {
            this.mResultCountDownLatch.countDown();
        }
        this.mResultCode = resultCode;
        this.mData = data;
    }

    private boolean startAuthorization() {
        if (!this.canContinue()) {
            return false;
        }
        try {
            this.mBootstrapProfiles = this.mOAuthHelper.fetchBootstrapProfiles();
            this.mBootstrapProfile = this.mOAuthHelper.getDefaultBootstrapProfile(this.mBootstrapProfiles);
            if (!this.canContinue()) {
                return false;
            }
            if (this.mBootstrapProfiles != null && this.mBootstrapProfiles.size() > 1) {
                String mainAppBootstrapName = this.getBootstrapProfileNameFromMainApp();
                if (!this.canContinue()) {
                    return false;
                }
                boolean showBootstrapOption = true;
                if (!TextUtils.isEmpty((CharSequence)mainAppBootstrapName)) {
                    for (BootstrapProfile bootstrapProfile : this.mBootstrapProfiles) {
                        if (!mainAppBootstrapName.equals(bootstrapProfile.getName())) continue;
                        this.mBootstrapProfile = bootstrapProfile;
                        showBootstrapOption = false;
                        break;
                    }
                }
                if (showBootstrapOption) {
                    for (int i = 0; i < this.mBootstrapProfiles.size(); ++i) {
                        if (!this.mBootstrapProfile.equals(this.mBootstrapProfiles.get(i))) continue;
                        this.mBootstrapIndex = i;
                        break;
                    }
                    this.showBootstrapOption();
                }
            }
        }
        catch (Exception e) {
            CAT.e(e);
        }
        if (this.mBootstrapProfile != null) {
            this.mOAuthHelper.setBootstrapProfile(this.mBootstrapProfile);
        }
        if (!this.canContinue()) {
            return false;
        }
        Intent intent = this.mOAuthHelper.startAuthorization(this.getActivity());
        if (!this.canContinue() || intent == null) {
            return false;
        }
        LoginTaskCallback callback = this.getLoginTaskCallback();
        if (callback != null) {
            callback.startActivityForResult(intent, 858);
            return true;
        }
        return false;
    }

    private boolean finishAuthorization() {
        return this.canContinue() && this.mOAuthHelper.finishAuthorization(this.getActivity(), this.mResultCode, this.mData);
    }

    private boolean canContinue() {
        return !this.isCancelled() && this.getActivity() != null;
    }

    private LoginTaskCallback getLoginTaskCallback() {
        if (this.mIsFragment) {
            Fragment fragment = this.getFragment();
            if (fragment instanceof LoginTaskCallback) {
                return (LoginTaskCallback)fragment;
            }
            return null;
        }
        Activity activity = this.getActivity();
        if (activity instanceof LoginTaskCallback) {
            return (LoginTaskCallback)activity;
        }
        return null;
    }

    private void showBootstrapOption() {
        LoginTaskCallback loginTaskCallback = this.getLoginTaskCallback();
        if (loginTaskCallback == null) {
            return;
        }
        loginTaskCallback.show(this.getScreenName(this.getNextBootstrapProfile()));
        loginTaskCallback = null;
        this.mBootstrapCountDownLatch = new CountDownLatch(1);
        try {
            if (this.mBootstrapCountDownLatch.await(3L, TimeUnit.SECONDS)) {
                this.showBootstrapOption();
            } else {
                loginTaskCallback = this.getLoginTaskCallback();
                if (loginTaskCallback != null) {
                    loginTaskCallback.show(null);
                }
            }
        }
        catch (InterruptedException e) {
            CAT.e(e);
        }
    }

    private BootstrapProfile getNextBootstrapProfile() {
        int nextIndex = (this.mBootstrapIndex + 1) % this.mBootstrapProfiles.size();
        return this.mBootstrapProfiles.get(nextIndex);
    }

    private String getScreenName(BootstrapProfile profile) {
        if ("Evernote-China".equals(profile.getName())) {
            return "\u5370\u8c61\u7b14\u8bb0";
        }
        if ("https://www.evernote.com".contains(profile.getSettings().getServiceHost())) {
            return "Evernote International";
        }
        return profile.getName();
    }

    private String getBootstrapProfileNameFromMainApp() {
        Activity activity = this.getActivity();
        if (activity == null) {
            return null;
        }
        LoginTaskCallback callback = this.getLoginTaskCallback();
        if (callback == null) {
            return null;
        }
        Intent intent = EvernoteUtil.createGetBootstrapProfileNameIntent((Context)activity, EvernoteSession.getInstance());
        if (intent == null) {
            return null;
        }
        callback.startActivityForResult(intent, 859);
        this.mResultCountDownLatch = new CountDownLatch(1);
        try {
            this.mResultCountDownLatch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
        if (this.mData == null) {
            return null;
        }
        return this.mData.getStringExtra("bootstrap_profile_name");
    }

    public static interface LoginTaskCallback {
        public void startActivityForResult(Intent var1, int var2);

        public void show(String var1);
    }
}

