/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android.type;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.evernote.client.android.asyncclient.EvernoteNoteStoreClient;
import com.evernote.client.android.type.NoteRefHelper;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.NoteMetadata;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.thrift.TException;
import java.util.List;

public class NoteRef
implements Parcelable {
    private final String mNoteGuid;
    private final String mNotebookGuid;
    private final String mTitle;
    private final boolean mLinked;
    public static final Parcelable.Creator<NoteRef> CREATOR = new Parcelable.Creator<NoteRef>(){

        public NoteRef createFromParcel(Parcel source) {
            return new NoteRef(source.readString(), source.readString(), source.readString(), source.readInt() == 1);
        }

        public NoteRef[] newArray(int size) {
            return new NoteRef[size];
        }
    };

    public NoteRef(@NonNull String noteGuid, @Nullable String notebookGuid, @NonNull String title, boolean linked) {
        this.mNoteGuid = noteGuid;
        this.mNotebookGuid = notebookGuid;
        this.mTitle = title;
        this.mLinked = linked;
    }

    @NonNull
    public String getGuid() {
        return this.mNoteGuid;
    }

    public String getNotebookGuid() {
        return this.mNotebookGuid;
    }

    @NonNull
    public String getTitle() {
        return this.mTitle;
    }

    public boolean isLinked() {
        return this.mLinked;
    }

    public Note loadNote(boolean withContent, boolean withResourcesData, boolean withResourcesRecognition, boolean withResourcesAlternateData) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        EvernoteNoteStoreClient noteStore = NoteRefHelper.getNoteStore(this);
        if (noteStore == null) {
            return null;
        }
        return noteStore.getNote(this.mNoteGuid, withContent, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
    }

    public Note loadNotePartial() throws EDAMUserException, TException, EDAMSystemException, EDAMNotFoundException {
        return this.loadNote(false, false, false, false);
    }

    public Note loadNoteFully() throws EDAMUserException, TException, EDAMSystemException, EDAMNotFoundException {
        return this.loadNote(true, true, true, true);
    }

    public Notebook loadNotebook() throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        if (this.mNotebookGuid == null) {
            return null;
        }
        if (this.mLinked) {
            LinkedNotebook linkedNotebook = NoteRefHelper.getLinkedNotebook(this.mNotebookGuid);
            return NoteRefHelper.getSession().getEvernoteClientFactory().getLinkedNotebookHelper(linkedNotebook).getCorrespondingNotebook();
        }
        EvernoteNoteStoreClient noteStore = NoteRefHelper.getNoteStore(this);
        if (noteStore == null) {
            return null;
        }
        return noteStore.getNotebook(this.mNotebookGuid);
    }

    public LinkedNotebook loadLinkedNotebook() throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        if (!this.mLinked) {
            return null;
        }
        EvernoteNoteStoreClient noteStore = NoteRefHelper.getSession().getEvernoteClientFactory().getNoteStoreClient();
        if (noteStore == null) {
            return null;
        }
        List<LinkedNotebook> linkedNotebooks = noteStore.listLinkedNotebooks();
        for (LinkedNotebook linkedNotebook : linkedNotebooks) {
            if (!linkedNotebook.getGuid().equals(this.mNotebookGuid)) continue;
            return linkedNotebook;
        }
        return null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mNoteGuid);
        dest.writeString(this.mNotebookGuid);
        dest.writeString(this.mTitle);
        dest.writeInt(this.mLinked ? 1 : 0);
    }

    public static class DefaultFactory
    implements Factory {
        @Override
        public NoteRef fromPersonal(NoteMetadata personalNoteMetadata) {
            return new NoteRef(personalNoteMetadata.getGuid(), personalNoteMetadata.getNotebookGuid(), personalNoteMetadata.getTitle(), false);
        }

        @Override
        public NoteRef fromLinked(NoteMetadata linkedNoteMetadata, LinkedNotebook linkedNotebook) {
            return new NoteRef(linkedNoteMetadata.getGuid(), linkedNotebook.getGuid(), linkedNoteMetadata.getTitle(), true);
        }
    }

    public static interface Factory {
        public NoteRef fromPersonal(NoteMetadata var1);

        public NoteRef fromLinked(NoteMetadata var1, LinkedNotebook var2);
    }
}

