/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.conn.mobile;

import android.support.annotation.NonNull;
import com.evernote.client.conn.mobile.ByteStore;
import com.evernote.client.conn.mobile.LazyByteArrayOutputStream;
import com.squareup.okhttp.internal.Util;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DiskBackedByteStore
extends ByteStore {
    private static final int DEFAULT_MEMORY_BUFFER_SIZE = 0x200000;
    protected final int mMaxMemory;
    protected final File mCacheDir;
    protected final LazyByteArrayOutputStream mByteArrayOutputStream;
    protected File mCacheFile;
    protected OutputStream mCurrentOutputStream;
    protected FileOutputStream mFileOutputStream;
    protected int mBytesWritten;
    protected boolean mClosed;
    protected byte[] mData;
    protected byte[] mFileBuffer;

    protected DiskBackedByteStore(File cacheDir, int maxMemory) {
        this.mCacheDir = cacheDir;
        this.mMaxMemory = maxMemory;
        this.mByteArrayOutputStream = new LazyByteArrayOutputStream();
        this.mCurrentOutputStream = this.mByteArrayOutputStream;
    }

    @Override
    public void write(@NonNull byte[] buffer, int offset, int count) throws IOException {
        this.initBuffers();
        this.swapIfNecessary(count);
        this.mCurrentOutputStream.write(buffer, offset, count);
        this.mBytesWritten += count;
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.initBuffers();
        this.swapIfNecessary(1);
        this.mCurrentOutputStream.write(oneByte);
        ++this.mBytesWritten;
    }

    private void initBuffers() throws IOException {
        if (this.mClosed) {
            throw new IOException("Already closed");
        }
        if (this.mCurrentOutputStream == null) {
            this.mCurrentOutputStream = this.swapped() ? this.mFileOutputStream : this.mByteArrayOutputStream;
        }
    }

    private void swapIfNecessary(int delta) throws IOException {
        if (this.isSwapRequired(delta)) {
            this.swapToDisk();
        }
    }

    private boolean isSwapRequired(int delta) {
        return !this.swapped() && this.mBytesWritten + delta > this.mMaxMemory;
    }

    protected boolean swapped() {
        return this.mBytesWritten > this.mMaxMemory;
    }

    protected void swapToDisk() throws IOException {
        if (!this.mCacheDir.exists() && !this.mCacheDir.mkdirs()) {
            throw new IOException("could not create cache dir");
        }
        if (!this.mCacheDir.isDirectory()) {
            throw new IOException("cache dir is no directory");
        }
        this.mCacheFile = File.createTempFile("byte_store", null, this.mCacheDir);
        this.mFileOutputStream = new FileOutputStream(this.mCacheFile);
        this.mByteArrayOutputStream.writeTo(this.mFileOutputStream);
        this.mByteArrayOutputStream.reset();
        this.mCurrentOutputStream = this.mFileOutputStream;
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            Util.closeQuietly((Closeable)this.mFileOutputStream);
            this.mByteArrayOutputStream.reset();
            this.mClosed = true;
        }
    }

    @Override
    public int getBytesWritten() {
        return this.mBytesWritten;
    }

    @Override
    public byte[] getData() throws IOException {
        if (this.mData != null) {
            return this.mData;
        }
        this.close();
        if (this.swapped()) {
            if (this.mFileBuffer == null || this.mFileBuffer.length < this.mBytesWritten) {
                this.mFileBuffer = new byte[this.mBytesWritten];
            }
            DiskBackedByteStore.readFile(this.mCacheFile, this.mFileBuffer, this.mBytesWritten);
            this.mData = this.mFileBuffer;
        } else {
            this.mData = this.mByteArrayOutputStream.toByteArray();
        }
        return this.mData;
    }

    @Override
    public void reset() throws IOException {
        try {
            this.close();
            if (this.mCacheFile != null && this.mCacheFile.isFile() && !this.mCacheFile.delete()) {
                throw new IOException("could not delete cache file");
            }
        }
        finally {
            this.mFileOutputStream = null;
            this.mCurrentOutputStream = null;
            this.mBytesWritten = 0;
            this.mClosed = false;
            this.mData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFile(File file, byte[] buffer, int length) throws IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            int read = 0;
            int offset = 0;
            while (length > 0 && read >= 0) {
                read = ((InputStream)inputStream).read(buffer, offset, length);
                offset += read;
                length -= read;
            }
        }
        catch (Throwable throwable) {
            Util.closeQuietly(inputStream);
            throw throwable;
        }
        Util.closeQuietly((Closeable)inputStream);
    }

    public static class Factory
    implements ByteStore.Factory {
        private final File mCacheDir;
        private final int mMaxMemory;

        public Factory(File cacheDir) {
            this(cacheDir, 0x200000);
        }

        public Factory(File cacheDir, int maxMemory) {
            this.mCacheDir = cacheDir;
            this.mMaxMemory = maxMemory;
        }

        @Override
        public DiskBackedByteStore create() {
            return new DiskBackedByteStore(this.mCacheDir, this.mMaxMemory);
        }
    }
}

