/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.conn.mobile;

import android.support.annotation.NonNull;
import com.evernote.client.conn.mobile.ByteStore;
import com.evernote.client.conn.mobile.LazyByteArrayOutputStream;
import java.io.IOException;

public class MemoryByteStore
extends ByteStore {
    protected final LazyByteArrayOutputStream mByteArrayOutputStream = new LazyByteArrayOutputStream();
    protected int mBytesWritten;
    protected boolean mClosed;
    protected byte[] mData;

    protected MemoryByteStore() {
    }

    @Override
    public void write(@NonNull byte[] buffer, int offset, int count) throws IOException {
        this.checkNotClosed();
        this.mByteArrayOutputStream.write(buffer, offset, count);
        this.mBytesWritten += count;
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.checkNotClosed();
        this.mByteArrayOutputStream.write(oneByte);
        ++this.mBytesWritten;
    }

    private void checkNotClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("Already closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mByteArrayOutputStream.reset();
            this.mClosed = true;
        }
    }

    @Override
    public int getBytesWritten() {
        return this.mBytesWritten;
    }

    @Override
    public byte[] getData() throws IOException {
        if (this.mData != null) {
            return this.mData;
        }
        this.close();
        this.mData = this.mByteArrayOutputStream.toByteArray();
        return this.mData;
    }

    @Override
    public void reset() throws IOException {
        try {
            this.close();
        }
        finally {
            this.mData = null;
            this.mBytesWritten = 0;
            this.mClosed = false;
        }
    }

    public static class Factory
    implements ByteStore.Factory {
        @Override
        public MemoryByteStore create() {
            return new MemoryByteStore();
        }
    }
}

