/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.conn.mobile;

import android.support.annotation.NonNull;
import com.evernote.client.conn.mobile.ByteStore;
import com.evernote.thrift.transport.TTransport;
import com.evernote.thrift.transport.TTransportException;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okio.BufferedSink;

public class TAndroidTransport
extends TTransport {
    private static final MediaType MEDIA_TYPE_THRIFT = MediaType.parse((String)"application/x-thrift");
    private final OkHttpClient mHttpClient;
    private final ByteStore mByteStore;
    private final String mUrl;
    private InputStream mResponseBody;
    private Map<String, String> mHeaders;

    public TAndroidTransport(@NonNull OkHttpClient httpClient, @NonNull ByteStore byteStore, @NonNull String url) {
        this(httpClient, byteStore, url, null);
    }

    public TAndroidTransport(OkHttpClient httpClient, ByteStore byteStore, String url, Map<String, String> headers) {
        this.mHttpClient = httpClient;
        this.mByteStore = byteStore;
        this.mUrl = url;
        this.mHeaders = headers;
    }

    public void addHeader(String name, String value) {
        if (this.mHeaders == null) {
            this.mHeaders = new HashMap<String, String>();
        }
        this.mHeaders.put(name, value);
    }

    public void addHeaders(Map<String, String> headers) {
        if (this.mHeaders == null) {
            this.mHeaders = new HashMap<String, String>();
        }
        this.mHeaders.putAll(headers);
    }

    public boolean isOpen() {
        return true;
    }

    public void open() throws TTransportException {
    }

    public void write(byte[] buf, int off, int len) throws TTransportException {
        try {
            this.mByteStore.write(buf, off, len);
        }
        catch (IOException e) {
            throw new TTransportException((Throwable)e);
        }
    }

    public void flush() throws TTransportException {
        Util.closeQuietly((Closeable)this.mResponseBody);
        this.mResponseBody = null;
        RequestBody requestBody = new RequestBody(){

            public MediaType contentType() {
                if (TAndroidTransport.this.mHeaders != null && TAndroidTransport.this.mHeaders.containsKey("Content-Type")) {
                    return MediaType.parse((String)((String)TAndroidTransport.this.mHeaders.get("Content-Type")));
                }
                return MEDIA_TYPE_THRIFT;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(TAndroidTransport.this.mByteStore.getData(), 0, TAndroidTransport.this.mByteStore.getBytesWritten());
            }
        };
        try {
            Response response;
            Request.Builder builder = new Request.Builder().url(this.mUrl).post(requestBody);
            if (this.mHeaders != null) {
                for (String name : this.mHeaders.keySet()) {
                    builder.header(name, this.mHeaders.get(name));
                }
            }
            if ((response = this.mHttpClient.newCall(builder.build()).execute()).code() != 200) {
                throw new TTransportException("HTTP Response code: " + response.code() + ", message " + response.message());
            }
            this.mResponseBody = response.body().byteStream();
        }
        catch (Exception e) {
            throw new TTransportException((Throwable)e);
        }
        finally {
            try {
                this.mByteStore.reset();
            }
            catch (IOException iOException) {}
        }
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        if (this.mResponseBody == null) {
            throw new TTransportException("Response buffer is empty, no request.");
        }
        try {
            int ret = this.mResponseBody.read(buf, off, len);
            if (ret == -1) {
                throw new TTransportException("No more data available.");
            }
            return ret;
        }
        catch (IOException e) {
            throw new TTransportException((Throwable)e);
        }
    }

    public void close() {
        Util.closeQuietly((Closeable)this.mResponseBody);
        this.mResponseBody = null;
    }
}

