/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.android.state;

import android.app.Application;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.evernote.android.state.StateSaverImpl;
import java.util.LinkedHashMap;

public final class StateSaver {
    public static final String SUFFIX = "$$StateSaver";
    public static final String ANDROID_PREFIX = "android.";
    public static final String JAVA_PREFIX = "java.";
    private static final StateSaverImpl IMPL = new StateSaverImpl(new LinkedHashMap());

    public static <T> void saveInstanceState(@NonNull T target, @NonNull Bundle state) {
        IMPL.saveInstanceState(target, state);
    }

    public static <T> void restoreInstanceState(@NonNull T target, @Nullable Bundle state) {
        IMPL.restoreInstanceState(target, state);
    }

    @NonNull
    public static <T extends View> Parcelable saveInstanceState(@NonNull T target, @Nullable Parcelable state) {
        return IMPL.saveInstanceState(target, state);
    }

    @Nullable
    public static <T extends View> Parcelable restoreInstanceState(@NonNull T target, @Nullable Parcelable state) {
        return IMPL.restoreInstanceState(target, state);
    }

    public static void setEnabledForAllActivitiesAndSupportFragments(@NonNull Application application, boolean enabled) {
        IMPL.setEnabledForAllActivitiesAndSupportFragments(application, enabled);
    }

    private StateSaver() {
        throw new UnsupportedOperationException();
    }
}

