/* *****************************************************************************
 * Copyright (c) 2017 Frankie Sardo, and Evernote Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Frankie Sardo - initial API and implementation
 *    Ralf Wondratschek - documentation and feature enhancement
 *******************************************************************************/
package com.evernote.android.state;

import android.os.Bundle;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Fields or properties with this annotation will be saved in a {@link Bundle} and restored
 * from it while using the {@link StateSaver}. Compared to {@link State} this strategy relies
 * on reflection. If you can, you should use {@link State} instead.
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.CLASS)
public @interface StateReflection {
    Class<? extends Bundler> value() default Bundler.class;
}
