/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.mjiip.v_2_3;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.ModelLoader;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.reader.xmlschema.parser.SchemaConstraintChecker;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jvnet.jaxb2.maven2.IOptionsFactory;
import org.jvnet.jaxb2.maven2.RawXJC2Mojo;
import org.jvnet.mjiip.v_2_3.LoggingCodeWriter;
import org.jvnet.mjiip.v_2_3.LoggingErrorReceiver;
import org.jvnet.mjiip.v_2_3.OptionsFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class XJC23Mojo
extends RawXJC2Mojo<Options> {
    private final IOptionsFactory<Options> optionsFactory = new OptionsFactory();

    protected IOptionsFactory<Options> getOptionsFactory() {
        return this.optionsFactory;
    }

    public void doExecute(Options options) throws MojoExecutionException {
        Model model = this.loadModel(options);
        Outline outline = this.generateCode(model);
        this.writeCode(outline);
    }

    protected Model loadModel(Options options) throws MojoExecutionException {
        if (this.getVerbose()) {
            Object[] aGrammars = options.getGrammars();
            this.getLog().debug((CharSequence)("Parsing " + aGrammars.length + " input schema(s)..."));
            this.getLog().debug((CharSequence)("Input schemas: " + Arrays.toString(aGrammars)));
            for (Object x : aGrammars) {
                this.getLog().debug((CharSequence)"  Next InputSource");
                if (((InputSource)x).getPublicId() != null) {
                    this.getLog().debug((CharSequence)("    publicID: " + ((InputSource)x).getPublicId()));
                }
                if (((InputSource)x).getSystemId() != null) {
                    this.getLog().debug((CharSequence)("    systemID: " + ((InputSource)x).getSystemId()));
                }
                if (((InputSource)x).getEncoding() == null) continue;
                this.getLog().debug((CharSequence)("    encoding: " + ((InputSource)x).getEncoding()));
            }
            this.getLog().debug((CharSequence)("Entity resolver: " + options.entityResolver));
        }
        LoggingErrorReceiver er = new LoggingErrorReceiver("Error while parsing schema(s).", this.getLog(), this.getVerbose());
        InputSource[] schemas = options.getGrammars();
        this.getLog().debug((CharSequence)"Starting SchemaConstraintChecker");
        if (!SchemaConstraintChecker.check((InputSource[])schemas, (ErrorReceiver)er, (EntityResolver)this.getEntityResolver(), (boolean)false)) {
            this.getLog().error((CharSequence)"SchemaConstraintChecker failed");
        } else {
            this.getLog().debug((CharSequence)"SchemaConstraintChecker finished successfully");
        }
        Model model = ModelLoader.load((Options)options, (JCodeModel)new JCodeModel(), (ErrorReceiver)er);
        if (model == null) {
            throw new MojoExecutionException("Unable to parse input schema(s). Error messages should have been provided.");
        }
        try {
            Field f = model.getClass().getDeclaredField("schemaComponent");
            XSSchemaSet xs = (XSSchemaSet)f.get(model);
            if (this.getVerbose()) {
                this.getLog().info((CharSequence)("schemaComponent = " + xs));
            }
            if (xs != null) {
                Iterator it = xs.iterateSchema();
                while (it.hasNext()) {
                    XSSchema a = (XSSchema)it.next();
                    if (!this.getVerbose()) continue;
                    this.getLog().info((CharSequence)("  XSSchema = " + a));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return model;
    }

    protected Outline generateCode(Model model) throws MojoExecutionException {
        Outline outline;
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)"Compiling input schema(s)...");
        }
        if ((outline = model.generateCode(model.options, (ErrorReceiver)new LoggingErrorReceiver("Error while generating code.", this.getLog(), this.getVerbose()))) == null) {
            throw new MojoExecutionException("Failed to compile input schema(s)! Error messages should have been provided.");
        }
        return outline;
    }

    protected void writeCode(Outline outline) throws MojoExecutionException {
        if (this.getWriteCode()) {
            Model model = outline.getModel();
            JCodeModel codeModel = model.codeModel;
            File targetDirectory = model.options.targetDir;
            if (this.getVerbose()) {
                this.getLog().info((CharSequence)MessageFormat.format("Writing output to [{0}].", targetDirectory.getAbsolutePath()));
            }
            try {
                if (this.getCleanPackageDirectories()) {
                    if (this.getVerbose()) {
                        this.getLog().info((CharSequence)"Cleaning package directories.");
                    }
                    this.cleanPackageDirectories(targetDirectory, codeModel);
                }
                LoggingCodeWriter codeWriter = new LoggingCodeWriter(model.options.createCodeWriter(), this.getLog(), this.getVerbose());
                codeModel.build((CodeWriter)codeWriter);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write files: " + e.getMessage(), (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)"The [writeCode] setting is set to false, the code will not be written.");
        }
    }

    private void cleanPackageDirectories(File targetDirectory, JCodeModel codeModel) {
        Iterator packages = codeModel.packages();
        while (packages.hasNext()) {
            JPackage _package = (JPackage)packages.next();
            File packageDirectory = _package.isUnnamed() ? targetDirectory : new File(targetDirectory, _package.name().replace('.', File.separatorChar));
            if (!packageDirectory.isDirectory()) continue;
            if (XJC23Mojo.isRelevantPackage(_package)) {
                if (this.getVerbose()) {
                    this.getLog().info((CharSequence)MessageFormat.format("Cleaning directory [{0}] of the package [{1}].", packageDirectory.getAbsolutePath(), _package.name()));
                }
                this.cleanPackageDirectory(packageDirectory);
                continue;
            }
            if (!this.getVerbose()) continue;
            this.getLog().info((CharSequence)MessageFormat.format("Skipping directory [{0}] of the package [{1}] as it does not contain generated classes or resources.", packageDirectory.getAbsolutePath(), _package.name()));
        }
    }

    private static boolean isRelevantPackage(JPackage _package) {
        if (_package.propertyFiles().hasNext()) {
            return true;
        }
        Iterator classes = _package.classes();
        while (classes.hasNext()) {
            JDefinedClass _class = (JDefinedClass)classes.next();
            if (_class.isHidden()) continue;
            return true;
        }
        return false;
    }
}

