/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.alidns.model.v20150109.AddDomainRecordRequest;
import com.aliyuncs.alidns.model.v20150109.AddDomainRecordResponse;
import com.aliyuncs.alidns.model.v20150109.BindInstanceDomainsRequest;
import com.aliyuncs.alidns.model.v20150109.BindInstanceDomainsResponse;
import com.aliyuncs.alidns.model.v20150109.DeleteDomainRecordRequest;
import com.aliyuncs.alidns.model.v20150109.DescribeDnsProductInstanceRequest;
import com.aliyuncs.alidns.model.v20150109.DescribeDnsProductInstanceResponse;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainRecordInfoRequest;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainRecordInfoResponse;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainRecordsRequest;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainRecordsResponse;
import com.aliyuncs.alidns.model.v20150109.DescribeInstanceDomainsRequest;
import com.aliyuncs.alidns.model.v20150109.DescribeInstanceDomainsResponse;
import com.aliyuncs.alidns.model.v20150109.SetDomainRecordStatusRequest;
import com.aliyuncs.alidns.model.v20150109.SetDomainRecordStatusResponse;
import com.aliyuncs.alidns.model.v20150109.UnbindInstanceDomainsRequest;
import com.aliyuncs.alidns.model.v20150109.UnbindInstanceDomainsResponse;
import com.aliyuncs.alidns.model.v20150109.UpdateDomainRecordRequest;
import com.aliyuncs.domain.model.v20180129.QueryDomainListRequest;
import com.aliyuncs.domain.model.v20180129.QueryDomainListResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.eworkcloud.dns.DnsConfiguration;
import com.eworkcloud.dns.model.AliDomain;
import com.eworkcloud.dns.model.AliRecord;
import com.eworkcloud.dns.model.Instance;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.StringUtils;

public abstract class DnsClientUtils {
    public static int CONNECT_TIMEOUT = 10000;
    public static int READ_TIMEOUT = 20000;

    public static IAcsClient getAcsClient(String regionId, String accessKey, String secretKey) {
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)accessKey, (String)secretKey);
        return new DefaultAcsClient((IClientProfile)profile);
    }

    public static IAcsClient getAcsClient() {
        return DnsClientUtils.getAcsClient(DnsConfiguration.getRegionId(), DnsConfiguration.getAccessKey(), DnsConfiguration.getSecretKey());
    }

    public static List<AliDomain> getDomains(IAcsClient acsClient) {
        QueryDomainListResponse response;
        QueryDomainListRequest request = new QueryDomainListRequest();
        request.setSysConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        request.setSysReadTimeout(Integer.valueOf(READ_TIMEOUT));
        request.setPageSize(Integer.valueOf(100));
        request.setPageNum(Integer.valueOf(1));
        ArrayList<AliDomain> aliDomains = new ArrayList<AliDomain>();
        do {
            response = (QueryDomainListResponse)acsClient.getAcsResponse((AcsRequest)request);
            for (QueryDomainListResponse.Domain domain : response.getData()) {
                AliDomain aliDomain = new AliDomain();
                aliDomain.setDomain(domain.getDomainName());
                aliDomain.setEndTime(new Date(domain.getExpirationDateLong()));
                aliDomain.setStatus(Integer.parseInt(domain.getDomainStatus()));
                aliDomains.add(aliDomain);
            }
            request.setPageNum(Integer.valueOf(response.getCurrentPageNum() + 1));
        } while (response.getCurrentPageNum() < response.getTotalPageNum());
        return aliDomains;
    }

    private static Set<String> getDomains(IAcsClient acsClient, String instanceId) {
        DescribeInstanceDomainsResponse response;
        DescribeInstanceDomainsRequest request = new DescribeInstanceDomainsRequest();
        request.setSysConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        request.setSysReadTimeout(Integer.valueOf(READ_TIMEOUT));
        request.setInstanceId(instanceId);
        request.setPageSize(Long.valueOf(100L));
        request.setPageNumber(Long.valueOf(1L));
        LinkedHashSet<String> domains = new LinkedHashSet<String>();
        do {
            response = (DescribeInstanceDomainsResponse)acsClient.getAcsResponse((AcsRequest)request);
            for (DescribeInstanceDomainsResponse.InstanceDomain domain : response.getInstanceDomains()) {
                domains.add(domain.getDomainName());
            }
            request.setPageNumber(Long.valueOf((long)response.getPageNumber().intValue() + 1L));
        } while (response.getPageNumber() < response.getTotalPages());
        return domains;
    }

    public static Instance getInstance(IAcsClient acsClient, String instanceId) {
        DescribeDnsProductInstanceRequest request = new DescribeDnsProductInstanceRequest();
        request.setSysConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        request.setSysReadTimeout(Integer.valueOf(READ_TIMEOUT));
        request.setInstanceId(instanceId);
        DescribeDnsProductInstanceResponse response = (DescribeDnsProductInstanceResponse)acsClient.getAcsResponse((AcsRequest)request);
        Instance instance = new Instance();
        instance.setMaxCount(response.getBindDomainCount());
        instance.setEndTime(new Date(response.getEndTimestamp()));
        instance.setDomains(DnsClientUtils.getDomains(acsClient, DnsConfiguration.getInstanceId()));
        return instance;
    }

    public static Instance getInstance(IAcsClient acsClient) {
        return DnsClientUtils.getInstance(acsClient, DnsConfiguration.getInstanceId());
    }

    public static int bindDomains(IAcsClient acsClient, String instanceId, String[] domainNames) {
        BindInstanceDomainsRequest request = new BindInstanceDomainsRequest();
        request.setSysConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        request.setSysReadTimeout(Integer.valueOf(READ_TIMEOUT));
        request.setInstanceId(instanceId);
        request.setDomainNames(StringUtils.arrayToCommaDelimitedString((Object[])domainNames));
        return ((BindInstanceDomainsResponse)acsClient.getAcsResponse((AcsRequest)request)).getFailedCount();
    }

    public static int bindDomains(IAcsClient acsClient, String[] domainNames) {
        return DnsClientUtils.bindDomains(acsClient, DnsConfiguration.getInstanceId(), domainNames);
    }

    public static int unbindDomains(IAcsClient acsClient, String instanceId, String[] domainName) {
        UnbindInstanceDomainsRequest request = new UnbindInstanceDomainsRequest();
        request.setSysConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        request.setSysReadTimeout(Integer.valueOf(READ_TIMEOUT));
        request.setInstanceId(instanceId);
        request.setDomainNames(StringUtils.arrayToCommaDelimitedString((Object[])domainName));
        return ((UnbindInstanceDomainsResponse)acsClient.getAcsResponse((AcsRequest)request)).getFailedCount();
    }

    public static int unbindDomains(IAcsClient acsClient, String[] domainNames) {
        return DnsClientUtils.unbindDomains(acsClient, DnsConfiguration.getInstanceId(), domainNames);
    }

    public static List<AliRecord> getRecords(IAcsClient acsClient, String domainName) {
        DescribeDomainRecordsResponse response;
        DescribeDomainRecordsRequest request = new DescribeDomainRecordsRequest();
        request.setSysConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        request.setSysReadTimeout(Integer.valueOf(READ_TIMEOUT));
        request.setDomainName(domainName);
        request.setPageSize(Long.valueOf(100L));
        request.setPageNumber(Long.valueOf(1L));
        ArrayList<AliRecord> aliRecords = new ArrayList<AliRecord>();
        do {
            response = (DescribeDomainRecordsResponse)acsClient.getAcsResponse((AcsRequest)request);
            for (DescribeDomainRecordsResponse.Record record : response.getDomainRecords()) {
                AliRecord aliRecord = new AliRecord();
                aliRecord.setRecordId(record.getRecordId());
                aliRecord.setDomain(record.getDomainName());
                aliRecord.setType(record.getType());
                aliRecord.setRR(record.getRR());
                aliRecord.setLine(record.getLine());
                aliRecord.setValue(record.getValue());
                aliRecord.setPriority(record.getPriority());
                aliRecord.setTTL(record.getTTL());
                if (StringUtils.hasText((String)record.getStatus())) {
                    if ("Enable".equalsIgnoreCase(record.getStatus())) {
                        aliRecord.setStatus(true);
                    } else if ("Disable".equalsIgnoreCase(record.getStatus())) {
                        aliRecord.setStatus(false);
                    }
                }
                aliRecord.setLocked(record.getLocked());
                aliRecords.add(aliRecord);
            }
            request.setPageNumber(Long.valueOf(response.getPageNumber() + 1L));
        } while (response.getPageNumber() * response.getPageSize() < response.getTotalCount());
        return aliRecords;
    }

    public static AliRecord getRecord(IAcsClient acsClient, String recordId) {
        DescribeDomainRecordInfoRequest request = new DescribeDomainRecordInfoRequest();
        request.setSysConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        request.setSysReadTimeout(Integer.valueOf(READ_TIMEOUT));
        request.setRecordId(recordId);
        DescribeDomainRecordInfoResponse response = (DescribeDomainRecordInfoResponse)acsClient.getAcsResponse((AcsRequest)request);
        AliRecord aliRecord = new AliRecord();
        aliRecord.setRecordId(response.getRecordId());
        aliRecord.setDomain(response.getDomainName());
        aliRecord.setType(response.getType());
        aliRecord.setRR(response.getRR());
        aliRecord.setLine(response.getLine());
        aliRecord.setValue(response.getValue());
        aliRecord.setPriority(response.getPriority());
        aliRecord.setTTL(response.getTTL());
        if (StringUtils.hasText((String)response.getStatus())) {
            if ("Enable".equalsIgnoreCase(response.getStatus())) {
                aliRecord.setStatus(true);
            } else if ("Disable".equalsIgnoreCase(response.getStatus())) {
                aliRecord.setStatus(false);
            }
        }
        aliRecord.setLocked(response.getLocked());
        return aliRecord;
    }

    public static String addRecord(IAcsClient acsClient, String domain, String rR, String line, String value, Long priority) {
        AddDomainRecordRequest request = new AddDomainRecordRequest();
        request.setSysConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        request.setSysReadTimeout(Integer.valueOf(READ_TIMEOUT));
        request.setDomainName(domain);
        request.setType("MX");
        request.setRR(rR);
        if (StringUtils.hasText((String)line)) {
            request.setLine(line);
        } else {
            request.setLine("default");
        }
        request.setValue(value);
        request.setPriority(priority);
        request.setTTL(Long.valueOf(600L));
        return ((AddDomainRecordResponse)acsClient.getAcsResponse((AcsRequest)request)).getRecordId();
    }

    public static String addRecord(IAcsClient acsClient, String domain, String type, String rR, String line, String value) {
        AddDomainRecordRequest request = new AddDomainRecordRequest();
        request.setSysConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        request.setSysReadTimeout(Integer.valueOf(READ_TIMEOUT));
        request.setDomainName(domain);
        request.setType(type);
        request.setRR(rR);
        if (StringUtils.hasText((String)line)) {
            request.setLine(line);
        } else {
            request.setLine("default");
        }
        request.setValue(value);
        request.setTTL(Long.valueOf(600L));
        return ((AddDomainRecordResponse)acsClient.getAcsResponse((AcsRequest)request)).getRecordId();
    }

    public static String addRecord(IAcsClient acsClient, String domain, String rR, String line, String value) {
        return DnsClientUtils.addRecord(acsClient, domain, "A", rR, line, value);
    }

    public static void updateRecord(IAcsClient acsClient, String recordId, String rR, String line, String value, Long priority) {
        UpdateDomainRecordRequest request = new UpdateDomainRecordRequest();
        request.setSysConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        request.setSysReadTimeout(Integer.valueOf(READ_TIMEOUT));
        request.setRecordId(recordId);
        request.setType("MX");
        request.setRR(rR);
        if (StringUtils.hasText((String)line)) {
            request.setLine(line);
        } else {
            request.setLine("default");
        }
        request.setValue(value);
        request.setPriority(priority);
        request.setTTL(Long.valueOf(600L));
        acsClient.getAcsResponse((AcsRequest)request);
    }

    public static void updateRecord(IAcsClient acsClient, String recordId, String type, String rR, String line, String value) {
        UpdateDomainRecordRequest request = new UpdateDomainRecordRequest();
        request.setSysConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        request.setSysReadTimeout(Integer.valueOf(READ_TIMEOUT));
        request.setRecordId(recordId);
        request.setType(type);
        request.setRR(rR);
        if (StringUtils.hasText((String)line)) {
            request.setLine(line);
        } else {
            request.setLine("default");
        }
        request.setValue(value);
        request.setTTL(Long.valueOf(600L));
        acsClient.getAcsResponse((AcsRequest)request);
    }

    public static void updateRecord(IAcsClient acsClient, String recordId, String rR, String line, String value) {
        DnsClientUtils.updateRecord(acsClient, recordId, "A", rR, line, value);
    }

    public static void deleteRecord(IAcsClient acsClient, String recordId) {
        DeleteDomainRecordRequest request = new DeleteDomainRecordRequest();
        request.setSysConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        request.setSysReadTimeout(Integer.valueOf(READ_TIMEOUT));
        request.setRecordId(recordId);
        acsClient.getAcsResponse((AcsRequest)request);
    }

    public static String setStatus(IAcsClient acsClient, String recordId, boolean status) {
        SetDomainRecordStatusRequest request = new SetDomainRecordStatusRequest();
        request.setSysConnectTimeout(Integer.valueOf(CONNECT_TIMEOUT));
        request.setSysReadTimeout(Integer.valueOf(READ_TIMEOUT));
        request.setRecordId(recordId);
        request.setStatus(status ? "Enable" : "Disable");
        return ((SetDomainRecordStatusResponse)acsClient.getAcsResponse((AcsRequest)request)).getStatus();
    }
}

