/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationUtils.class);
    private static final ObjectMapper YAML_READER = new ObjectMapper((JsonFactory)new YAMLFactory());

    @Nullable
    public static String getEnv(String key, @Nullable String defaultValue) {
        return (String)ObjectUtils.defaultIfNull((Object)System.getenv(key), (Object)defaultValue);
    }

    @Nullable
    public static <T> T getJsonEnv(String key, TypeReference<T> cls) {
        String env = ConfigurationUtils.getEnv(key, null);
        try {
            return (T)(env == null ? null : YAML_READER.readValue(env, cls));
        }
        catch (IOException e) {
            LOGGER.error("Can not parse json environment variable with key: " + key, (Throwable)e);
            return null;
        }
    }

    public static <T> T load(Class<T> _class, InputStream inputStream) throws IOException {
        return (T)YAML_READER.readValue(inputStream, _class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T safeLoad(Loadable<T> loadable, Supplier<T> createDefault, String filePath) {
        if (!StringUtils.isNotBlank((CharSequence)filePath)) {
            LOGGER.warn("Path to file is blank");
            return createDefault.get();
        }
        Path path = Paths.get(filePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.warn("Path {} to file isn't exist", (Object)filePath);
            return createDefault.get();
        }
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            T t = loadable.load(inputStream);
            return t;
        }
        catch (IOException e) {
            LOGGER.warn("Loading from file {} failure", (Object)filePath, (Object)e);
            return createDefault.get();
        }
    }

    public static <T> T safeLoad(Loadable<T> loadable, Supplier<T> createDefault, InputStream inputStream) {
        try {
            return loadable.load(inputStream);
        }
        catch (IOException e) {
            LOGGER.warn("Loading from input stream failure", (Throwable)e);
            return createDefault.get();
        }
    }

    @FunctionalInterface
    public static interface Loadable<T> {
        public T load(InputStream var1) throws IOException;
    }
}

