/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.event;

import com.exactpro.th2.common.event.EventUtils;
import com.exactpro.th2.common.event.IBodyData;
import com.exactpro.th2.common.grpc.Event;
import com.exactpro.th2.common.grpc.EventBatch;
import com.exactpro.th2.common.grpc.EventBatchOrBuilder;
import com.exactpro.th2.common.grpc.EventID;
import com.exactpro.th2.common.grpc.EventStatus;
import com.exactpro.th2.common.grpc.MessageID;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Event {
    private static final Logger LOGGER = LoggerFactory.getLogger(Event.class);
    public static final String UNKNOWN_EVENT_NAME = "Unknown event name";
    public static final String UNKNOWN_EVENT_TYPE = "Unknown event type";
    public static final EventID DEFAULT_EVENT_ID = EventID.getDefaultInstance();
    protected static final ThreadLocal<ObjectMapper> OBJECT_MAPPER = ThreadLocal.withInitial(() -> new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL));
    protected final String id = EventUtils.generateUUID();
    protected final List<Event> subEvents = new ArrayList<Event>();
    protected final List<MessageID> attachedMessageIDS = new ArrayList<MessageID>();
    protected final List<IBodyData> body = new ArrayList<IBodyData>();
    protected final Instant startTimestamp;
    protected Instant endTimestamp;
    protected String type;
    protected String name;
    protected String description;
    protected Status status = Status.PASSED;

    protected Event(Instant startTimestamp, @Nullable Instant endTimestamp) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
    }

    protected Event(Instant startTimestamp) {
        this(startTimestamp, null);
    }

    protected Event() {
        this(Instant.now());
    }

    public static Event start() {
        return new Event();
    }

    public static Event from(Instant startTimestamp) {
        return new Event(startTimestamp);
    }

    @Contract(value="null -> null")
    @Nullable
    private static Timestamp toTimestamp(@Nullable Instant instant) {
        if (instant == null) {
            return null;
        }
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    public Event endTimestamp() {
        if (this.endTimestamp != null) {
            throw new IllegalStateException(this.formatStateException("End time", this.endTimestamp));
        }
        this.endTimestamp = Instant.now();
        return this;
    }

    public Event name(String eventName) {
        if (StringUtils.isNotBlank((CharSequence)eventName)) {
            if (this.name != null) {
                throw new IllegalStateException(this.formatStateException("Name", this.name));
            }
            this.name = eventName;
        }
        return this;
    }

    public Event description(String description) {
        if (StringUtils.isNotBlank((CharSequence)description)) {
            if (this.description != null) {
                throw new IllegalStateException(this.formatStateException("Description", this.description));
            }
            this.body.add(0, EventUtils.createMessageBean(description));
            this.description = description;
        }
        return this;
    }

    public Event type(String eventType) {
        if (StringUtils.isNotBlank((CharSequence)eventType)) {
            if (this.type != null) {
                throw new IllegalStateException(this.formatStateException("Type", this.type));
            }
            this.type = eventType;
        }
        return this;
    }

    public Event status(Status eventStatus) {
        if (eventStatus != null) {
            this.status = eventStatus;
        }
        return this;
    }

    public Event addSubEventWithSamePeriod() {
        return this.addSubEvent(new Event(this.startTimestamp, this.endTimestamp));
    }

    public Event addSubEvent(Event subEvent) {
        this.subEvents.add(Objects.requireNonNull(subEvent, "Sub event can't be null"));
        return subEvent;
    }

    public Event bodyData(IBodyData bodyData) {
        this.body.add(Objects.requireNonNull(bodyData, "Body data can't be null"));
        return this;
    }

    public Event bodyData(Collection<? extends IBodyData> bodyDataCollection) {
        this.body.addAll(Objects.requireNonNull(bodyDataCollection, "Body data collection cannot be null"));
        return this;
    }

    public Event exception(@NotNull Throwable throwable, boolean includeCauses) {
        Throwable error = Objects.requireNonNull(throwable, "Throwable can't be null");
        do {
            this.bodyData(EventUtils.createMessageBean(error.toString()));
            error = error.getCause();
        } while (includeCauses && error != null);
        return this;
    }

    public Event messageID(MessageID attachedMessageID) {
        this.attachedMessageIDS.add(Objects.requireNonNull(attachedMessageID, "Attached message id can't be null"));
        return this;
    }

    @Deprecated
    public List<com.exactpro.th2.common.grpc.Event> toProtoEvents(@Nullable String parentID) throws JsonProcessingException {
        return this.toListProto(EventUtils.toEventID(parentID));
    }

    public List<com.exactpro.th2.common.grpc.Event> toListProto(@Nullable EventID parentID) throws JsonProcessingException {
        return this.collectSubEvents(new ArrayList<com.exactpro.th2.common.grpc.Event>(), parentID);
    }

    @Deprecated
    public com.exactpro.th2.common.grpc.Event toProtoEvent(@Nullable String parentID) throws JsonProcessingException {
        return this.toProto(EventUtils.toEventID(parentID));
    }

    public com.exactpro.th2.common.grpc.Event toProto(@Nullable EventID parentID) throws JsonProcessingException {
        if (this.endTimestamp == null) {
            this.endTimestamp();
        }
        StringBuilder nameBuilder = new StringBuilder((String)StringUtils.defaultIfBlank((CharSequence)this.name, (CharSequence)UNKNOWN_EVENT_NAME));
        if (StringUtils.isNotBlank((CharSequence)this.description)) {
            nameBuilder.append(" - ").append(this.description);
        }
        Event.Builder eventBuilder = com.exactpro.th2.common.grpc.Event.newBuilder().setId(EventUtils.toEventID(this.id)).setName(nameBuilder.toString()).setType((String)StringUtils.defaultIfBlank((CharSequence)this.type, (CharSequence)UNKNOWN_EVENT_TYPE)).setStartTimestamp(Event.toTimestamp(this.startTimestamp)).setEndTimestamp(Event.toTimestamp(this.endTimestamp)).setStatus(this.getAggregatedStatus().eventStatus).setBody(ByteString.copyFrom((byte[])this.buildBody()));
        if (parentID != null) {
            eventBuilder.setParentId(parentID);
        }
        for (MessageID messageID : this.attachedMessageIDS) {
            eventBuilder.addAttachedMessageIds(messageID);
        }
        return eventBuilder.build();
    }

    public EventBatch toBatchProto(@Nullable EventID parentID) throws JsonProcessingException {
        List<com.exactpro.th2.common.grpc.Event> events = this.toListProto(parentID);
        EventBatch.Builder builder = EventBatch.newBuilder().addAllEvents(events);
        if (parentID != null && events.size() != 1) {
            builder.setParentEventId(parentID);
        }
        return builder.build();
    }

    public List<EventBatch> toBatchesProtoWithLimit(int maxEventBatchContentSize, @Nullable EventID parentID) throws JsonProcessingException {
        if (maxEventBatchContentSize <= 0) {
            throw new IllegalArgumentException("'maxEventBatchContentSize' should be greater than zero, actual: " + maxEventBatchContentSize);
        }
        List<com.exactpro.th2.common.grpc.Event> events = this.toListProto(parentID);
        ArrayList<EventBatch> result = new ArrayList<EventBatch>();
        Map<EventID, List<com.exactpro.th2.common.grpc.Event>> eventGroups = events.stream().collect(Collectors.groupingBy(com.exactpro.th2.common.grpc.Event::getParentId));
        this.batch(maxEventBatchContentSize, result, eventGroups, parentID);
        return result;
    }

    public List<EventBatch> toListBatchProto(@Nullable EventID parentID) throws JsonProcessingException {
        return this.toBatchesProtoWithLimit(Integer.MAX_VALUE, parentID);
    }

    public String getId() {
        return this.id;
    }

    public Instant getStartTimestamp() {
        return this.startTimestamp;
    }

    public Instant getEndTimestamp() {
        return this.endTimestamp;
    }

    @Deprecated
    protected List<com.exactpro.th2.common.grpc.Event> collectSubEvents(List<com.exactpro.th2.common.grpc.Event> protoEvents, @Nullable String parentID) throws JsonProcessingException {
        return this.collectSubEvents(protoEvents, EventUtils.toEventID(parentID));
    }

    protected List<com.exactpro.th2.common.grpc.Event> collectSubEvents(List<com.exactpro.th2.common.grpc.Event> protoEvents, @Nullable EventID parentID) throws JsonProcessingException {
        protoEvents.add(this.toProto(parentID));
        for (Event subEvent : this.subEvents) {
            subEvent.collectSubEvents(protoEvents, EventUtils.toEventID(this.id));
        }
        return protoEvents;
    }

    protected byte[] buildBody() throws JsonProcessingException {
        return OBJECT_MAPPER.get().writeValueAsBytes(this.body);
    }

    protected String formatStateException(String fieldName, Object value) {
        return fieldName + " in event '" + this.id + "' already sed with value '" + value + "'";
    }

    @Deprecated(forRemoval=true)
    protected Status getAggrigatedStatus() {
        return this.getAggregatedStatus();
    }

    @NotNull
    protected Status getAggregatedStatus() {
        if (this.status == Status.PASSED) {
            return this.subEvents.stream().anyMatch(subEvent -> subEvent.getAggregatedStatus() == Status.FAILED) ? Status.FAILED : Status.PASSED;
        }
        return Status.FAILED;
    }

    private void batch(int maxEventBatchContentSize, List<EventBatch> result, Map<EventID, List<com.exactpro.th2.common.grpc.Event>> eventGroups, @Nullable EventID eventID) throws JsonProcessingException {
        eventID = Objects.requireNonNullElse(eventID, DEFAULT_EVENT_ID);
        EventBatch.Builder builder = Event.setParentId(EventBatch.newBuilder(), eventID);
        List<com.exactpro.th2.common.grpc.Event> events = Objects.requireNonNull(eventGroups.get(eventID), (String)(eventID == DEFAULT_EVENT_ID ? "Neither of events is root event" : "Neither of events refers to " + TextFormat.shortDebugString((MessageOrBuilder)eventID)));
        for (com.exactpro.th2.common.grpc.Event protoEvent : events) {
            com.exactpro.th2.common.grpc.Event checkedProtoEvent = this.checkAndRebuild(maxEventBatchContentSize, protoEvent);
            LOGGER.trace("Process {} {}", (Object)checkedProtoEvent.getName(), (Object)checkedProtoEvent.getType());
            if (eventGroups.containsKey(checkedProtoEvent.getId())) {
                result.add(this.checkAndBuild(maxEventBatchContentSize, EventBatch.newBuilder().addEvents(checkedProtoEvent)));
                this.batch(maxEventBatchContentSize, result, eventGroups, checkedProtoEvent.getId());
                continue;
            }
            if (builder.getEventsCount() > 0 && Event.getContentSize((EventBatchOrBuilder)builder) + Event.getContentSize(checkedProtoEvent) > maxEventBatchContentSize) {
                result.add(this.checkAndBuild(maxEventBatchContentSize, builder));
                builder = Event.setParentId(EventBatch.newBuilder(), eventID);
            }
            builder.addEvents(checkedProtoEvent);
        }
        if (builder.getEventsCount() > 0) {
            result.add(this.checkAndBuild(maxEventBatchContentSize, builder));
        }
    }

    private EventBatch checkAndBuild(int maxEventBatchContentSize, EventBatch.Builder builder) {
        int contentSize = Event.getContentSize((EventBatchOrBuilder)builder);
        if (contentSize > maxEventBatchContentSize) {
            throw new IllegalStateException("The smallest batch size exceeds the max event batch content size, max " + maxEventBatchContentSize + ", actual " + contentSize);
        }
        return builder.build();
    }

    private com.exactpro.th2.common.grpc.Event checkAndRebuild(int maxEventBatchContentSize, com.exactpro.th2.common.grpc.Event event) throws JsonProcessingException {
        int contentSize = Event.getContentSize(event);
        if (contentSize > maxEventBatchContentSize) {
            return com.exactpro.th2.common.grpc.Event.newBuilder((com.exactpro.th2.common.grpc.Event)event).setStatus(EventStatus.FAILED).setBody(ByteString.copyFrom((byte[])OBJECT_MAPPER.get().writeValueAsBytes(Collections.singletonList(EventUtils.createMessageBean("Event " + TextFormat.shortDebugString((MessageOrBuilder)event.getId()) + " exceeds max size, max " + maxEventBatchContentSize + ", actual " + contentSize))))).build();
        }
        return event;
    }

    private static EventBatch.Builder setParentId(EventBatch.Builder builder, @NotNull EventID parentId) {
        if (parentId != DEFAULT_EVENT_ID) {
            builder.setParentEventId(parentId);
        }
        return builder;
    }

    private static int getContentSize(com.exactpro.th2.common.grpc.Event event) {
        return event.getBody().size();
    }

    private static int getContentSize(EventBatchOrBuilder eventBatch) {
        return eventBatch.getEventsList().stream().map(Event::getContentSize).mapToInt(Integer::intValue).sum();
    }

    public static enum Status {
        PASSED(EventStatus.SUCCESS),
        FAILED(EventStatus.FAILED);

        private final EventStatus eventStatus;

        private Status(EventStatus eventStatus) {
            this.eventStatus = eventStatus;
        }
    }
}

