/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.metrics;

import com.exactpro.th2.common.metrics.Metric;
import com.exactpro.th2.common.metrics.MetricMonitor;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0007H$R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/exactpro/th2/common/metrics/AbstractMetric;", "Lcom/exactpro/th2/common/metrics/Metric;", "()V", "disabledMonitors", "", "Lcom/exactpro/th2/common/metrics/MetricMonitor;", "isEnabled", "", "()Z", "createMonitor", "name", "", "disable", "", "monitor", "enable", "onValueChange", "value", "common"})
public abstract class AbstractMetric
implements Metric {
    private final Set<MetricMonitor> disabledMonitors;

    @Override
    public boolean isEnabled() {
        return this.disabledMonitors.isEmpty();
    }

    @Override
    @NotNull
    public MetricMonitor createMonitor(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new MetricMonitor(this, name);
    }

    @Override
    public void enable(@NotNull MetricMonitor monitor) {
        Intrinsics.checkParameterIsNotNull((Object)monitor, (String)"monitor");
        if (this.disabledMonitors.remove(monitor)) {
            this.onValueChange(this.disabledMonitors.isEmpty());
        }
    }

    @Override
    public void disable(@NotNull MetricMonitor monitor) {
        Intrinsics.checkParameterIsNotNull((Object)monitor, (String)"monitor");
        if (this.disabledMonitors.add(monitor)) {
            this.onValueChange(false);
        }
    }

    @Override
    public boolean isEnabled(@NotNull MetricMonitor monitor) {
        Intrinsics.checkParameterIsNotNull((Object)monitor, (String)"monitor");
        return !this.disabledMonitors.contains(monitor);
    }

    protected abstract void onValueChange(boolean var1);

    public AbstractMetric() {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkExpressionValueIsNotNull(keySetView, (String)"ConcurrentHashMap.newKeySet()");
        this.disabledMonitors = keySetView;
    }
}

