/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.metrics;

import com.exactpro.th2.common.metrics.AbstractMetric;
import com.exactpro.th2.common.metrics.AggregatingMetric;
import com.exactpro.th2.common.metrics.FileMetric;
import com.exactpro.th2.common.metrics.MetricMonitor;
import com.exactpro.th2.common.metrics.PrometheusMetric;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\u001a\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0002H\u0007\u001a\u000e\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#\u001a\u000e\u0010!\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0007\u001a\u000e\u0010%\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#\u001a\u000e\u0010%\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0007\u001a\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u001a\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u001a\b\u0010(\u001a\u00020\u001fH\u0007\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0010\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"*\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\"*\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u001b\u0010\u0015\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019\u00a8\u0006)"}, d2={"ALL_READINESS", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "kotlin.jvm.PlatformType", "DEFAULT_BUCKETS", "", "DEFAULT_DIRECTION_LABEL_NAME", "", "DEFAULT_SESSION_ALIAS_LABEL_NAME", "GRPC_READINESS", "LIVENESS_ARBITER", "Lcom/exactpro/th2/common/metrics/AggregatingMetric;", "LIVENESS_MONITOR", "Lcom/exactpro/th2/common/metrics/MetricMonitor;", "RABBITMQ_READINESS", "READINESS_ARBITER", "READINESS_MONITOR", "value", "", "liveness", "liveness$annotations", "()V", "getLiveness", "()Z", "setLiveness", "(Z)V", "readiness", "readiness$annotations", "getReadiness", "setReadiness", "addReadinessParameter", "", "parameter", "registerLiveness", "obj", "", "name", "registerReadiness", "setGRPCReadiness", "setRabbitMQReadiness", "updateCommonReadiness", "common"})
@JvmName(name="CommonMetrics")
public final class CommonMetrics {
    @JvmField
    @NotNull
    public static final double[] DEFAULT_BUCKETS = new double[]{2.5E-4, 5.0E-4, 0.001, 0.005, 0.01, 0.015, 0.025, 0.05, 0.1, 0.25, 0.5, 1.0};
    @NotNull
    public static final String DEFAULT_SESSION_ALIAS_LABEL_NAME = "session_alias";
    @NotNull
    public static final String DEFAULT_DIRECTION_LABEL_NAME = "direction";
    private static final AggregatingMetric LIVENESS_ARBITER = new AggregatingMetric(CollectionsKt.listOf((Object[])new AbstractMetric[]{new PrometheusMetric("th2_liveness", "Service liveness"), new FileMetric("healthy")}));
    private static final AggregatingMetric READINESS_ARBITER = new AggregatingMetric(CollectionsKt.listOf((Object[])new AbstractMetric[]{new PrometheusMetric("th2_readiness", "Service readiness"), new FileMetric("ready")}));
    private static final AtomicBoolean RABBITMQ_READINESS = new AtomicBoolean(true);
    private static final AtomicBoolean GRPC_READINESS = new AtomicBoolean(true);
    private static final CopyOnWriteArrayList<AtomicBoolean> ALL_READINESS = new CopyOnWriteArrayList(CollectionsKt.listOf((Object[])new AtomicBoolean[]{RABBITMQ_READINESS, GRPC_READINESS}));
    @JvmField
    @NotNull
    public static final MetricMonitor LIVENESS_MONITOR = CommonMetrics.registerLiveness("user_liveness");
    @JvmField
    @NotNull
    public static final MetricMonitor READINESS_MONITOR = CommonMetrics.registerReadiness("user_readiness");

    @NotNull
    public static final MetricMonitor registerLiveness(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return LIVENESS_ARBITER.createMonitor(name);
    }

    @NotNull
    public static final MetricMonitor registerReadiness(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return READINESS_ARBITER.createMonitor(name);
    }

    @NotNull
    public static final MetricMonitor registerLiveness(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return LIVENESS_ARBITER.createMonitor(Reflection.getOrCreateKotlinClass(obj.getClass()).getSimpleName() + "_liveness_" + obj.hashCode());
    }

    @NotNull
    public static final MetricMonitor registerReadiness(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return READINESS_ARBITER.createMonitor(Reflection.getOrCreateKotlinClass(obj.getClass()).getSimpleName() + "_readiness_" + obj.hashCode());
    }

    @Deprecated(message="Please create yours monitor with registerLiveness and use one")
    public static /* synthetic */ void liveness$annotations() {
    }

    public static final boolean getLiveness() {
        return LIVENESS_MONITOR.isEnabled();
    }

    public static final void setLiveness(boolean value) {
        if (value) {
            LIVENESS_MONITOR.enable();
        } else {
            LIVENESS_MONITOR.disable();
        }
    }

    @Deprecated(message="Please create yours monitor with registerReadiness and use one")
    public static /* synthetic */ void readiness$annotations() {
    }

    public static final boolean getReadiness() {
        return READINESS_MONITOR.isEnabled();
    }

    public static final void setReadiness(boolean value) {
        if (value) {
            READINESS_MONITOR.enable();
        } else {
            READINESS_MONITOR.disable();
        }
    }

    @Deprecated(message="Please create yours monitors with registerLiveness and registerReadiness ans use ones")
    public static final void updateCommonReadiness() {
        boolean isReadness = true;
        for (AtomicBoolean readinessParameter : ALL_READINESS) {
            if (readinessParameter.get()) continue;
            isReadness = false;
            break;
        }
        CommonMetrics.setReadiness(isReadness);
    }

    @Deprecated(message="Please create yours monitor with registerReadiness and use one")
    public static final void addReadinessParameter(@NotNull AtomicBoolean parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        ALL_READINESS.add(parameter);
    }

    @Deprecated(message="Please create yours monitor with registerReadiness and use one")
    public static final void setRabbitMQReadiness(boolean value) {
        RABBITMQ_READINESS.set(value);
        CommonMetrics.updateCommonReadiness();
    }

    @Deprecated(message="Please create yours monitor with registerReadiness and use one")
    public static final void setGRPCReadiness(boolean value) {
        GRPC_READINESS.set(value);
        CommonMetrics.updateCommonReadiness();
    }
}

