/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.metrics;

import com.exactpro.th2.common.metrics.AbstractMetric;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/exactpro/th2/common/metrics/FileMetric;", "Lcom/exactpro/th2/common/metrics/AbstractMetric;", "fileName", "", "(Ljava/lang/String;)V", "metricFile", "Ljava/nio/file/Path;", "onValueChange", "", "value", "", "Companion", "common"})
public final class FileMetric
extends AbstractMetric {
    private final Path metricFile;
    private static final Path DEFAULT_PATH_TO_METRIC_FOLDER;
    public static final Companion Companion;

    @Override
    protected void onValueChange(boolean value) {
        if (value) {
            try {
                Files.createFile(this.metricFile, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw (Throwable)new IllegalStateException("Can not create file = " + this.metricFile, e);
            }
        } else {
            Files.deleteIfExists(this.metricFile);
        }
    }

    public FileMetric(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Path path = DEFAULT_PATH_TO_METRIC_FOLDER.resolve(fileName);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"DEFAULT_PATH_TO_METRIC_FOLDER.resolve(fileName)");
        this.metricFile = path;
        Files.deleteIfExists(this.metricFile);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_PATH_TO_METRIC_FOLDER = Path.of(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/exactpro/th2/common/metrics/FileMetric$Companion;", "", "()V", "DEFAULT_PATH_TO_METRIC_FOLDER", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

