/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.metrics;

import com.exactpro.th2.common.metrics.CommonMetrics;
import com.exactpro.th2.common.metrics.MetricMonitor;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B!\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/exactpro/th2/common/metrics/HealthMetrics;", "", "parent", "attempts", "", "(Ljava/lang/Object;I)V", "livenessMonitor", "Lcom/exactpro/th2/common/metrics/MetricMonitor;", "readinessMonitor", "maxAttempts", "(Lcom/exactpro/th2/common/metrics/MetricMonitor;Lcom/exactpro/th2/common/metrics/MetricMonitor;I)V", "Ljava/util/concurrent/atomic/AtomicInteger;", "getLivenessMonitor", "()Lcom/exactpro/th2/common/metrics/MetricMonitor;", "getReadinessMonitor", "disable", "", "enable", "notReady", "common"})
public final class HealthMetrics {
    private final AtomicInteger attempts;
    @NotNull
    private final MetricMonitor livenessMonitor;
    @NotNull
    private final MetricMonitor readinessMonitor;
    private final int maxAttempts;

    public final void notReady() {
        if (this.maxAttempts > this.attempts.incrementAndGet()) {
            this.readinessMonitor.disable();
        } else {
            this.disable();
        }
    }

    public final void enable() {
        this.livenessMonitor.enable();
        this.readinessMonitor.enable();
    }

    public final void disable() {
        this.livenessMonitor.disable();
        this.readinessMonitor.disable();
    }

    @NotNull
    public final MetricMonitor getLivenessMonitor() {
        return this.livenessMonitor;
    }

    @NotNull
    public final MetricMonitor getReadinessMonitor() {
        return this.readinessMonitor;
    }

    @JvmOverloads
    public HealthMetrics(@NotNull MetricMonitor livenessMonitor, @NotNull MetricMonitor readinessMonitor, int maxAttempts) {
        Intrinsics.checkParameterIsNotNull((Object)livenessMonitor, (String)"livenessMonitor");
        Intrinsics.checkParameterIsNotNull((Object)readinessMonitor, (String)"readinessMonitor");
        this.livenessMonitor = livenessMonitor;
        this.readinessMonitor = readinessMonitor;
        this.maxAttempts = maxAttempts;
        this.attempts = new AtomicInteger(0);
    }

    public /* synthetic */ HealthMetrics(MetricMonitor metricMonitor, MetricMonitor metricMonitor2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 10;
        }
        this(metricMonitor, metricMonitor2, n);
    }

    @JvmOverloads
    public HealthMetrics(@NotNull MetricMonitor livenessMonitor, @NotNull MetricMonitor readinessMonitor) {
        this(livenessMonitor, readinessMonitor, 0, 4, null);
    }

    @JvmOverloads
    public HealthMetrics(@NotNull Object parent, int attempts) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        this(CommonMetrics.registerLiveness(parent), CommonMetrics.registerReadiness(parent), attempts);
    }

    public /* synthetic */ HealthMetrics(Object object, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 10;
        }
        this(object, n);
    }

    @JvmOverloads
    public HealthMetrics(@NotNull Object parent) {
        this(parent, 0, 2, null);
    }
}

