/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.configuration;

import com.exactpro.th2.common.schema.configuration.ConfigurationManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogger;
import mu.KotlinLogging;
import org.apache.commons.text.StringSubstitutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J7\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\u00042\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J?\u0010\u0013\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\u00042\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0015R\u001e\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/exactpro/th2/common/schema/configuration/ConfigurationManager;", "", "configurationPath", "", "Ljava/lang/Class;", "Ljava/nio/file/Path;", "(Ljava/util/Map;)V", "configurations", "", "getConfigurationOrLoad", "T", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "stringSubstitutor", "Lorg/apache/commons/text/StringSubstitutor;", "configClass", "optional", "", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/apache/commons/text/StringSubstitutor;Ljava/lang/Class;Z)Ljava/lang/Object;", "loadConfiguration", "configPath", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/apache/commons/text/StringSubstitutor;Ljava/lang/Class;Ljava/nio/file/Path;Z)Ljava/lang/Object;", "Companion", "common"})
public final class ConfigurationManager {
    private final Map<Class<?>, Object> configurations;
    private final Map<Class<?>, Path> configurationPath;
    @NotNull
    private static final KLogger LOGGER;
    public static final Companion Companion;

    public final <T> T loadConfiguration(@NotNull ObjectMapper objectMapper, @NotNull StringSubstitutor stringSubstitutor, @NotNull Class<T> configClass, @NotNull Path configPath, boolean optional) {
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkParameterIsNotNull((Object)stringSubstitutor, (String)"stringSubstitutor");
        Intrinsics.checkParameterIsNotNull(configClass, (String)"configClass");
        Intrinsics.checkParameterIsNotNull((Object)configPath, (String)"configPath");
        try {
            if (optional && (!Files.exists(configPath, new LinkOption[0]) || Files.size(configPath) <= 0L)) {
                LOGGER.warn((Function0)new Function0<String>(configClass){
                    final /* synthetic */ Class $configClass;

                    @NotNull
                    public final String invoke() {
                        return "Can not read configuration for " + this.$configClass.getName() + ". Use default configuration";
                    }
                    {
                        this.$configClass = clazz;
                        super(0);
                    }
                });
                return configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            byte[] byArray = Files.readAllBytes(configPath);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.readAllBytes(configPath)");
            byte[] byArray2 = byArray;
            boolean bl = false;
            String sourceContent = new String(byArray2, Charsets.UTF_8);
            LOGGER.info("Configuration path {} source content {}", (Object)configPath, (Object)sourceContent);
            String string = stringSubstitutor.replace(sourceContent);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stringSubstitutor.replace(sourceContent)");
            String content = string;
            return (T)objectMapper.readerFor(configClass).readValue(content);
        }
        catch (IOException e) {
            throw (Throwable)new IllegalStateException("Cannot read " + configClass.getName() + " configuration from path '" + configPath + '\'', e);
        }
    }

    public final <T> T getConfigurationOrLoad(@NotNull ObjectMapper objectMapper, @NotNull StringSubstitutor stringSubstitutor, @NotNull Class<T> configClass, boolean optional) {
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkParameterIsNotNull((Object)stringSubstitutor, (String)"stringSubstitutor");
        Intrinsics.checkParameterIsNotNull(configClass, (String)"configClass");
        return (T)this.configurations.computeIfAbsent(configClass, new Function<Class<?>, Object>(this, configClass, objectMapper, stringSubstitutor, optional){
            final /* synthetic */ ConfigurationManager this$0;
            final /* synthetic */ Class $configClass;
            final /* synthetic */ ObjectMapper $objectMapper;
            final /* synthetic */ StringSubstitutor $stringSubstitutor;
            final /* synthetic */ boolean $optional;

            public final T apply(@NotNull Class<?> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                V v = ConfigurationManager.access$getConfigurationPath$p(this.this$0).get(this.$configClass);
                boolean bl = false;
                boolean bl2 = false;
                if (v == null) {
                    boolean bl3 = false;
                    String string = "Unknown class " + this.$configClass;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                bl = false;
                bl2 = false;
                Path it2 = (Path)v;
                boolean bl4 = false;
                return this.this$0.loadConfiguration(this.$objectMapper, this.$stringSubstitutor, this.$configClass, it2, this.$optional);
            }
            {
                this.this$0 = configurationManager;
                this.$configClass = clazz;
                this.$objectMapper = objectMapper;
                this.$stringSubstitutor = stringSubstitutor;
                this.$optional = bl;
            }
        });
    }

    public ConfigurationManager(@NotNull Map<Class<?>, ? extends Path> configurationPath) {
        Intrinsics.checkParameterIsNotNull(configurationPath, (String)"configurationPath");
        this.configurationPath = configurationPath;
        this.configurations = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        LOGGER = KotlinLogging.INSTANCE.logger((Function0)Companion.LOGGER.1.INSTANCE);
    }

    public static final /* synthetic */ Map access$getConfigurationPath$p(ConfigurationManager $this) {
        return $this.configurationPath;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/exactpro/th2/common/schema/configuration/ConfigurationManager$Companion;", "", "()V", "LOGGER", "Lmu/KLogger;", "getLOGGER", "()Lmu/KLogger;", "common"})
    public static final class Companion {
        @NotNull
        public final KLogger getLOGGER() {
            return LOGGER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

