/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.event;

import com.exactpro.th2.common.grpc.EventBatch;
import com.exactpro.th2.common.schema.event.EventBatchQueue;
import com.exactpro.th2.common.schema.message.FilterFunction;
import com.exactpro.th2.common.schema.message.MessageQueue;
import com.exactpro.th2.common.schema.message.QueueAttribute;
import com.exactpro.th2.common.schema.message.configuration.QueueConfiguration;
import com.exactpro.th2.common.schema.message.configuration.RouterFilter;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.AbstractRabbitMessageRouter;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.connection.ConnectionManager;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.jetbrains.annotations.NotNull;

public class EventBatchRouter
extends AbstractRabbitMessageRouter<EventBatch> {
    private static final Set<String> REQUIRED_SUBSCRIBE_ATTRIBUTES = SetUtils.unmodifiableSet((Object[])new String[]{QueueAttribute.EVENT.toString(), QueueAttribute.SUBSCRIBE.toString()});
    private static final Set<String> REQUIRED_SEND_ATTRIBUTES = SetUtils.unmodifiableSet((Object[])new String[]{QueueAttribute.EVENT.toString(), QueueAttribute.PUBLISH.toString()});

    @Override
    protected MessageQueue<EventBatch> createQueue(@NotNull ConnectionManager connectionManager, @NotNull QueueConfiguration queueConfiguration, @NotNull FilterFunction filterFunction) {
        EventBatchQueue eventBatchQueue = new EventBatchQueue();
        eventBatchQueue.init(connectionManager, queueConfiguration, filterFunction);
        return eventBatchQueue;
    }

    @Override
    protected Map<String, EventBatch> findQueueByFilter(Map<String, QueueConfiguration> queues, EventBatch msg) {
        return queues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> msg));
    }

    @Override
    protected boolean filterMessage(Message msg, List<? extends RouterFilter> filters) {
        return true;
    }

    @Override
    protected Set<String> requiredSubscribeAttributes() {
        return REQUIRED_SUBSCRIBE_ATTRIBUTES;
    }

    @Override
    protected Set<String> requiredSendAttributes() {
        return REQUIRED_SEND_ATTRIBUTES;
    }
}

