/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.event;

import com.exactpro.th2.common.grpc.EventBatch;
import com.exactpro.th2.common.message.MessageUtils;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.AbstractRabbitSender;
import com.google.protobuf.MessageOrBuilder;
import io.prometheus.client.Counter;

public class EventBatchSender
extends AbstractRabbitSender<EventBatch> {
    private static final Counter OUTGOING_EVENT_BATCH_QUANTITY = (Counter)Counter.build((String)"th2_mq_outgoing_event_batch_quantity", (String)"Quantity of outgoing event batches").register();
    private static final Counter OUTGOING_EVENT_QUANTITY = (Counter)Counter.build((String)"th2_mq_outgoing_event_quantity", (String)"Quantity of outgoing events").register();

    @Override
    protected Counter getDeliveryCounter() {
        return OUTGOING_EVENT_BATCH_QUANTITY;
    }

    @Override
    protected Counter getContentCounter() {
        return OUTGOING_EVENT_QUANTITY;
    }

    @Override
    protected int extractCountFrom(EventBatch batch) {
        return batch.getEventsCount();
    }

    @Override
    protected byte[] valueToBytes(EventBatch value) {
        return value.toByteArray();
    }

    @Override
    protected String toShortTraceString(EventBatch value) {
        return MessageUtils.toJson((MessageOrBuilder)value);
    }

    @Override
    protected String toShortDebugString(EventBatch value) {
        return "EventBatch: parent_event_id = " + value.getParentEventId().getId();
    }
}

