/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.event;

import com.exactpro.th2.common.grpc.EventBatch;
import com.exactpro.th2.common.message.MessageUtils;
import com.exactpro.th2.common.metrics.CommonMetrics;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.AbstractRabbitSubscriber;
import com.google.protobuf.MessageOrBuilder;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class EventBatchSubscriber
extends AbstractRabbitSubscriber<EventBatch> {
    private static final Counter INCOMING_EVENT_BATCH_QUANTITY = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("th2_mq_incoming_event_batch_quantity")).help("Quantity of incoming event batches")).register();
    private static final Counter INCOMING_EVENT_QUANTITY = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("th2_mq_incoming_event_quantity")).help("Quantity of incoming events")).register();
    private static final Histogram EVENT_PROCESSING_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build().buckets(CommonMetrics.DEFAULT_BUCKETS).name("th2_mq_event_processing_time")).help("Time of processing events")).register();
    private static final String[] NO_LABELS = new String[0];

    @Override
    protected Counter getDeliveryCounter() {
        return INCOMING_EVENT_BATCH_QUANTITY;
    }

    @Override
    protected Counter getContentCounter() {
        return INCOMING_EVENT_QUANTITY;
    }

    @Override
    protected Histogram getProcessingTimer() {
        return EVENT_PROCESSING_TIME;
    }

    @Override
    protected String[] extractLabels(EventBatch batch) {
        return NO_LABELS;
    }

    @Override
    protected int extractCountFrom(EventBatch batch) {
        return batch.getEventsCount();
    }

    @Override
    protected List<EventBatch> valueFromBytes(byte[] bytes) throws Exception {
        return List.of(EventBatch.parseFrom((byte[])bytes));
    }

    @Override
    protected String toShortTraceString(EventBatch value) {
        return MessageUtils.toJson((MessageOrBuilder)value);
    }

    @Override
    protected String toShortDebugString(EventBatch value) {
        return "EventBatch: parent_event_id = " + value.getParentEventId().getId();
    }

    @Override
    @Nullable
    protected EventBatch filter(EventBatch eventBatch) throws Exception {
        return eventBatch;
    }
}

