/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.factory;

import com.exactpro.cradle.CradleManager;
import com.exactpro.cradle.cassandra.CassandraCradleManager;
import com.exactpro.cradle.cassandra.connection.CassandraConnection;
import com.exactpro.cradle.cassandra.connection.CassandraConnectionSettings;
import com.exactpro.cradle.utils.CradleStorageException;
import com.exactpro.th2.common.event.Event;
import com.exactpro.th2.common.grpc.EventBatch;
import com.exactpro.th2.common.grpc.MessageBatch;
import com.exactpro.th2.common.grpc.MessageGroupBatch;
import com.exactpro.th2.common.grpc.RawMessageBatch;
import com.exactpro.th2.common.metrics.CommonMetrics;
import com.exactpro.th2.common.metrics.MetricMonitor;
import com.exactpro.th2.common.metrics.PrometheusConfiguration;
import com.exactpro.th2.common.schema.box.configuration.BoxConfiguration;
import com.exactpro.th2.common.schema.configuration.ConfigurationManager;
import com.exactpro.th2.common.schema.cradle.CradleConfidentialConfiguration;
import com.exactpro.th2.common.schema.cradle.CradleConfiguration;
import com.exactpro.th2.common.schema.cradle.CradleNonConfidentialConfiguration;
import com.exactpro.th2.common.schema.dictionary.DictionaryType;
import com.exactpro.th2.common.schema.event.EventBatchRouter;
import com.exactpro.th2.common.schema.exception.CommonFactoryException;
import com.exactpro.th2.common.schema.grpc.configuration.GrpcConfiguration;
import com.exactpro.th2.common.schema.grpc.configuration.GrpcRouterConfiguration;
import com.exactpro.th2.common.schema.grpc.router.GrpcRouter;
import com.exactpro.th2.common.schema.grpc.router.impl.DefaultGrpcRouter;
import com.exactpro.th2.common.schema.message.MessageRouter;
import com.exactpro.th2.common.schema.message.MessageRouterContext;
import com.exactpro.th2.common.schema.message.MessageRouterMonitor;
import com.exactpro.th2.common.schema.message.configuration.MessageRouterConfiguration;
import com.exactpro.th2.common.schema.message.impl.context.DefaultMessageRouterContext;
import com.exactpro.th2.common.schema.message.impl.monitor.BroadcastMessageRouterMonitor;
import com.exactpro.th2.common.schema.message.impl.monitor.EventMessageRouterMonitor;
import com.exactpro.th2.common.schema.message.impl.monitor.LogMessageRouterMonitor;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.configuration.ConnectionManagerConfiguration;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.configuration.RabbitMQConfiguration;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.connection.ConnectionManager;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.custom.MessageConverter;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.custom.RabbitCustomRouter;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.group.RabbitMessageGroupBatchRouter;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.parsed.RabbitParsedBatchRouter;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.raw.RabbitRawBatchRouter;
import com.exactpro.th2.common.schema.strategy.route.json.RoutingStrategyModule;
import com.exactpro.th2.common.schema.util.ArchiveUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommonFactory
implements AutoCloseable {
    protected static final String DEFAULT_CRADLE_INSTANCE_NAME = "infra";
    protected static final String EXACTPRO_IMPLEMENTATION_VENDOR = "Exactpro Systems LLC";
    @Deprecated
    protected static final String LOG4J_PROPERTIES_DEFAULT_PATH_OLD = "/home/etc";
    protected static final String LOG4J_PROPERTIES_DEFAULT_PATH = "/var/th2/config";
    protected static final String LOG4J_PROPERTIES_NAME = "log4j.properties";
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOGGER;
    private final StringSubstitutor stringSubstitutor;
    private final Class<? extends MessageRouter<MessageBatch>> messageRouterParsedBatchClass;
    private final Class<? extends MessageRouter<RawMessageBatch>> messageRouterRawBatchClass;
    private final Class<? extends MessageRouter<MessageGroupBatch>> messageRouterMessageGroupBatchClass;
    private final Class<? extends MessageRouter<EventBatch>> eventBatchRouterClass;
    private final Class<? extends GrpcRouter> grpcRouterClass;
    private final AtomicReference<ConnectionManager> rabbitMqConnectionManager = new AtomicReference();
    private final AtomicReference<MessageRouterContext> routerContext = new AtomicReference();
    private final AtomicReference<MessageRouter<MessageBatch>> messageRouterParsedBatch = new AtomicReference();
    private final AtomicReference<MessageRouter<RawMessageBatch>> messageRouterRawBatch = new AtomicReference();
    private final AtomicReference<MessageRouter<MessageGroupBatch>> messageRouterMessageGroupBatch = new AtomicReference();
    private final AtomicReference<MessageRouter<EventBatch>> eventBatchRouter = new AtomicReference();
    private final AtomicReference<String> rootEventId = new AtomicReference();
    private final AtomicReference<GrpcRouter> grpcRouter = new AtomicReference();
    private final AtomicReference<HTTPServer> prometheusExporter = new AtomicReference();
    private final AtomicReference<CradleManager> cradleManager = new AtomicReference();
    private final Map<Class<?>, MessageRouter<?>> customMessageRouters = new ConcurrentHashMap();
    private final MetricMonitor livenessMonitor = CommonMetrics.registerLiveness("common_factory_liveness");

    public AbstractCommonFactory() {
        this(RabbitParsedBatchRouter.class, RabbitRawBatchRouter.class, RabbitMessageGroupBatchRouter.class, EventBatchRouter.class, DefaultGrpcRouter.class);
    }

    public AbstractCommonFactory(@NotNull Class<? extends MessageRouter<MessageBatch>> messageRouterParsedBatchClass, @NotNull Class<? extends MessageRouter<RawMessageBatch>> messageRouterRawBatchClass, @NotNull Class<? extends MessageRouter<MessageGroupBatch>> messageRouterMessageGroupBatchClass, @NotNull Class<? extends MessageRouter<EventBatch>> eventBatchRouterClass, @NotNull Class<? extends GrpcRouter> grpcRouterClass) {
        this(messageRouterParsedBatchClass, messageRouterRawBatchClass, messageRouterMessageGroupBatchClass, eventBatchRouterClass, grpcRouterClass, Collections.emptyMap());
    }

    protected AbstractCommonFactory(@NotNull Class<? extends MessageRouter<MessageBatch>> messageRouterParsedBatchClass, @NotNull Class<? extends MessageRouter<RawMessageBatch>> messageRouterRawBatchClass, @NotNull Class<? extends MessageRouter<MessageGroupBatch>> messageRouterMessageGroupBatchClass, @NotNull Class<? extends MessageRouter<EventBatch>> eventBatchRouterClass, @NotNull Class<? extends GrpcRouter> grpcRouterClass, @NotNull Map<String, String> environmentVariables) {
        this.messageRouterParsedBatchClass = messageRouterParsedBatchClass;
        this.messageRouterRawBatchClass = messageRouterRawBatchClass;
        this.messageRouterMessageGroupBatchClass = messageRouterMessageGroupBatchClass;
        this.eventBatchRouterClass = eventBatchRouterClass;
        this.grpcRouterClass = grpcRouterClass;
        this.stringSubstitutor = new StringSubstitutor(key -> (String)StringUtils.defaultIfBlank((CharSequence)((String)environmentVariables.get(key)), (CharSequence)System.getenv(key)));
    }

    public void start() {
        DefaultExports.initialize();
        PrometheusConfiguration prometheusConfiguration = this.loadPrometheusConfiguration();
        this.livenessMonitor.enable();
        this.prometheusExporter.updateAndGet(server -> {
            if (server == null && prometheusConfiguration.getEnabled()) {
                try {
                    return new HTTPServer(prometheusConfiguration.getHost(), prometheusConfiguration.getPort());
                }
                catch (IOException e) {
                    throw new CommonFactoryException("Failed to create Prometheus exporter", e);
                }
            }
            return server;
        });
    }

    public MessageRouter<MessageBatch> getMessageRouterParsedBatch() {
        return this.messageRouterParsedBatch.updateAndGet(router -> {
            if (router == null) {
                try {
                    router = this.messageRouterParsedBatchClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    router.init(this.getMessageRouterContext());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new CommonFactoryException("Can not create parsed message router", e);
                }
            }
            return router;
        });
    }

    public MessageRouter<RawMessageBatch> getMessageRouterRawBatch() {
        return this.messageRouterRawBatch.updateAndGet(router -> {
            if (router == null) {
                try {
                    router = this.messageRouterRawBatchClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    router.init(this.getMessageRouterContext());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new CommonFactoryException("Can not create raw message router", e);
                }
            }
            return router;
        });
    }

    public MessageRouter<MessageGroupBatch> getMessageRouterMessageGroupBatch() {
        return this.messageRouterMessageGroupBatch.updateAndGet(router -> {
            if (router == null) {
                try {
                    router = this.messageRouterMessageGroupBatchClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    router.init(this.getMessageRouterContext());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new CommonFactoryException("Can not create group message router", e);
                }
            }
            return router;
        });
    }

    public MessageRouter<EventBatch> getEventBatchRouter() {
        return this.eventBatchRouter.updateAndGet(router -> {
            if (router == null) {
                try {
                    router = this.eventBatchRouterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    router.init(new DefaultMessageRouterContext(this.getRabbitMqConnectionManager(), MessageRouterMonitor.DEFAULT_MONITOR, this.getMessageRouterConfiguration()));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new CommonFactoryException("Can not create event batch router", e);
                }
            }
            return router;
        });
    }

    public GrpcRouter getGrpcRouter() {
        return this.grpcRouter.updateAndGet(router -> {
            if (router == null) {
                try {
                    router = this.grpcRouterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    router.init(this.getGrpcConfiguration(), this.getGrpcRouterConfiguration());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new CommonFactoryException("Can not create GRPC router", e);
                }
            }
            return router;
        });
    }

    public <T> void registerCustomMessageRouter(Class<T> messageClass, MessageConverter<T> messageConverter) {
        this.registerCustomMessageRouter(messageClass, messageConverter, Collections.emptySet(), Collections.emptySet(), new String[0]);
    }

    public <T> void registerCustomMessageRouter(Class<T> messageClass, MessageConverter<T> messageConverter, Set<String> defaultSendAttributes, Set<String> defaultSubscribeAttributes, String ... labels) {
        this.customMessageRouters.compute(messageClass, (msgClass, curValue) -> {
            if (curValue != null) {
                throw new IllegalStateException("Message router for type " + msgClass.getCanonicalName() + " is already registered");
            }
            Objects.requireNonNull(labels, "Labels can't be null for custom message router");
            RabbitCustomRouter router = new RabbitCustomRouter(msgClass.getSimpleName(), labels, messageConverter, defaultSendAttributes, defaultSubscribeAttributes);
            router.init(this.getRabbitMqConnectionManager(), this.getMessageRouterConfiguration());
            return router;
        });
    }

    @NotNull
    public <T> MessageRouter<T> getCustomMessageRouter(Class<T> messageClass) {
        MessageRouter<?> router = this.customMessageRouters.get(messageClass);
        if (router == null) {
            throw new IllegalArgumentException("Router for class " + messageClass.getCanonicalName() + "is not registered. Call 'registerCustomMessageRouter' first");
        }
        return router;
    }

    public <T> T getConfiguration(Path configPath, Class<T> configClass, ObjectMapper customObjectMapper) {
        return this.getConfigurationManager().loadConfiguration(customObjectMapper, this.stringSubstitutor, configClass, configPath, false);
    }

    protected <T> T getConfigurationOrLoad(Class<T> configClass, boolean optional) {
        return this.getConfigurationManager().getConfigurationOrLoad(MAPPER, this.stringSubstitutor, configClass, optional);
    }

    public RabbitMQConfiguration getRabbitMqConfiguration() {
        return this.getConfigurationOrLoad(RabbitMQConfiguration.class, false);
    }

    public ConnectionManagerConfiguration getConnectionManagerConfiguration() {
        return this.getConfigurationOrLoad(ConnectionManagerConfiguration.class, true);
    }

    public MessageRouterConfiguration getMessageRouterConfiguration() {
        return this.getConfigurationOrLoad(MessageRouterConfiguration.class, false);
    }

    public GrpcConfiguration getGrpcConfiguration() {
        return this.getConfigurationManager().getConfigurationOrLoad(MAPPER, this.stringSubstitutor, GrpcConfiguration.class, false);
    }

    public GrpcRouterConfiguration getGrpcRouterConfiguration() {
        return this.getConfigurationOrLoad(GrpcRouterConfiguration.class, true);
    }

    public BoxConfiguration getBoxConfiguration() {
        return this.getConfigurationOrLoad(BoxConfiguration.class, true);
    }

    protected CradleConfidentialConfiguration getCradleConfidentialConfiguration() {
        return this.getConfigurationOrLoad(CradleConfidentialConfiguration.class, false);
    }

    protected CradleNonConfidentialConfiguration getCradleNonConfidentialConfiguration() {
        return this.getConfigurationOrLoad(CradleNonConfidentialConfiguration.class, true);
    }

    @Deprecated
    public CradleConfiguration getCradleConfiguration() {
        return new CradleConfiguration(this.getCradleConfidentialConfiguration(), this.getCradleNonConfidentialConfiguration());
    }

    public CradleManager getCradleManager() {
        return this.cradleManager.updateAndGet(manager -> {
            if (manager == null) {
                try {
                    CradleConfidentialConfiguration confidentialConfiguration = this.getCradleConfidentialConfiguration();
                    CradleNonConfidentialConfiguration nonConfidentialConfiguration = this.getCradleNonConfidentialConfiguration();
                    CassandraConnectionSettings cassandraConnectionSettings = new CassandraConnectionSettings(confidentialConfiguration.getDataCenter(), confidentialConfiguration.getHost(), confidentialConfiguration.getPort(), confidentialConfiguration.getKeyspace());
                    if (StringUtils.isNotEmpty((CharSequence)confidentialConfiguration.getUsername())) {
                        cassandraConnectionSettings.setUsername(confidentialConfiguration.getUsername());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)confidentialConfiguration.getPassword())) {
                        cassandraConnectionSettings.setPassword(confidentialConfiguration.getPassword());
                    }
                    if (nonConfidentialConfiguration.getTimeout() > 0L) {
                        cassandraConnectionSettings.setTimeout(nonConfidentialConfiguration.getTimeout());
                    }
                    if (nonConfidentialConfiguration.getPageSize() > 0) {
                        cassandraConnectionSettings.setResultPageSize(nonConfidentialConfiguration.getPageSize());
                    }
                    manager = new CassandraCradleManager(new CassandraConnection(cassandraConnectionSettings));
                    manager.init((String)StringUtils.defaultIfBlank((CharSequence)confidentialConfiguration.getCradleInstanceName(), (CharSequence)DEFAULT_CRADLE_INSTANCE_NAME), true, nonConfidentialConfiguration.getCradleMaxMessageBatchSize() > 0L ? nonConfidentialConfiguration.getCradleMaxMessageBatchSize() : 0x100000L, nonConfidentialConfiguration.getCradleMaxEventBatchSize() > 0L ? nonConfidentialConfiguration.getCradleMaxEventBatchSize() : 0x100000L);
                }
                catch (CradleStorageException | RuntimeException e) {
                    throw new CommonFactoryException("Cannot create Cradle manager", e);
                }
            }
            return manager;
        });
    }

    public <T> T getCustomConfiguration(Class<T> confClass, ObjectMapper customObjectMapper) {
        File configFile = this.getPathToCustomConfiguration().toFile();
        if (!configFile.exists()) {
            try {
                return confClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }
        return this.getConfiguration(this.getPathToCustomConfiguration(), confClass, customObjectMapper);
    }

    public <T> T getCustomConfiguration(Class<T> confClass) {
        return this.getCustomConfiguration(confClass, MAPPER);
    }

    public InputStream readDictionary() {
        return this.readDictionary(DictionaryType.MAIN);
    }

    public InputStream readDictionary(DictionaryType dictionaryType) {
        try {
            List dictionaries = null;
            Path dictionaryTypeDictionary = dictionaryType.getDictionary(this.getPathToDictionariesDir());
            if (Files.exists(dictionaryTypeDictionary, new LinkOption[0]) && Files.isDirectory(dictionaryTypeDictionary, new LinkOption[0])) {
                dictionaries = Files.list(dictionaryType.getDictionary(this.getPathToDictionariesDir())).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
            }
            if (dictionaries == null || dictionaries.isEmpty()) {
                dictionaries = Files.list(this.getOldPathToDictionariesDir()).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().contains(dictionaryType.name())).collect(Collectors.toList());
            }
            if (dictionaries.isEmpty()) {
                throw new IllegalStateException("No dictionary found with type '" + dictionaryType + "'");
            }
            if (dictionaries.size() > 1) {
                throw new IllegalStateException("Found several dictionaries satisfying the '" + dictionaryType + "' type");
            }
            Path targetDictionary = (Path)dictionaries.get(0);
            return new ByteArrayInputStream(ArchiveUtils.getGzipBase64StringDecoder().decode(Files.readString(targetDictionary)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not read dictionary", e);
        }
    }

    @Nullable
    public String getRootEventId() {
        return this.rootEventId.updateAndGet(id -> {
            if (id == null) {
                try {
                    String boxName = this.getBoxConfiguration().getBoxName();
                    if (boxName == null) {
                        return null;
                    }
                    com.exactpro.th2.common.grpc.Event rootEvent = Event.start().endTimestamp().name(boxName + " " + Instant.now()).description("Root event").status(Event.Status.PASSED).type("Microservice").toProtoEvent(null);
                    try {
                        this.getEventBatchRouter().sendAll(EventBatch.newBuilder().addEvents(rootEvent).build(), new String[0]);
                        return rootEvent.getId().getId();
                    }
                    catch (IOException e) {
                        throw new CommonFactoryException("Can not send root event", e);
                    }
                }
                catch (JsonProcessingException e) {
                    throw new CommonFactoryException("Can not create root event", e);
                }
            }
            return id;
        });
    }

    protected abstract ConfigurationManager getConfigurationManager();

    protected abstract Path getPathToCustomConfiguration();

    protected abstract Path getPathToDictionariesDir();

    protected abstract Path getOldPathToDictionariesDir();

    protected MessageRouterContext getMessageRouterContext() {
        return this.routerContext.updateAndGet(ctx -> {
            if (ctx == null) {
                try {
                    String rootEventId = this.getRootEventId();
                    MessageRouterMonitor contextMonitor = rootEventId == null ? new LogMessageRouterMonitor() : new BroadcastMessageRouterMonitor(new LogMessageRouterMonitor(), new EventMessageRouterMonitor(this.getEventBatchRouter(), rootEventId));
                    return new DefaultMessageRouterContext(this.getRabbitMqConnectionManager(), contextMonitor, this.getMessageRouterConfiguration());
                }
                catch (Exception e) {
                    throw new CommonFactoryException("Can not create message router context", e);
                }
            }
            return ctx;
        });
    }

    protected PrometheusConfiguration loadPrometheusConfiguration() {
        return this.getConfigurationOrLoad(PrometheusConfiguration.class, true);
    }

    protected ConnectionManager createRabbitMQConnectionManager() {
        return new ConnectionManager(this.getRabbitMqConfiguration(), this.getConnectionManagerConfiguration(), this.livenessMonitor::disable);
    }

    protected ConnectionManager getRabbitMqConnectionManager() {
        return this.rabbitMqConnectionManager.updateAndGet(connectionManager -> {
            if (connectionManager == null) {
                return this.createRabbitMQConnectionManager();
            }
            return connectionManager;
        });
    }

    @Override
    public void close() {
        LOGGER.info("Closing common factory");
        this.messageRouterParsedBatch.getAndUpdate(router -> {
            if (router != null) {
                try {
                    router.close();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to close message router for parsed message batches", (Throwable)e);
                }
            }
            return router;
        });
        this.messageRouterRawBatch.getAndUpdate(router -> {
            if (router != null) {
                try {
                    router.close();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to close message router for raw message batches", (Throwable)e);
                }
            }
            return router;
        });
        this.messageRouterMessageGroupBatch.getAndUpdate(router -> {
            if (router != null) {
                try {
                    router.close();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to close message router for message group batches", (Throwable)e);
                }
            }
            return router;
        });
        this.rabbitMqConnectionManager.updateAndGet(connection -> {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to close RabbitMQ connection", (Throwable)e);
                }
            }
            return connection;
        });
        this.grpcRouter.getAndUpdate(router -> {
            if (router != null) {
                try {
                    router.close();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to close gRPC router", (Throwable)e);
                }
            }
            return router;
        });
        this.customMessageRouters.forEach((messageType, router) -> {
            try {
                router.close();
            }
            catch (Exception e) {
                LOGGER.error("Failed to close custom router for {}", messageType, (Object)e);
            }
        });
        this.cradleManager.getAndUpdate(manager -> {
            if (manager != null) {
                try {
                    manager.dispose();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to dispose Cradle manager", (Throwable)e);
                }
            }
            return manager;
        });
        this.prometheusExporter.updateAndGet(server -> {
            if (server != null) {
                try {
                    server.stop();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to close Prometheus exporter", (Throwable)e);
                }
            }
            return null;
        });
        LOGGER.info("Common factory has been closed");
    }

    protected static void configureLogger(String ... paths) {
        ArrayList<String> listPath = new ArrayList<String>();
        listPath.add(LOG4J_PROPERTIES_DEFAULT_PATH);
        listPath.add(LOG4J_PROPERTIES_DEFAULT_PATH_OLD);
        listPath.addAll(Arrays.asList(Objects.requireNonNull(paths, "Paths can't be null")));
        listPath.stream().map(path -> Path.of(path, LOG4J_PROPERTIES_NAME)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().ifPresentOrElse(path -> {
            LogManager.resetConfiguration();
            PropertyConfigurator.configure((String)path.toString());
            LOGGER.info("Logger configuration from {} file is applied", path);
        }, () -> LOGGER.info("Neither of {} paths contains {} file. Use default configuration", (Object)listPath, (Object)LOG4J_PROPERTIES_NAME));
        AbstractCommonFactory.loggingManifests();
    }

    private static void loggingManifests() {
        try {
            Iterator<URL> urlIterator = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF").asIterator();
            StreamSupport.stream(Spliterators.spliteratorUnknownSize(urlIterator, 0), false).map(url -> {
                Manifest manifest;
                block8: {
                    InputStream inputStream = url.openStream();
                    try {
                        manifest = new Manifest(inputStream);
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            LOGGER.warn("Manifest '{}' loading failere", url, (Object)e);
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return manifest;
            }).filter(Objects::nonNull).map(Manifest::getMainAttributes).filter(attributes -> EXACTPRO_IMPLEMENTATION_VENDOR.equals(attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR))).forEach(attributes -> LOGGER.info("Manifest title {}, version {}", (Object)attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE), (Object)attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION)));
        }
        catch (IOException e) {
            LOGGER.warn("Manifest searching failure", (Throwable)e);
        }
    }

    static {
        MAPPER.registerModule((Module)new KotlinModule());
        MAPPER.registerModule((Module)new RoutingStrategyModule(MAPPER));
        LOGGER = LoggerFactory.getLogger(AbstractCommonFactory.class);
        AbstractCommonFactory.configureLogger(new String[0]);
    }
}

