/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.factory;

import com.exactpro.th2.common.grpc.EventBatch;
import com.exactpro.th2.common.grpc.MessageBatch;
import com.exactpro.th2.common.grpc.MessageGroupBatch;
import com.exactpro.th2.common.grpc.RawMessageBatch;
import com.exactpro.th2.common.metrics.PrometheusConfiguration;
import com.exactpro.th2.common.schema.box.configuration.BoxConfiguration;
import com.exactpro.th2.common.schema.configuration.ConfigurationManager;
import com.exactpro.th2.common.schema.cradle.CradleConfidentialConfiguration;
import com.exactpro.th2.common.schema.cradle.CradleNonConfidentialConfiguration;
import com.exactpro.th2.common.schema.dictionary.DictionaryType;
import com.exactpro.th2.common.schema.event.EventBatchRouter;
import com.exactpro.th2.common.schema.factory.AbstractCommonFactory;
import com.exactpro.th2.common.schema.factory.FactorySettings;
import com.exactpro.th2.common.schema.grpc.configuration.GrpcConfiguration;
import com.exactpro.th2.common.schema.grpc.configuration.GrpcRouterConfiguration;
import com.exactpro.th2.common.schema.grpc.router.GrpcRouter;
import com.exactpro.th2.common.schema.grpc.router.impl.DefaultGrpcRouter;
import com.exactpro.th2.common.schema.message.MessageRouter;
import com.exactpro.th2.common.schema.message.configuration.MessageRouterConfiguration;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.configuration.ConnectionManagerConfiguration;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.configuration.RabbitMQConfiguration;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.group.RabbitMessageGroupBatchRouter;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.parsed.RabbitParsedBatchRouter;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.raw.RabbitRawBatchRouter;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import kotlin.text.Charsets;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonFactory
extends AbstractCommonFactory {
    private static final Path CONFIG_DEFAULT_PATH = Path.of("/var/th2/config/", new String[0]);
    private static final String RABBIT_MQ_FILE_NAME = "rabbitMQ.json";
    private static final String ROUTER_MQ_FILE_NAME = "mq.json";
    private static final String GRPC_FILE_NAME = "grpc.json";
    private static final String ROUTER_GRPC_FILE_NAME = "grpc_router.json";
    private static final String CRADLE_CONFIDENTIAL_FILE_NAME = "cradle.json";
    private static final String PROMETHEUS_FILE_NAME = "prometheus.json";
    private static final String CUSTOM_FILE_NAME = "custom.json";
    private static final String BOX_FILE_NAME = "box.json";
    private static final String CONNECTION_MANAGER_CONF_FILE_NAME = "mq_router.json";
    private static final String CRADLE_NON_CONFIDENTIAL_FILE_NAME = "cradle_manager.json";
    private static final String DICTIONARY_DIR_NAME = "dictionary";
    private static final String RABBITMQ_SECRET_NAME = "rabbitmq";
    private static final String CASSANDRA_SECRET_NAME = "cassandra";
    private static final String RABBITMQ_PASSWORD_KEY = "rabbitmq-password";
    private static final String CASSANDRA_PASSWORD_KEY = "cassandra-password";
    private static final String KEY_RABBITMQ_PASS = "RABBITMQ_PASS";
    private static final String KEY_CASSANDRA_PASS = "CASSANDRA_PASS";
    private static final String GENERATED_CONFIG_DIR_NAME = "generated_configs";
    private final Path custom;
    private final Path dictionariesDir;
    private final Path oldDictionariesDir;
    private final ConfigurationManager configurationManager;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CommonFactory.class.getName());

    protected CommonFactory(Class<? extends MessageRouter<MessageBatch>> messageRouterParsedBatchClass, Class<? extends MessageRouter<RawMessageBatch>> messageRouterRawBatchClass, Class<? extends MessageRouter<MessageGroupBatch>> messageRouterMessageGroupBatchClass, Class<? extends MessageRouter<EventBatch>> eventBatchRouterClass, Class<? extends GrpcRouter> grpcRouterClass, @Nullable Path custom, @Nullable Path dictionariesDir, @Nullable Path oldDictionariesDir, Map<String, String> environmentVariables, ConfigurationManager configurationManager) {
        super(messageRouterParsedBatchClass, messageRouterRawBatchClass, messageRouterMessageGroupBatchClass, eventBatchRouterClass, grpcRouterClass, environmentVariables);
        this.custom = CommonFactory.defaultPathIfNull(custom, CUSTOM_FILE_NAME);
        this.dictionariesDir = CommonFactory.defaultPathIfNull(dictionariesDir, DICTIONARY_DIR_NAME);
        this.oldDictionariesDir = Objects.requireNonNullElse(oldDictionariesDir, CONFIG_DEFAULT_PATH);
        this.configurationManager = configurationManager;
        this.start();
    }

    public CommonFactory(FactorySettings settings) {
        this(settings.getMessageRouterParsedBatchClass(), settings.getMessageRouterRawBatchClass(), settings.getMessageRouterMessageGroupBatchClass(), settings.getEventBatchRouterClass(), settings.getGrpcRouterClass(), settings.getCustom(), settings.getDictionariesDir(), settings.getOldDictionariesDir(), settings.getVariables(), CommonFactory.createConfigurationManager(settings));
    }

    @Deprecated(since="3.10.0", forRemoval=true)
    public CommonFactory(Class<? extends MessageRouter<MessageBatch>> messageRouterParsedBatchClass, Class<? extends MessageRouter<RawMessageBatch>> messageRouterRawBatchClass, Class<? extends MessageRouter<MessageGroupBatch>> messageRouterMessageGroupBatchClass, Class<? extends MessageRouter<EventBatch>> eventBatchRouterClass, Class<? extends GrpcRouter> grpcRouterClass, Path rabbitMQ, Path routerMQ, Path routerGRPC, Path cradle, Path custom, Path prometheus, Path dictionariesDir, Path boxConfiguration) {
        this(new FactorySettings(messageRouterParsedBatchClass, messageRouterRawBatchClass, messageRouterMessageGroupBatchClass, eventBatchRouterClass, grpcRouterClass, rabbitMQ, routerMQ, null, routerGRPC, null, cradle, null, prometheus, boxConfiguration, custom, dictionariesDir));
    }

    @Deprecated(since="3.10.0", forRemoval=true)
    public CommonFactory(Path rabbitMQ, Path routerMQ, Path routerGRPC, Path cradle, Path custom, Path prometheus, Path dictionariesDir, Path boxConfiguration) {
        this(RabbitParsedBatchRouter.class, RabbitRawBatchRouter.class, RabbitMessageGroupBatchRouter.class, EventBatchRouter.class, DefaultGrpcRouter.class, rabbitMQ, routerMQ, routerGRPC, cradle, custom, dictionariesDir, prometheus, boxConfiguration);
    }

    @Deprecated(since="3.10.0", forRemoval=true)
    public CommonFactory(Class<? extends MessageRouter<MessageBatch>> messageRouterParsedBatchClass, Class<? extends MessageRouter<RawMessageBatch>> messageRouterRawBatchClass, Class<? extends MessageRouter<MessageGroupBatch>> messageRouterMessageGroupBatchClass, Class<? extends MessageRouter<EventBatch>> eventBatchRouterClass, Class<? extends GrpcRouter> grpcRouterClass) {
        this(new FactorySettings(messageRouterParsedBatchClass, messageRouterRawBatchClass, messageRouterMessageGroupBatchClass, eventBatchRouterClass, grpcRouterClass));
    }

    public CommonFactory() {
        this(new FactorySettings());
    }

    @Override
    protected Path getPathToCustomConfiguration() {
        return this.custom;
    }

    @Override
    protected Path getPathToDictionariesDir() {
        return this.dictionariesDir;
    }

    @Override
    protected Path getOldPathToDictionariesDir() {
        return this.oldDictionariesDir;
    }

    @Override
    protected ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public static CommonFactory createFromArguments(String ... args) {
        Options options = new Options();
        Option configOption = new Option("c", "configs", true, null);
        options.addOption(configOption);
        Option rabbitConfigurationOption = CommonFactory.createLongOption(options, "rabbitConfiguration");
        Option messageRouterConfigurationOption = CommonFactory.createLongOption(options, "messageRouterConfiguration");
        Option grpcRouterConfigurationOption = CommonFactory.createLongOption(options, "grpcRouterConfiguration");
        Option grpcConfigurationOption = CommonFactory.createLongOption(options, "grpcConfiguration");
        Option grpcRouterConfigOption = CommonFactory.createLongOption(options, "grpcRouterConfig");
        Option cradleConfigurationOption = CommonFactory.createLongOption(options, "cradleConfiguration");
        Option cradleConfidentialConfigurationOption = CommonFactory.createLongOption(options, "cradleConfidentialConfiguration");
        Option customConfigurationOption = CommonFactory.createLongOption(options, "customConfiguration");
        Option dictionariesDirOption = CommonFactory.createLongOption(options, "dictionariesDir");
        Option prometheusConfigurationOption = CommonFactory.createLongOption(options, "prometheusConfiguration");
        Option boxConfigurationOption = CommonFactory.createLongOption(options, "boxConfiguration");
        Option namespaceOption = CommonFactory.createLongOption(options, "namespace");
        Option boxNameOption = CommonFactory.createLongOption(options, "boxName");
        Option contextNameOption = CommonFactory.createLongOption(options, "contextName");
        Option dictionariesOption = CommonFactory.createLongOption(options, "dictionaries");
        dictionariesOption.setArgs(-2);
        Option connectionManagerConfigurationOption = CommonFactory.createLongOption(options, "connectionManagerConfiguration");
        Option cradleManagerConfigurationOption = CommonFactory.createLongOption(options, "cradleManagerConfiguration");
        try {
            CommandLine cmd = new DefaultParser().parse(options, args);
            String configs = cmd.getOptionValue(configOption.getLongOpt());
            if (cmd.hasOption(namespaceOption.getLongOpt()) && cmd.hasOption(boxNameOption.getLongOpt())) {
                String namespace = cmd.getOptionValue(namespaceOption.getLongOpt());
                String boxName = cmd.getOptionValue(boxNameOption.getLongOpt());
                String contextName = cmd.getOptionValue(contextNameOption.getLongOpt());
                HashMap<DictionaryType, String> dictionaries = new HashMap<DictionaryType, String>();
                if (cmd.hasOption(dictionariesOption.getLongOpt())) {
                    for (String singleDictionary : cmd.getOptionValues(dictionariesOption.getLongOpt())) {
                        DictionaryType type;
                        String[] keyValue = singleDictionary.split("=");
                        if (keyValue.length != 2 || StringUtils.isEmpty((CharSequence)keyValue[0].trim()) || StringUtils.isEmpty((CharSequence)keyValue[1].trim())) {
                            throw new IllegalStateException(String.format("Argument '%s' in '%s' option has wrong format.", singleDictionary, dictionariesOption.getLongOpt()));
                        }
                        String typeStr = keyValue[1].trim();
                        try {
                            type = DictionaryType.valueOf(typeStr.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalStateException("Can not find dictionary type = " + typeStr, e);
                        }
                        dictionaries.put(type, keyValue[0].trim());
                    }
                }
                return CommonFactory.createFromKubernetes(namespace, boxName, contextName, dictionaries);
            }
            if (configs != null) {
                CommonFactory.configureLogger(configs);
            }
            FactorySettings settings = new FactorySettings();
            settings.setRabbitMQ(CommonFactory.calculatePath(cmd, rabbitConfigurationOption, configs, RABBIT_MQ_FILE_NAME));
            settings.setRouterMQ(CommonFactory.calculatePath(cmd, messageRouterConfigurationOption, configs, ROUTER_MQ_FILE_NAME));
            settings.setConnectionManagerSettings(CommonFactory.calculatePath(cmd, connectionManagerConfigurationOption, configs, CONNECTION_MANAGER_CONF_FILE_NAME));
            settings.setGrpc(CommonFactory.calculatePath(cmd, grpcConfigurationOption, grpcRouterConfigurationOption, configs, GRPC_FILE_NAME));
            settings.setRouterGRPC(CommonFactory.calculatePath(cmd, grpcRouterConfigOption, configs, ROUTER_GRPC_FILE_NAME));
            settings.setCradleConfidential(CommonFactory.calculatePath(cmd, cradleConfidentialConfigurationOption, cradleConfigurationOption, configs, CRADLE_CONFIDENTIAL_FILE_NAME));
            settings.setCradleNonConfidential(CommonFactory.calculatePath(cmd, cradleManagerConfigurationOption, configs, CRADLE_NON_CONFIDENTIAL_FILE_NAME));
            settings.setPrometheus(CommonFactory.calculatePath(cmd, prometheusConfigurationOption, configs, PROMETHEUS_FILE_NAME));
            settings.setBoxConfiguration(CommonFactory.calculatePath(cmd, boxConfigurationOption, configs, BOX_FILE_NAME));
            settings.setCustom(CommonFactory.calculatePath(cmd, customConfigurationOption, configs, CUSTOM_FILE_NAME));
            settings.setDictionariesDir(CommonFactory.calculatePath(cmd, dictionariesDirOption, configs, DICTIONARY_DIR_NAME));
            String oldDictionariesDir = cmd.getOptionValue(dictionariesDirOption.getLongOpt());
            settings.setOldDictionariesDir(oldDictionariesDir == null ? (configs == null ? CONFIG_DEFAULT_PATH : Path.of(configs, new String[0])) : Path.of(oldDictionariesDir, new String[0]));
            return new CommonFactory(settings);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Incorrect arguments " + Arrays.toString(args), e);
        }
    }

    public static CommonFactory createFromKubernetes(String namespace, String boxName) {
        return CommonFactory.createFromKubernetes(namespace, boxName, null);
    }

    public static CommonFactory createFromKubernetes(String namespace, String boxName, @Nullable String contextName) {
        return CommonFactory.createFromKubernetes(namespace, boxName, contextName, Collections.emptyMap());
    }

    public static CommonFactory createFromKubernetes(String namespace, String boxName, @Nullable String contextName, @NotNull Map<DictionaryType, String> dictionaries) {
        CommonFactory commonFactory;
        block14: {
            Path configPath = Path.of(System.getProperty("user.dir"), GENERATED_CONFIG_DIR_NAME);
            Path dictionaryPath = configPath.resolve(DICTIONARY_DIR_NAME);
            Path boxConfigurationPath = configPath.resolve(BOX_FILE_NAME);
            FactorySettings settings = new FactorySettings();
            DefaultKubernetesClient client = contextName == null ? new DefaultKubernetesClient() : new DefaultKubernetesClient(Config.autoConfigure((String)contextName));
            DefaultKubernetesClient defaultKubernetesClient = client;
            try {
                Secret rabbitMqSecret = Objects.requireNonNull((Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(RABBITMQ_SECRET_NAME)).get(), "Secret 'rabbitmq' isn't found in namespace " + namespace);
                Secret cassandraSecret = Objects.requireNonNull((Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(CASSANDRA_SECRET_NAME)).get(), "Secret 'cassandra' isn't found in namespace " + namespace);
                String encodedRabbitMqPass = Objects.requireNonNull((String)rabbitMqSecret.getData().get(RABBITMQ_PASSWORD_KEY), "Key 'rabbitmq-password' not found in secret 'rabbitmq' in namespace " + namespace);
                String encodedCassandraPass = Objects.requireNonNull((String)cassandraSecret.getData().get(CASSANDRA_PASSWORD_KEY), "Key 'cassandra-password' not found in secret 'cassandra' in namespace " + namespace);
                String rabbitMqPassword = new String(Base64.getDecoder().decode(encodedRabbitMqPass));
                String cassandraPassword = new String(Base64.getDecoder().decode(encodedCassandraPass));
                settings.putVariable(KEY_RABBITMQ_PASS, rabbitMqPassword);
                settings.putVariable(KEY_CASSANDRA_PASS, cassandraPassword);
                MixedOperation configMaps = client.configMaps();
                Resource boxConfigMapResource = (Resource)((NonNamespaceOperation)configMaps.inNamespace(namespace)).withName(boxName + "-app-config");
                Resource rabbitMqConfigMapResource = (Resource)((NonNamespaceOperation)configMaps.inNamespace(namespace)).withName("rabbit-mq-external-app-config");
                Resource cradleConfigMapResource = (Resource)((NonNamespaceOperation)configMaps.inNamespace(namespace)).withName("cradle-external");
                if (boxConfigMapResource.get() == null) {
                    throw new IllegalArgumentException("Failed to find config maps by boxName " + boxName);
                }
                ConfigMap boxConfigMap = (ConfigMap)boxConfigMapResource.require();
                ConfigMap rabbitMqConfigMap = (ConfigMap)rabbitMqConfigMapResource.require();
                ConfigMap cradleConfigMap = (ConfigMap)cradleConfigMapResource.require();
                Map boxData = boxConfigMap.getData();
                Map rabbitMqData = rabbitMqConfigMap.getData();
                Map cradleConfigData = cradleConfigMap.getData();
                File generatedConfigsDirFile = configPath.toFile();
                if (generatedConfigsDirFile.mkdir()) {
                    LOGGER.info("Directory {} is created", (Object)configPath);
                } else {
                    LOGGER.info("All boxConf in the '{}' folder are overridden", (Object)configPath);
                }
                if (generatedConfigsDirFile.exists()) {
                    BoxConfiguration box = new BoxConfiguration();
                    box.setBoxName(boxName);
                    settings.setRabbitMQ(CommonFactory.writeFile(configPath, RABBIT_MQ_FILE_NAME, rabbitMqData));
                    settings.setRouterMQ(CommonFactory.writeFile(configPath, ROUTER_MQ_FILE_NAME, boxData));
                    settings.setConnectionManagerSettings(CommonFactory.writeFile(configPath, CONNECTION_MANAGER_CONF_FILE_NAME, boxData));
                    settings.setGrpc(CommonFactory.writeFile(configPath, GRPC_FILE_NAME, boxData));
                    settings.setRouterGRPC(CommonFactory.writeFile(configPath, ROUTER_GRPC_FILE_NAME, boxData));
                    settings.setCradleConfidential(CommonFactory.writeFile(configPath, CRADLE_CONFIDENTIAL_FILE_NAME, cradleConfigData));
                    settings.setCradleNonConfidential(CommonFactory.writeFile(configPath, CRADLE_NON_CONFIDENTIAL_FILE_NAME, boxData));
                    settings.setPrometheus(CommonFactory.writeFile(configPath, PROMETHEUS_FILE_NAME, boxData));
                    settings.setCustom(CommonFactory.writeFile(configPath, CUSTOM_FILE_NAME, boxData));
                    settings.setBoxConfiguration(boxConfigurationPath);
                    settings.setDictionariesDir(dictionaryPath);
                    String boxConfig = (String)boxData.get(BOX_FILE_NAME);
                    if (boxConfig != null) {
                        CommonFactory.writeFile(boxConfigurationPath, boxConfig);
                    } else {
                        CommonFactory.writeToJson(boxConfigurationPath, box);
                    }
                    CommonFactory.writeDictionaries(boxName, configPath, dictionaryPath, dictionaries, (ConfigMapList)configMaps.list());
                }
                commonFactory = new CommonFactory(settings);
                if (defaultKubernetesClient == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (defaultKubernetesClient != null) {
                        try {
                            defaultKubernetesClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new IllegalStateException(e);
                }
            }
            defaultKubernetesClient.close();
        }
        return commonFactory;
    }

    private static Path writeFile(Path configPath, String fileName, Map<String, String> configMap) throws IOException {
        Path file = configPath.resolve(fileName);
        CommonFactory.writeFile(file, configMap.get(fileName));
        return file;
    }

    private static void writeDictionaries(String boxName, Path oldDictionariesDir, Path dictionariesDir, Map<DictionaryType, String> dictionaries, ConfigMapList configMapList) throws IOException {
        for (ConfigMap configMap : configMapList.getItems()) {
            String configMapName = configMap.getMetadata().getName();
            if (!configMapName.startsWith(boxName) || !configMapName.endsWith("-dictionary")) continue;
            configMap.getData().forEach((fileName, base64) -> {
                try {
                    CommonFactory.writeFile(oldDictionariesDir.resolve((String)fileName), base64);
                }
                catch (IOException e) {
                    LOGGER.error("Can not write dictionary '{}' from config map with name '{}'", fileName, (Object)configMapName);
                }
            });
        }
        block1: for (Map.Entry entry : dictionaries.entrySet()) {
            DictionaryType type = (DictionaryType)((Object)entry.getKey());
            String dictionaryName = (String)entry.getValue();
            for (ConfigMap dictionaryConfigMap : configMapList.getItems()) {
                String configName = dictionaryConfigMap.getMetadata().getName();
                if (!configName.endsWith("-dictionary") || !configName.substring(0, configName.lastIndexOf(45)).equals(dictionaryName)) continue;
                Path dictionaryTypeDir = type.getDictionary(dictionariesDir);
                if (Files.notExists(dictionaryTypeDir, new LinkOption[0])) {
                    Files.createDirectories(dictionaryTypeDir, new FileAttribute[0]);
                } else if (!Files.isDirectory(dictionaryTypeDir, new LinkOption[0])) {
                    throw new IllegalStateException(String.format("Can not save dictionary '%s' with type '%s', because '%s' is not directory", new Object[]{dictionaryName, type, dictionaryTypeDir}));
                }
                Set fileNameSet = dictionaryConfigMap.getData().keySet();
                if (fileNameSet.size() != 1) {
                    throw new IllegalStateException(String.format("Can not save dictionary '%s' with type '%s', because can not find dictionary data in config map", new Object[]{dictionaryName, type}));
                }
                String fileName2 = fileNameSet.stream().findFirst().orElse(null);
                CommonFactory.writeFile(dictionaryTypeDir.resolve(fileName2), (String)dictionaryConfigMap.getData().get(fileName2));
                continue block1;
            }
        }
    }

    private static ConfigurationManager createConfigurationManager(FactorySettings settings) {
        HashMap<Class<BoxConfiguration>, Path> paths = new HashMap<Class<BoxConfiguration>, Path>();
        paths.put(RabbitMQConfiguration.class, CommonFactory.defaultPathIfNull(settings.getRabbitMQ(), RABBIT_MQ_FILE_NAME));
        paths.put(MessageRouterConfiguration.class, CommonFactory.defaultPathIfNull(settings.getRouterMQ(), ROUTER_MQ_FILE_NAME));
        paths.put(ConnectionManagerConfiguration.class, CommonFactory.defaultPathIfNull(settings.getConnectionManagerSettings(), CONNECTION_MANAGER_CONF_FILE_NAME));
        paths.put(GrpcConfiguration.class, CommonFactory.defaultPathIfNull(settings.getGrpc(), GRPC_FILE_NAME));
        paths.put(GrpcRouterConfiguration.class, CommonFactory.defaultPathIfNull(settings.getRouterGRPC(), ROUTER_GRPC_FILE_NAME));
        paths.put(CradleConfidentialConfiguration.class, CommonFactory.defaultPathIfNull(settings.getCradleConfidential(), CRADLE_CONFIDENTIAL_FILE_NAME));
        paths.put(CradleNonConfidentialConfiguration.class, CommonFactory.defaultPathIfNull(settings.getCradleNonConfidential(), CRADLE_NON_CONFIDENTIAL_FILE_NAME));
        paths.put(PrometheusConfiguration.class, CommonFactory.defaultPathIfNull(settings.getPrometheus(), PROMETHEUS_FILE_NAME));
        paths.put(BoxConfiguration.class, CommonFactory.defaultPathIfNull(settings.getBoxConfiguration(), BOX_FILE_NAME));
        return new ConfigurationManager(paths);
    }

    private static Path defaultPathIfNull(Path path, String name) {
        return path == null ? CONFIG_DEFAULT_PATH.resolve(name) : path;
    }

    private static void writeFile(Path path, String data) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            IOUtils.write((String)data, (OutputStream)outputStream, (Charset)Charsets.UTF_8);
        }
    }

    private static void writeToJson(Path path, Object object) throws IOException {
        File file = path.toFile();
        if (file.createNewFile() || file.exists()) {
            MAPPER.writeValue(file, object);
        }
    }

    private static Option createLongOption(Options options, String optionName) {
        Option option = new Option(null, optionName, true, null);
        options.addOption(option);
        return option;
    }

    private static Path calculatePath(String path, String configsPath, String fileName) {
        return path != null ? Path.of(path, new String[0]) : (configsPath != null ? Path.of(configsPath, fileName) : CONFIG_DEFAULT_PATH.resolve(fileName));
    }

    private static Path calculatePath(CommandLine cmd, Option option, String configs, String fileName) {
        return CommonFactory.calculatePath(cmd.getOptionValue(option.getLongOpt()), configs, fileName);
    }

    private static Path calculatePath(CommandLine cmd, Option current, Option deprecated, String configs, String fileName) {
        return CommonFactory.calculatePath((String)ObjectUtils.defaultIfNull((Object)cmd.getOptionValue(current.getLongOpt()), (Object)cmd.getOptionValue(deprecated.getLongOpt())), configs, fileName);
    }
}

