/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.filter.strategy.impl;

import com.exactpro.th2.common.schema.filter.strategy.FilterStrategy;
import com.exactpro.th2.common.schema.message.configuration.FieldFilterConfiguration;
import com.exactpro.th2.common.schema.message.configuration.RouterFilter;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractFilterStrategy<T extends Message>
implements FilterStrategy<T> {
    @Override
    public boolean verify(T message, RouterFilter routerFilter) {
        ListValuedMap msgFieldFilters = MultiMapUtils.newListValuedHashMap();
        msgFieldFilters.putAll(routerFilter.getMessage());
        msgFieldFilters.putAll(routerFilter.getMetadata());
        return this.checkValues(this.getFields(message), (MultiValuedMap<String, FieldFilterConfiguration>)msgFieldFilters);
    }

    @Override
    public boolean verify(T message, List<? extends RouterFilter> routerFilters) {
        for (RouterFilter routerFilter : routerFilters) {
            if (!this.verify(message, routerFilter)) continue;
            return true;
        }
        return false;
    }

    protected abstract Map<String, String> getFields(T var1);

    private boolean checkValues(Map<String, String> messageFields, MultiValuedMap<String, FieldFilterConfiguration> fieldFilters) {
        return fieldFilters.isEmpty() || fieldFilters.keys().stream().anyMatch(fieldName -> {
            String messageValue = (String)messageFields.get(fieldName);
            Collection filters = fieldFilters.get(fieldName);
            return !filters.isEmpty() && filters.stream().allMatch(filter2 -> this.checkValue(messageValue, (FieldFilterConfiguration)filter2));
        });
    }

    private boolean checkValue(String value, FieldFilterConfiguration filterConfiguration) {
        String valueInConf = filterConfiguration.getExpectedValue();
        switch (filterConfiguration.getOperation()) {
            case EQUAL: {
                return Objects.equals(value, valueInConf);
            }
            case NOT_EQUAL: {
                return !Objects.equals(value, valueInConf);
            }
            case EMPTY: {
                return StringUtils.isEmpty((CharSequence)value);
            }
            case NOT_EMPTY: {
                return StringUtils.isNotEmpty((CharSequence)value);
            }
            case WILDCARD: {
                return FilenameUtils.wildcardMatch((String)value, (String)valueInConf);
            }
        }
        return false;
    }
}

