/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.grpc.router;

import com.exactpro.th2.common.schema.grpc.configuration.GrpcConfiguration;
import com.exactpro.th2.common.schema.grpc.configuration.GrpcRouterConfiguration;
import com.exactpro.th2.common.schema.grpc.configuration.GrpcServerConfiguration;
import com.exactpro.th2.common.schema.grpc.router.GrpcRouter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.NettyServerBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGrpcRouter
implements GrpcRouter {
    protected static final long SERVER_SHUTDOWN_TIMEOUT_MS = 5000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGrpcRouter.class);
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("grpc-router-server-pool-%d").build();
    protected List<Server> servers = new ArrayList<Server>();
    protected GrpcConfiguration configuration;

    @Override
    public void init(GrpcRouterConfiguration configuration) {
        this.init(new GrpcConfiguration(), configuration);
    }

    @Override
    public void init(@NotNull GrpcConfiguration configuration, @NotNull GrpcRouterConfiguration routerConfiguration) {
        this.throwIsInit();
        this.configuration = Objects.requireNonNull(configuration);
    }

    @Override
    public Server startServer(BindableService ... services) {
        GrpcServerConfiguration serverConf = this.configuration.getServerConfiguration();
        if (serverConf == null) {
            throw new IllegalStateException("Can not find server configuration");
        }
        NettyServerBuilder builder = serverConf.getHost() == null ? NettyServerBuilder.forPort((int)serverConf.getPort()) : NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(serverConf.getHost(), serverConf.getPort()));
        ExecutorService executor = Executors.newFixedThreadPool(serverConf.getWorkers(), THREAD_FACTORY);
        NioEventLoopGroup eventLoop = new NioEventLoopGroup(serverConf.getWorkers(), (Executor)executor);
        builder = builder.workerEventLoopGroup((EventLoopGroup)eventLoop).bossEventLoopGroup((EventLoopGroup)eventLoop).channelType(NioServerSocketChannel.class);
        for (BindableService service : services) {
            builder.addService(service);
        }
        Server server = builder.build();
        this.servers.add(server);
        return server;
    }

    protected void throwIsInit() {
        if (this.configuration != null) {
            throw new IllegalStateException("Grpc router already init");
        }
    }

    @Override
    public void close() {
        for (Server server : this.servers) {
            try {
                LOGGER.info("Shutting down gRPC server");
                server.shutdown();
                if (!server.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("Failed to shutdown server '{}' in {} ms. Forcing shutdown...", (Object)server, (Object)5000L);
                    server.shutdownNow();
                }
                LOGGER.info("Server has been successfully shutdown: {}", (Object)server);
            }
            catch (Exception e) {
                LOGGER.error("Failed to shutdown server: {}", (Object)server, (Object)e);
            }
        }
    }
}

