/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.grpc.router.impl;

import com.exactpro.th2.common.schema.exception.InitGrpcRouterException;
import com.exactpro.th2.common.schema.grpc.configuration.GrpcEndpointConfiguration;
import com.exactpro.th2.common.schema.grpc.configuration.GrpcServiceConfiguration;
import com.exactpro.th2.common.schema.grpc.router.AbstractGrpcRouter;
import com.exactpro.th2.common.schema.grpc.router.impl.DefaultStubStorage;
import com.exactpro.th2.proto.service.generator.core.antlr.annotation.GrpcStub;
import com.exactpro.th2.service.RetryPolicy;
import com.exactpro.th2.service.StubStorage;
import com.google.protobuf.Message;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGrpcRouter
extends AbstractGrpcRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGrpcRouter.class);
    private final Map<Class<?>, Map<String, AbstractStub<?>>> stubs = new ConcurrentHashMap();
    private final Map<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private final Map<Class<?>, StubStorage<?>> stubsStorages = new ConcurrentHashMap();

    @Override
    public <T> T getService(@NotNull Class<T> cls) throws ClassNotFoundException {
        List implementations = ServiceLoader.load(Objects.requireNonNull(cls, "Services class can not be null")).stream().collect(Collectors.toList());
        if (implementations.size() > 1) {
            throw new IllegalStateException("Can not choose implementation. Fount " + implementations.size() + " implementations");
        }
        if (implementations.isEmpty()) {
            return this.getProxyService(cls);
        }
        Class th2ImplClass = ((ServiceLoader.Provider)implementations.get(0)).type();
        try {
            return (T)th2ImplClass.getConstructor(RetryPolicy.class, StubStorage.class).newInstance(this.configuration.getRetryConfiguration(), this.stubsStorages.computeIfAbsent(cls, key -> new DefaultStubStorage(this.getServiceConfig((Class<?>)key))));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Can not create new instance of service from class " + cls, e);
        }
    }

    protected <T> T getProxyService(Class<T> proxyService) {
        return (T)Proxy.newProxyInstance(proxyService.getClassLoader(), new Class[]{proxyService}, (o, method, args) -> {
            try {
                this.validateArgs(args);
                Message message = (Message)args[0];
                AbstractStub<?> stub = this.getGrpcStubToSend(proxyService, message);
                return stub.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(stub, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        });
    }

    protected void validateArgs(Object[] args) {
        if (args.length > 0) {
            Object secArg;
            Object firstArg = args[0];
            if (!(firstArg instanceof Message)) {
                throw new IllegalArgumentException("The first argument of the service method should be a protobuf Message");
            }
            if (args.length > 1 && !((secArg = args[1]) instanceof StreamObserver)) {
                throw new IllegalArgumentException("If the second argument of the service method is specified, then it should be a protobuf StreamObserver");
            }
        } else {
            throw new IllegalArgumentException("At least one argument must be provided to send the request");
        }
    }

    protected AbstractStub<?> getGrpcStubToSend(Class<?> proxyService, Message message) throws ClassNotFoundException {
        GrpcStub grpcStubAnn = proxyService.getAnnotation(GrpcStub.class);
        if (Objects.isNull(grpcStubAnn)) {
            throw new ClassNotFoundException("Provided service class not annotated by GrpcStub annotation: " + proxyService.getSimpleName());
        }
        return this.getStubInstanceOrCreate(proxyService, grpcStubAnn.value(), message);
    }

    protected <T extends AbstractStub> AbstractStub getStubInstanceOrCreate(Class<?> proxyService, Class<T> stubClass, Message message) {
        GrpcServiceConfiguration serviceConfig = this.getServiceConfig(proxyService);
        String endpointName = serviceConfig.getStrategy().getEndpoint(message);
        return this.stubs.computeIfAbsent(stubClass, key -> new ConcurrentHashMap()).computeIfAbsent(endpointName, key -> this.createStubInstance(stubClass, this.getOrCreateChannel((String)key, serviceConfig)));
    }

    protected GrpcServiceConfiguration getServiceConfig(Class<?> proxyService) {
        return this.configuration.getServices().values().stream().filter(sConfig -> {
            Object proxyClassName = proxyService.getName();
            if (proxyService.getSimpleName().startsWith("Async")) {
                int index = ((String)proxyClassName).lastIndexOf("Async");
                proxyClassName = ((String)proxyClassName).substring(0, index) + ((String)proxyClassName).substring(index + 5);
            }
            return sConfig.getServiceClass().getName().equals(proxyClassName);
        }).findFirst().orElseThrow(() -> new IllegalStateException("No services matching the provided class were found in the configuration: " + proxyService.getName()));
    }

    protected Channel getOrCreateChannel(String endpointName, GrpcServiceConfiguration serviceConfig) {
        return this.channels.computeIfAbsent(endpointName, key -> {
            GrpcEndpointConfiguration grpcServer = serviceConfig.getEndpoints().get(key);
            if (Objects.isNull(grpcServer)) {
                throw new IllegalStateException("No endpoint in configuration that matching the provided alias: " + key);
            }
            return ManagedChannelBuilder.forAddress((String)grpcServer.getHost(), (int)grpcServer.getPort()).usePlaintext().build();
        });
    }

    protected <T extends AbstractStub> AbstractStub createStubInstance(Class<T> stubClass, Channel channel) {
        try {
            Constructor<T> constr = stubClass.getDeclaredConstructor(Channel.class, CallOptions.class);
            constr.setAccessible(true);
            return (AbstractStub)constr.newInstance(channel, CallOptions.DEFAULT);
        }
        catch (NoSuchMethodException e) {
            throw new InitGrpcRouterException("Could not find constructor '(Channel,CallOptions)' in the provided stub class: " + stubClass, e);
        }
        catch (Exception e) {
            throw new InitGrpcRouterException("Something went wrong while creating stub instance: " + stubClass, e);
        }
    }
}

