/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.grpc.router.impl;

import com.exactpro.th2.common.schema.grpc.configuration.GrpcEndpointConfiguration;
import com.exactpro.th2.common.schema.grpc.configuration.GrpcServiceConfiguration;
import com.exactpro.th2.service.StubStorage;
import com.google.protobuf.Message;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.AbstractStub;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class DefaultStubStorage<T extends AbstractStub<T>>
implements StubStorage<T> {
    private final GrpcServiceConfiguration serviceConfiguration;
    private final Map<String, T> stubs = new ConcurrentHashMap<String, T>();

    public DefaultStubStorage(@NotNull GrpcServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = Objects.requireNonNull(serviceConfiguration, "Service configuration can not be null");
    }

    @NotNull
    public T getStub(@NotNull Message message, @NotNull AbstractStub.StubFactory<T> stubFactory) {
        String endpointLabel = this.serviceConfiguration.getStrategy().getEndpoint(message);
        return (T)this.stubs.computeIfAbsent(endpointLabel, key -> {
            GrpcEndpointConfiguration endpoint = this.serviceConfiguration.getEndpoints().get(key);
            if (Objects.isNull(endpoint)) {
                throw new IllegalStateException("No endpoint in the configuration that matches the provided alias: " + key);
            }
            return stubFactory.newStub((Channel)ManagedChannelBuilder.forAddress((String)endpoint.getHost(), (int)endpoint.getPort()).usePlaintext().build(), CallOptions.DEFAULT);
        });
    }
}

