/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.message.impl.rabbitmq;

import com.exactpro.th2.common.grpc.Direction;
import com.exactpro.th2.common.grpc.MessageGroupBatch;
import com.exactpro.th2.common.schema.message.configuration.RouterFilter;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.AbstractRabbitSubscriber;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRabbitBatchSubscriber<M extends Message, MB>
extends AbstractRabbitSubscriber<MB> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRabbitBatchSubscriber.class);
    private List<? extends RouterFilter> filters;
    private final int messageRecursionLimit;

    public AbstractRabbitBatchSubscriber(List<? extends RouterFilter> filters, int messageRecursionLimit) {
        this.filters = filters;
        if (messageRecursionLimit < 0) {
            throw new IllegalArgumentException("Recursion limit cannot be negative: " + messageRecursionLimit);
        }
        this.messageRecursionLimit = messageRecursionLimit;
    }

    @Override
    protected MB filter(MB batch) {
        if (this.filters.isEmpty()) {
            return batch;
        }
        ArrayList<M> messages = new ArrayList<M>(this.getMessages(batch));
        Iterator<M> each = messages.iterator();
        while (each.hasNext()) {
            Message msg = (Message)each.next();
            if (this.callFilterFunction(msg, this.filters)) continue;
            each.remove();
            LOGGER.debug("Message skipped because it did not satisfy filters: " + this.extractMetadata(msg));
        }
        return messages.isEmpty() ? null : (MB)this.createBatch(messages);
    }

    protected abstract List<M> getMessages(MB var1);

    protected abstract MB createBatch(List<M> var1);

    protected abstract Metadata extractMetadata(M var1);

    protected MessageGroupBatch parseEncodedBatch(byte[] body) throws IOException {
        CodedInputStream ins = CodedInputStream.newInstance((byte[])body);
        ins.setRecursionLimit(this.messageRecursionLimit);
        return MessageGroupBatch.parseFrom((CodedInputStream)ins);
    }

    protected static class Metadata {
        private final long sequence;
        private final String messageType;
        private final Direction direction;
        private final String sessionAlias;

        public Metadata(long sequence, String messageType, Direction direction, String sessionAlias) {
            this.sequence = sequence;
            this.messageType = messageType;
            this.direction = direction;
            this.sessionAlias = sessionAlias;
        }

        public long getSequence() {
            return this.sequence;
        }

        public String getMessageType() {
            return this.messageType;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String getSessionAlias() {
            return this.sessionAlias;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("sequence", this.sequence).append("messageType", (Object)this.messageType).append("sessionAlias", (Object)this.sessionAlias).append("direction", (Object)this.direction).toString();
        }
    }
}

