/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.message.impl.rabbitmq;

import com.exactpro.th2.common.schema.message.MessageSender;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.connection.ConnectionManager;
import io.prometheus.client.Counter;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRabbitSender<T>
implements MessageSender<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRabbitSender.class);
    private final AtomicReference<String> sendQueue = new AtomicReference();
    private final AtomicReference<String> exchangeName = new AtomicReference();
    private final AtomicReference<ConnectionManager> connectionManager = new AtomicReference();

    @Override
    public void init(@NotNull ConnectionManager connectionManager, @NotNull String exchangeName, @NotNull String sendQueue) {
        Objects.requireNonNull(connectionManager, "Connection can not be null");
        Objects.requireNonNull(exchangeName, "Exchange name can not be null");
        Objects.requireNonNull(sendQueue, "Send queue can not be null");
        if (this.connectionManager.get() != null && this.sendQueue.get() != null && this.exchangeName.get() != null) {
            throw new IllegalStateException("Sender is already initialize");
        }
        this.connectionManager.set(connectionManager);
        this.exchangeName.set(exchangeName);
        this.sendQueue.set(sendQueue);
    }

    protected abstract Counter getDeliveryCounter();

    protected abstract Counter getContentCounter();

    protected abstract int extractCountFrom(T var1);

    @Override
    public void send(T value) throws IOException {
        Objects.requireNonNull(value, "Value for send can not be null");
        Counter counter = this.getDeliveryCounter();
        counter.inc();
        Counter contentCounter = this.getContentCounter();
        contentCounter.inc((double)this.extractCountFrom(value));
        try {
            ConnectionManager connection = this.connectionManager.get();
            connection.basicPublish(this.exchangeName.get(), this.sendQueue.get(), null, this.valueToBytes(value));
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Message sent to exchangeName='{}', routing key='{}': '{}'", new Object[]{this.exchangeName, this.sendQueue, this.toShortTraceString(value)});
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Message sent to exchangeName='{}', routing key='{}': '{}'", new Object[]{this.exchangeName, this.sendQueue, this.toShortDebugString(value)});
            }
        }
        catch (Exception e) {
            throw new IOException("Can not send message: " + this.toShortDebugString(value), e);
        }
    }

    protected abstract String toShortTraceString(T var1);

    protected abstract String toShortDebugString(T var1);

    protected abstract byte[] valueToBytes(T var1);
}

