/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.message.impl.rabbitmq.custom;

import com.exactpro.th2.common.metrics.CommonMetrics;
import com.google.common.base.CaseFormat;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleCollector;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/custom/MetricsHolder;", "", "customTag", "", "labels", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "incomingDataCounter", "Lio/prometheus/client/Counter;", "getIncomingDataCounter", "()Lio/prometheus/client/Counter;", "incomingDeliveryCounter", "getIncomingDeliveryCounter", "outgoingDataCounter", "getOutgoingDataCounter", "outgoingDeliveryCounter", "getOutgoingDeliveryCounter", "processingTimer", "Lio/prometheus/client/Histogram;", "getProcessingTimer", "()Lio/prometheus/client/Histogram;", "common"})
public final class MetricsHolder {
    @NotNull
    private final Counter incomingDeliveryCounter;
    @NotNull
    private final Counter incomingDataCounter;
    @NotNull
    private final Histogram processingTimer;
    @NotNull
    private final Counter outgoingDeliveryCounter;
    @NotNull
    private final Counter outgoingDataCounter;

    @NotNull
    public final Counter getIncomingDeliveryCounter() {
        return this.incomingDeliveryCounter;
    }

    @NotNull
    public final Counter getIncomingDataCounter() {
        return this.incomingDataCounter;
    }

    @NotNull
    public final Histogram getProcessingTimer() {
        return this.processingTimer;
    }

    @NotNull
    public final Counter getOutgoingDeliveryCounter() {
        return this.outgoingDeliveryCounter;
    }

    @NotNull
    public final Counter getOutgoingDataCounter() {
        return this.outgoingDataCounter;
    }

    public MetricsHolder(@NotNull String customTag, @NotNull String[] labels) {
        Intrinsics.checkParameterIsNotNull((Object)customTag, (String)"customTag");
        Intrinsics.checkParameterIsNotNull((Object)labels, (String)"labels");
        String tag = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, StringsKt.decapitalize((String)customTag));
        SimpleCollector simpleCollector = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("th2_mq_incoming_" + tag + "_delivery_quantity")).labelNames(Arrays.copyOf(labels, labels.length))).help("The received Rabbit MQ delivery quantity")).register();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleCollector, (String)"Counter.build()\n        \u2026)\n            .register()");
        this.incomingDeliveryCounter = (Counter)simpleCollector;
        SimpleCollector simpleCollector2 = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("th2_mq_incoming_" + tag + "_data_quantity")).labelNames(Arrays.copyOf(labels, labels.length))).help("The received data quantity")).register();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleCollector2, (String)"Counter.build()\n        \u2026)\n            .register()");
        this.incomingDataCounter = (Counter)simpleCollector2;
        SimpleCollector simpleCollector3 = ((Counter.Builder)((Counter.Builder)Counter.build().name("th2_mq_outgoing_" + tag + "_delivery_quantity")).help("The number of sent Rabbit MQ messages")).register();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleCollector3, (String)"Counter.build()\n        \u2026)\n            .register()");
        this.outgoingDeliveryCounter = (Counter)simpleCollector3;
        SimpleCollector simpleCollector4 = ((Counter.Builder)((Counter.Builder)Counter.build().name("th2_mq_outgoing_" + tag + "_data_quantity")).help("The number of sent messages")).register();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleCollector4, (String)"Counter.build()\n        \u2026)\n            .register()");
        this.outgoingDataCounter = (Counter)simpleCollector4;
        SimpleCollector simpleCollector5 = ((Histogram.Builder)((Histogram.Builder)Histogram.build().buckets(Arrays.copyOf(CommonMetrics.DEFAULT_BUCKETS, CommonMetrics.DEFAULT_BUCKETS.length)).name("th2_mq_" + tag + "_processing_time")).help("Time spent to process a single delivery")).register();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleCollector5, (String)"Histogram.build()\n      \u2026)\n            .register()");
        this.processingTimer = (Histogram)simpleCollector5;
    }
}

