/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.message.impl.rabbitmq.custom;

import com.exactpro.th2.common.schema.message.FilterFunction;
import com.exactpro.th2.common.schema.message.MessageSender;
import com.exactpro.th2.common.schema.message.MessageSubscriber;
import com.exactpro.th2.common.schema.message.configuration.QueueConfiguration;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.AbstractRabbitQueue;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.AbstractRabbitSender;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.AbstractRabbitSubscriber;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.configuration.SubscribeTarget;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.connection.ConnectionManager;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.custom.MessageConverter;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.custom.MetricsHolder;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002\u0013\u0014B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/custom/RabbitCustomQueue;", "T", "", "Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/AbstractRabbitQueue;", "converter", "Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/custom/MessageConverter;", "metricsHolder", "Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/custom/MetricsHolder;", "(Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/custom/MessageConverter;Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/custom/MetricsHolder;)V", "createSender", "Lcom/exactpro/th2/common/schema/message/MessageSender;", "connectionManager", "Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/connection/ConnectionManager;", "queueConfiguration", "Lcom/exactpro/th2/common/schema/message/configuration/QueueConfiguration;", "createSubscriber", "Lcom/exactpro/th2/common/schema/message/MessageSubscriber;", "filterFunction", "Lcom/exactpro/th2/common/schema/message/FilterFunction;", "Sender", "Subscriber", "common"})
public final class RabbitCustomQueue<T>
extends AbstractRabbitQueue<T> {
    private final MessageConverter<T> converter;
    private final MetricsHolder metricsHolder;

    @Override
    @NotNull
    protected MessageSender<T> createSender(@NotNull ConnectionManager connectionManager, @NotNull QueueConfiguration queueConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)connectionManager, (String)"connectionManager");
        Intrinsics.checkParameterIsNotNull((Object)queueConfiguration, (String)"queueConfiguration");
        Sender<T> sender = new Sender<T>(this.converter, this.metricsHolder.getOutgoingDeliveryCounter(), this.metricsHolder.getOutgoingDataCounter());
        boolean bl = false;
        boolean bl2 = false;
        Sender<T> $this$apply = sender;
        boolean bl3 = false;
        $this$apply.init(connectionManager, queueConfiguration.getExchange(), queueConfiguration.getRoutingKey());
        return sender;
    }

    @Override
    @NotNull
    protected MessageSubscriber<T> createSubscriber(@NotNull ConnectionManager connectionManager, @NotNull QueueConfiguration queueConfiguration, @NotNull FilterFunction filterFunction) {
        Intrinsics.checkParameterIsNotNull((Object)connectionManager, (String)"connectionManager");
        Intrinsics.checkParameterIsNotNull((Object)queueConfiguration, (String)"queueConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)filterFunction, (String)"filterFunction");
        Subscriber<T> subscriber = new Subscriber<T>(this.converter, this.metricsHolder.getIncomingDeliveryCounter(), this.metricsHolder.getProcessingTimer(), this.metricsHolder.getIncomingDataCounter());
        boolean bl = false;
        boolean bl2 = false;
        Subscriber<T> $this$apply = subscriber;
        boolean bl3 = false;
        $this$apply.init(connectionManager, new SubscribeTarget(queueConfiguration.getQueue(), queueConfiguration.getRoutingKey(), queueConfiguration.getExchange()), filterFunction);
        return subscriber;
    }

    public RabbitCustomQueue(@NotNull MessageConverter<T> converter, @NotNull MetricsHolder metricsHolder) {
        Intrinsics.checkParameterIsNotNull(converter, (String)"converter");
        Intrinsics.checkParameterIsNotNull((Object)metricsHolder, (String)"metricsHolder");
        this.converter = converter;
        this.metricsHolder = metricsHolder;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u0007H\u0014J\b\u0010\u000f\u001a\u00020\u0007H\u0014J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/custom/RabbitCustomQueue$Sender;", "T", "", "Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/AbstractRabbitSender;", "converter", "Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/custom/MessageConverter;", "deliveryCounter", "Lio/prometheus/client/Counter;", "dataCounter", "(Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/custom/MessageConverter;Lio/prometheus/client/Counter;Lio/prometheus/client/Counter;)V", "extractCountFrom", "", "batch", "(Ljava/lang/Object;)I", "getContentCounter", "getDeliveryCounter", "toShortDebugString", "", "value", "(Ljava/lang/Object;)Ljava/lang/String;", "toShortTraceString", "valueToBytes", "", "(Ljava/lang/Object;)[B", "common"})
    private static final class Sender<T>
    extends AbstractRabbitSender<T> {
        private final MessageConverter<T> converter;
        private final Counter deliveryCounter;
        private final Counter dataCounter;

        @Override
        @NotNull
        protected byte[] valueToBytes(@NotNull T value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return this.converter.toByteArray(value);
        }

        @Override
        @NotNull
        protected String toShortTraceString(@NotNull T value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return this.converter.toTraceString(value);
        }

        @Override
        @NotNull
        protected String toShortDebugString(@NotNull T value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return this.converter.toDebugString(value);
        }

        @Override
        @NotNull
        protected Counter getDeliveryCounter() {
            return this.deliveryCounter;
        }

        @Override
        @NotNull
        protected Counter getContentCounter() {
            return this.dataCounter;
        }

        @Override
        protected int extractCountFrom(@NotNull T batch) {
            Intrinsics.checkParameterIsNotNull(batch, (String)"batch");
            return this.converter.extractCount(batch);
        }

        public Sender(@NotNull MessageConverter<T> converter, @NotNull Counter deliveryCounter, @NotNull Counter dataCounter) {
            Intrinsics.checkParameterIsNotNull(converter, (String)"converter");
            Intrinsics.checkParameterIsNotNull((Object)deliveryCounter, (String)"deliveryCounter");
            Intrinsics.checkParameterIsNotNull((Object)dataCounter, (String)"dataCounter");
            this.converter = converter;
            this.deliveryCounter = deliveryCounter;
            this.dataCounter = dataCounter;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B+\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00028\u00012\u0006\u0010\u0015\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0014J\b\u0010\u0018\u001a\u00020\u0007H\u0014J\b\u0010\u0019\u001a\u00020\tH\u0014J\u0015\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/custom/RabbitCustomQueue$Subscriber;", "T", "", "Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/AbstractRabbitSubscriber;", "converter", "Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/custom/MessageConverter;", "deliveryCounter", "Lio/prometheus/client/Counter;", "timer", "Lio/prometheus/client/Histogram;", "dataCounter", "(Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/custom/MessageConverter;Lio/prometheus/client/Counter;Lio/prometheus/client/Histogram;Lio/prometheus/client/Counter;)V", "extractCountFrom", "", "batch", "(Ljava/lang/Object;)I", "extractLabels", "", "", "(Ljava/lang/Object;)[Ljava/lang/String;", "filter", "value", "(Ljava/lang/Object;)Ljava/lang/Object;", "getContentCounter", "getDeliveryCounter", "getProcessingTimer", "toShortDebugString", "(Ljava/lang/Object;)Ljava/lang/String;", "toShortTraceString", "valueFromBytes", "", "body", "", "common"})
    private static final class Subscriber<T>
    extends AbstractRabbitSubscriber<T> {
        private final MessageConverter<T> converter;
        private final Counter deliveryCounter;
        private final Histogram timer;
        private final Counter dataCounter;

        @Override
        @NotNull
        protected List<T> valueFromBytes(@NotNull byte[] body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            return CollectionsKt.listOf(this.converter.fromByteArray(body));
        }

        @Override
        @NotNull
        protected String toShortTraceString(@NotNull T value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return this.converter.toTraceString(value);
        }

        @Override
        @NotNull
        protected String toShortDebugString(@NotNull T value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return this.converter.toDebugString(value);
        }

        @Override
        @NotNull
        protected T filter(@NotNull T value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return value;
        }

        @Override
        @NotNull
        protected Counter getDeliveryCounter() {
            return this.deliveryCounter;
        }

        @Override
        @NotNull
        protected Counter getContentCounter() {
            return this.dataCounter;
        }

        @Override
        @NotNull
        protected Histogram getProcessingTimer() {
            return this.timer;
        }

        @Override
        protected int extractCountFrom(@NotNull T batch) {
            Intrinsics.checkParameterIsNotNull(batch, (String)"batch");
            return this.converter.extractCount(batch);
        }

        @Override
        @NotNull
        protected String[] extractLabels(@NotNull T batch) {
            Intrinsics.checkParameterIsNotNull(batch, (String)"batch");
            return this.converter.getLabels(batch);
        }

        public Subscriber(@NotNull MessageConverter<T> converter, @NotNull Counter deliveryCounter, @NotNull Histogram timer, @NotNull Counter dataCounter) {
            Intrinsics.checkParameterIsNotNull(converter, (String)"converter");
            Intrinsics.checkParameterIsNotNull((Object)deliveryCounter, (String)"deliveryCounter");
            Intrinsics.checkParameterIsNotNull((Object)timer, (String)"timer");
            Intrinsics.checkParameterIsNotNull((Object)dataCounter, (String)"dataCounter");
            this.converter = converter;
            this.deliveryCounter = deliveryCounter;
            this.timer = timer;
            this.dataCounter = dataCounter;
        }
    }
}

