/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.message.impl.rabbitmq.group;

import com.exactpro.th2.common.grpc.AnyMessage;
import com.exactpro.th2.common.grpc.MessageGroup;
import com.exactpro.th2.common.grpc.MessageGroupBatch;
import com.exactpro.th2.common.message.MessageUtils;
import com.exactpro.th2.common.metrics.CommonMetrics;
import com.exactpro.th2.common.schema.message.configuration.RouterFilter;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.AbstractRabbitBatchSubscriber;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.group.RabbitMessageGroupBatchSubscriber;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 %2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001%B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\f\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0014J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000f\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0003H\u0014J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0003H\u0014J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010#\u001a\u00020$H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/group/RabbitMessageGroupBatchSubscriber;", "Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/AbstractRabbitBatchSubscriber;", "Lcom/exactpro/th2/common/grpc/MessageGroup;", "Lcom/exactpro/th2/common/grpc/MessageGroupBatch;", "filters", "", "Lcom/exactpro/th2/common/schema/message/configuration/RouterFilter;", "messageRecursionLimit", "", "(Ljava/util/List;I)V", "logger", "Lmu/KLogger;", "createBatch", "messages", "extractCountFrom", "batch", "extractLabels", "", "", "(Lcom/exactpro/th2/common/grpc/MessageGroupBatch;)[Ljava/lang/String;", "extractMetadata", "Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/AbstractRabbitBatchSubscriber$Metadata;", "messageGroup", "filter", "getContentCounter", "Lio/prometheus/client/Counter;", "getDeliveryCounter", "getMessages", "", "getProcessingTimer", "Lio/prometheus/client/Histogram;", "toShortDebugString", "value", "toShortTraceString", "valueFromBytes", "body", "", "Companion", "common"})
public final class RabbitMessageGroupBatchSubscriber
extends AbstractRabbitBatchSubscriber<MessageGroup, MessageGroupBatch> {
    private final KLogger logger;
    private final List<RouterFilter> filters;
    private static final Counter INCOMING_MSG_GROUP_BATCH_QUANTITY;
    private static final Counter INCOMING_MSG_GROUP_QUANTITY;
    private static final Histogram MSG_GROUP_PROCESSING_TIME;
    public static final Companion Companion;

    @Override
    @NotNull
    protected Counter getDeliveryCounter() {
        Counter counter = INCOMING_MSG_GROUP_BATCH_QUANTITY;
        Intrinsics.checkExpressionValueIsNotNull((Object)counter, (String)"INCOMING_MSG_GROUP_BATCH_QUANTITY");
        return counter;
    }

    @Override
    @NotNull
    protected Counter getContentCounter() {
        Counter counter = INCOMING_MSG_GROUP_QUANTITY;
        Intrinsics.checkExpressionValueIsNotNull((Object)counter, (String)"INCOMING_MSG_GROUP_QUANTITY");
        return counter;
    }

    @Override
    @NotNull
    protected Histogram getProcessingTimer() {
        Histogram histogram = MSG_GROUP_PROCESSING_TIME;
        Intrinsics.checkExpressionValueIsNotNull((Object)histogram, (String)"MSG_GROUP_PROCESSING_TIME");
        return histogram;
    }

    @Override
    @NotNull
    protected String[] extractLabels(@NotNull MessageGroupBatch batch) {
        AnyMessage message;
        Intrinsics.checkParameterIsNotNull((Object)batch, (String)"batch");
        AnyMessage anyMessage = message = (AnyMessage)this.getMessages(batch).get(0).getMessagesList().get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)anyMessage, (String)"message");
        return MessageUtils.getSessionAliasAndDirection(anyMessage);
    }

    @Override
    protected int extractCountFrom(@NotNull MessageGroupBatch batch) {
        Intrinsics.checkParameterIsNotNull((Object)batch, (String)"batch");
        return batch.getGroupsCount();
    }

    @Override
    @NotNull
    protected List<MessageGroupBatch> valueFromBytes(@NotNull byte[] body) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        return CollectionsKt.listOf((Object)this.parseEncodedBatch(body));
    }

    @Override
    @NotNull
    protected List<MessageGroup> getMessages(@NotNull MessageGroupBatch batch) {
        Intrinsics.checkParameterIsNotNull((Object)batch, (String)"batch");
        List list = batch.getGroupsList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"batch.groupsList");
        return list;
    }

    @Override
    @NotNull
    protected MessageGroupBatch createBatch(@NotNull List<MessageGroup> messages) {
        Intrinsics.checkParameterIsNotNull(messages, (String)"messages");
        MessageGroupBatch messageGroupBatch = MessageGroupBatch.newBuilder().addAllGroups((Iterable)messages).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageGroupBatch, (String)"MessageGroupBatch.newBui\u2026lGroups(messages).build()");
        return messageGroupBatch;
    }

    @Override
    @NotNull
    protected String toShortTraceString(@NotNull MessageGroupBatch value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return MessageUtils.toJson$default((MessageOrBuilder)value, false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected String toShortDebugString(@NotNull MessageGroupBatch value) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Object object = this;
        StringBuilder stringBuilder = new StringBuilder().append("MessageGroupBatch: ");
        boolean bl = false;
        boolean bl2 = false;
        RabbitMessageGroupBatchSubscriber $this$run = object;
        boolean bl3 = false;
        Object e = value.getGroupsList().get(0);
        Intrinsics.checkExpressionValueIsNotNull(e, (String)"value.groupsList[0]");
        Object e2 = ((MessageGroup)e).getMessagesList().get(0);
        Intrinsics.checkExpressionValueIsNotNull(e2, (String)"value.groupsList[0].messagesList[0]");
        String[] sessionAliasAndDirection = MessageUtils.getSessionAliasAndDirection((AnyMessage)e2);
        Object object2 = "session alias = " + sessionAliasAndDirection[0] + ", direction = " + sessionAliasAndDirection[1];
        StringBuilder stringBuilder2 = stringBuilder.append((String)object2);
        List list = value.getGroupsList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"value.groupsList");
        object = list;
        stringBuilder = stringBuilder2;
        boolean $i$f$flatMap = false;
        void var4_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MessageGroup it = (MessageGroup)element$iv$iv;
            boolean bl4 = false;
            MessageGroup messageGroup = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)messageGroup, (String)"it");
            Iterable list$iv$iv = messageGroup.getMessagesList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        object2 = (List)destination$iv$iv;
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((Iterable)object2), null, (CharSequence)", sequences = ", null, (int)0, null, (Function1)toShortDebugString.3.INSTANCE, (int)29, null)).toString();
    }

    @Override
    @NotNull
    protected AbstractRabbitBatchSubscriber.Metadata extractMetadata(@NotNull MessageGroup messageGroup) {
        Intrinsics.checkParameterIsNotNull((Object)messageGroup, (String)"messageGroup");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    @Nullable
    protected MessageGroupBatch filter(@NotNull MessageGroupBatch batch) {
        Intrinsics.checkParameterIsNotNull((Object)batch, (String)"batch");
        if (this.filters.isEmpty()) {
            return batch;
        }
        List groups2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getMessages(batch)), (Function1)((Function1)new Function1<MessageGroup, Boolean>(this){
            final /* synthetic */ RabbitMessageGroupBatchSubscriber this$0;

            public final boolean invoke(@NotNull MessageGroup group) {
                boolean bl;
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
                    List list = group.getMessagesList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"group.messagesList");
                    Iterable $this$all$iv = list;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            AnyMessage message = (AnyMessage)element$iv;
                            boolean bl2 = false;
                            if (RabbitMessageGroupBatchSubscriber.access$callFilterFunction(this.this$0, (Message)message, RabbitMessageGroupBatchSubscriber.access$getFilters$p(this.this$0))) continue;
                            bl = false;
                            break block4;
                        }
                        bl = true;
                    }
                }
                boolean bl3 = bl;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean allMessagesMatch = bl3;
                boolean bl6 = false;
                if (!allMessagesMatch) {
                    RabbitMessageGroupBatchSubscriber.access$getLogger$p(this.this$0).debug((Function0)new Function0<String>(this, group){
                        final /* synthetic */ filter.groups.1 this$0;
                        final /* synthetic */ MessageGroup $group$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$group$inlined = messageGroup;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Skipped message group because none or some of its messages didn't match any filters: " + MessageUtils.toJson$default((MessageOrBuilder)this.$group$inlined, false, 1, null);
                        }
                    });
                }
                return bl3;
            }
            {
                this.this$0 = rabbitMessageGroupBatchSubscriber;
                super(1);
            }
        })));
        return groups2.isEmpty() ? null : this.createBatch((List<MessageGroup>)groups2);
    }

    public RabbitMessageGroupBatchSubscriber(@NotNull List<? extends RouterFilter> filters, int messageRecursionLimit) {
        Intrinsics.checkParameterIsNotNull(filters, (String)"filters");
        super(filters, messageRecursionLimit);
        this.filters = filters;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        INCOMING_MSG_GROUP_BATCH_QUANTITY = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("th2_mq_incoming_msg_group_batch_quantity")).labelNames(new String[]{"session_alias", "direction"})).help("Quantity of incoming message group batches")).register();
        INCOMING_MSG_GROUP_QUANTITY = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("th2_mq_incoming_msg_group_quantity")).labelNames(new String[]{"session_alias", "direction"})).help("Quantity of incoming message groups")).register();
        MSG_GROUP_PROCESSING_TIME = (Histogram)Histogram.build((String)"th2_mq_msg_group_processing_time", (String)"Time of processing message groups").buckets(Arrays.copyOf(CommonMetrics.DEFAULT_BUCKETS, CommonMetrics.DEFAULT_BUCKETS.length)).register();
    }

    public static final /* synthetic */ boolean access$callFilterFunction(RabbitMessageGroupBatchSubscriber $this, Message message, List filters) {
        return $this.callFilterFunction(message, filters);
    }

    public static final /* synthetic */ List access$getFilters$p(RabbitMessageGroupBatchSubscriber $this) {
        return $this.filters;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(RabbitMessageGroupBatchSubscriber $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/exactpro/th2/common/schema/message/impl/rabbitmq/group/RabbitMessageGroupBatchSubscriber$Companion;", "", "()V", "INCOMING_MSG_GROUP_BATCH_QUANTITY", "Lio/prometheus/client/Counter;", "kotlin.jvm.PlatformType", "INCOMING_MSG_GROUP_QUANTITY", "MSG_GROUP_PROCESSING_TIME", "Lio/prometheus/client/Histogram;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

