/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.message.impl.rabbitmq.parsed;

import com.exactpro.th2.common.grpc.AnyMessage;
import com.exactpro.th2.common.grpc.Message;
import com.exactpro.th2.common.grpc.MessageBatch;
import com.exactpro.th2.common.grpc.MessageGroup;
import com.exactpro.th2.common.grpc.MessageGroupBatch;
import com.exactpro.th2.common.message.MessageUtils;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.AbstractRabbitSender;
import com.google.protobuf.MessageOrBuilder;
import io.prometheus.client.Counter;
import java.util.stream.Collectors;

public class RabbitParsedBatchSender
extends AbstractRabbitSender<MessageBatch> {
    private static final Counter OUTGOING_PARSED_MSG_BATCH_QUANTITY = (Counter)Counter.build((String)"th2_mq_outgoing_parsed_msg_batch_quantity", (String)"Quantity of outgoing parsed message batches").register();
    private static final Counter OUTGOING_PARSED_MSG_QUANTITY = (Counter)Counter.build((String)"th2_mq_outgoing_parsed_msg_quantity", (String)"Quantity of outgoing parsed messages").register();

    @Override
    protected Counter getDeliveryCounter() {
        return OUTGOING_PARSED_MSG_BATCH_QUANTITY;
    }

    @Override
    protected Counter getContentCounter() {
        return OUTGOING_PARSED_MSG_QUANTITY;
    }

    @Override
    protected int extractCountFrom(MessageBatch batch) {
        return batch.getMessagesCount();
    }

    @Override
    protected byte[] valueToBytes(MessageBatch value) {
        MessageGroup.Builder groupBuilder = MessageGroup.newBuilder();
        for (Message message : value.getMessagesList()) {
            AnyMessage anyMessage = AnyMessage.newBuilder().setMessage(message).build();
            groupBuilder.addMessages(anyMessage);
        }
        MessageGroupBatch.Builder batchBuilder = MessageGroupBatch.newBuilder();
        MessageGroup group = groupBuilder.build();
        return batchBuilder.addGroups(group).build().toByteArray();
    }

    @Override
    protected String toShortTraceString(MessageBatch value) {
        return MessageUtils.toJson((MessageOrBuilder)value);
    }

    @Override
    protected String toShortDebugString(MessageBatch value) {
        return MessageUtils.getDebugString(this.getClass().getSimpleName(), value.getMessagesList().stream().map(message -> message.getMetadata().getId()).collect(Collectors.toList()));
    }
}

