/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.message.impl.rabbitmq.parsed;

import com.exactpro.th2.common.grpc.AnyMessage;
import com.exactpro.th2.common.grpc.Message;
import com.exactpro.th2.common.grpc.MessageBatch;
import com.exactpro.th2.common.grpc.MessageGroup;
import com.exactpro.th2.common.grpc.MessageGroupBatch;
import com.exactpro.th2.common.grpc.MessageID;
import com.exactpro.th2.common.grpc.MessageMetadata;
import com.exactpro.th2.common.message.MessageUtils;
import com.exactpro.th2.common.metrics.CommonMetrics;
import com.exactpro.th2.common.schema.message.configuration.RouterFilter;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.AbstractRabbitBatchSubscriber;
import com.google.protobuf.MessageOrBuilder;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RabbitParsedBatchSubscriber
extends AbstractRabbitBatchSubscriber<Message, MessageBatch> {
    private static final Counter INCOMING_PARSED_MSG_BATCH_QUANTITY = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("th2_mq_incoming_parsed_msg_batch_quantity")).labelNames(new String[]{"session_alias", "direction"})).help("Quantity of incoming parsed message batches")).register();
    private static final Counter INCOMING_PARSED_MSG_QUANTITY = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("th2_mq_incoming_parsed_msg_quantity")).labelNames(new String[]{"session_alias", "direction"})).help("Quantity of incoming parsed messages")).register();
    private static final Histogram PARSED_MSG_PROCESSING_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build().buckets(CommonMetrics.DEFAULT_BUCKETS).name("th2_mq_parsed_msg_processing_time")).help("Time of processing parsed messages")).register();

    @Override
    protected Counter getDeliveryCounter() {
        return INCOMING_PARSED_MSG_BATCH_QUANTITY;
    }

    @Override
    protected Counter getContentCounter() {
        return INCOMING_PARSED_MSG_QUANTITY;
    }

    @Override
    protected Histogram getProcessingTimer() {
        return PARSED_MSG_PROCESSING_TIME;
    }

    @Override
    protected String[] extractLabels(MessageBatch batch) {
        MessageID messageID = this.getMessages(batch).get(0).getMetadata().getId();
        return MessageUtils.getSessionAliasAndDirection(messageID);
    }

    @Override
    protected int extractCountFrom(MessageBatch batch) {
        return batch.getMessagesCount();
    }

    public RabbitParsedBatchSubscriber(List<? extends RouterFilter> filters, int messageRecursionLimit) {
        super(filters, messageRecursionLimit);
    }

    @Override
    protected List<MessageBatch> valueFromBytes(byte[] body) throws Exception {
        MessageGroupBatch groupBatch = this.parseEncodedBatch(body);
        List messageGroups = groupBatch.getGroupsList();
        ArrayList<MessageBatch> parsedBatches = new ArrayList<MessageBatch>(messageGroups.size());
        for (MessageGroup group : messageGroups) {
            MessageBatch.Builder builder = MessageBatch.newBuilder();
            for (AnyMessage message : group.getMessagesList()) {
                if (message.getKindCase() != AnyMessage.KindCase.MESSAGE) {
                    throw new IllegalStateException("Message group batch contains raw messages: " + MessageUtils.toJson((MessageOrBuilder)groupBatch));
                }
                builder.addMessages(message.getMessage());
            }
            parsedBatches.add(builder.build());
        }
        return parsedBatches;
    }

    @Override
    protected List<Message> getMessages(MessageBatch batch) {
        return batch.getMessagesList();
    }

    @Override
    protected MessageBatch createBatch(List<Message> messages) {
        return MessageBatch.newBuilder().addAllMessages(messages).build();
    }

    @Override
    protected String toShortTraceString(MessageBatch value) {
        return MessageUtils.toJson((MessageOrBuilder)value);
    }

    @Override
    protected String toShortDebugString(MessageBatch value) {
        return MessageUtils.getDebugString(this.getClass().getSimpleName(), value.getMessagesList().stream().map(message -> message.getMetadata().getId()).collect(Collectors.toList()));
    }

    @Override
    protected AbstractRabbitBatchSubscriber.Metadata extractMetadata(Message message) {
        MessageMetadata metadata = message.getMetadata();
        MessageID messageID = metadata.getId();
        return new AbstractRabbitBatchSubscriber.Metadata(messageID.getSequence(), metadata.getMessageType(), messageID.getDirection(), messageID.getConnectionId().getSessionAlias());
    }
}

